package cn.benma666.sjzt.rabbit;


import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.myutils.StringUtil;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import lombok.Getter;
import lombok.Setter;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

@Getter
@Setter
public class RabbitMQClient {
    /**
     * 通道
     */
    private Channel channel;
    /**
     * 连接
     */
    private Connection connection;


    public RabbitMQClient(SysSjglSjzt sjzt) throws IOException, TimeoutException {
            this.connection = createConnection(sjzt);
            this.channel = connection.createChannel();
    }


    /**
     * 创建连接
     * @param sjzt
     * @return
     * @throws IOException
     * @throws TimeoutException
     */
    private static Connection createConnection(SysSjglSjzt sjzt) throws IOException, TimeoutException {
        ConnectionFactory factory = new ConnectionFactory();
        String ljc = sjzt.getLjc();
        String[] split = ljc.split(":");
        factory.setHost(split[0]);
        factory.setPort(Integer.parseInt(split[1]));
        //虚拟机 默认 /
        factory.setVirtualHost(StringUtil.isEmpty(sjzt.getDxgs()) ? "/" : sjzt.getDxgs());
        factory.setUsername(sjzt.getYhm());
        factory.setPassword(sjzt.getMm());
        return factory.newConnection();
    }

    /**
     * 关闭连接
     */
    public void close(){
        try {
            this.channel.close();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TimeoutException e) {
            e.printStackTrace();
        }
        try {
            this.connection.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
