package cn.benma666.sjzt.mqtt;

import cn.benma666.sjzt.BasicFile;
import cn.benma666.sjzt.BasicSjzt;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * mqtt文件对象
 */
@Setter
@Getter
public class MqttFile extends BasicFile {

    private String name;
    private MqttMessage file;
    private MqttQos qos = MqttQos.ZSYC;

    public MqttFile(String parent, MqttQos qos) {
        super(parent,null);
        this.qos = qos;
    }
    public MqttFile(String parent, MqttMessage file, BasicSjzt sjzt,String name) {
        super(parent, sjzt);
        this.file = file;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long lastModified() {
        //从消息中没找到
        return System.currentTimeMillis();
    }

    public MqttMessage getFile() {
        return file;
    }
}
