package cn.benma666.sjzt.mqtt;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@Slf4j
public class MqttCallBack implements MqttCallback{

    /**
     * 与服务器断开的回调
     */
    @Override
    public void connectionLost(Throwable throwable) {
        log.debug("连接断开，可以重连",throwable);
    }

    /**
     * 消息到达的回调
     */
    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        log.info("收到来自 " + topic + " 的消息：{}", new String(message.getPayload()));
//        String msg = new String(message.getPayload());
//        try {
//            JSONObject jsonObject = JSON.parseObject(msg);
//            String clientId = String.valueOf(jsonObject.get("clientid"));
//            if (topic.endsWith("disconnected")) {
//                log.info("客户端已掉线：{}",clientId);
//            } else {
//                log.info("客户端已上线：{}",clientId);
//            }
//        } catch (JSONException e) {
//            log.error("JSON Format Parsing Exception : {}", msg);
//        }
    }
    /**
     * 消息发布成功的回调
     */
    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        IMqttAsyncClient client = token.getClient();
        System.out.println(client.getClientId()+"发布消息成功！");
    }
}
