package cn.benma666.sjzt.kafka;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.FileUtil;
import cn.benma666.sjzt.*;
import cn.benma666.sjzt.bdwj.BdwjFile;
import com.alibaba.druid.util.Utils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.kafka.clients.admin.*;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.*;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * kafka工具，类似操作数据库的Db工具
 */
public class Kafka extends BasicSjzt {
    /**
     * 默认kafka
     */
    private static Kafka kafka = null;
    /**
     * kafka客户端对象池
     */
    private final GenericObjectPool objectPool;

    protected Kafka(String name, SysSjglSjzt sjzt) {
        //参考hdfs
        super(name, sjzt);
        GenericObjectPoolConfig<KafkaClient> conf = new GenericObjectPoolConfig<>();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(1);
        conf.setMaxIdle(2);
        conf.setMaxTotal(5);
        //最大等待60秒
        conf.setMaxWait(Duration.ofSeconds(300));
        //支持在载体中配置
        ClassUtil.plMethodInvoke(conf,getSjzt().getKzxxObj().getJSONObject("ljcpz"));
        objectPool = new GenericObjectPool(new SjztPooledObjectFactory(sjzt), conf);
        KafkaClient kafkaClient = null;
        try {
            //测试获取连接
            kafkaClient = borrowClient();
        } catch (Exception e) {
            throw new MyException(name + "初始化失败", e);
        } finally {
            returnClient(kafkaClient);
        }
        if (kafka == null) {
            kafka = this;
        }
        cache.put(name,this);
    }
    /**
     * 退回客户端
     * @param client 需要退回的客户端
     */
    public void returnClient(KafkaClient client) {
        log.trace("释放回连接池：{}",name);
        if (client != null) {
            objectPool.returnObject(client);
        }
    }

    /**
     * 获取客户端
     */
    public KafkaClient borrowClient() throws Exception {
        log.trace("从连接池获取：{}",name);
        return (KafkaClient) objectPool.borrowObject();
    }

    public static Kafka use(String name) {
        return use(name,getSjzt(name));
    }
    public static Kafka use(String name,SysSjglSjzt sjzt) {
        Kafka kafka = (Kafka) cache.get(name);
        if (kafka == null) {
            kafka = new Kafka(name, sjzt);
        }
        return kafka;
    }
    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            KafkaClient fc = new KafkaClient(sjzt);
            fc.getAdminClient().listTopics();
            fc.close();
            return success("测试成功");
        }catch (Throwable t){
            slog.debug("{}测试失败",sjzt,t);
            return failed("载体测试不通过："+t.getMessage());
        }
    }

    /**
     * 验证客户端是否可用
     */
    public static boolean validateClient(SysSjglSjzt sjzt,Object client) {
        try {
            KafkaClient adminClient = (KafkaClient) client;
            ListTopicsOptions options = new ListTopicsOptions();
            options.timeoutMs(5000);
            adminClient.getAdminClient().listTopics(options);
            return true;
        }catch (Throwable t){
            slog.debug("ftp验证无效：{}",sjzt.getMc(),t);
            return false;
        }
    }

    /**
     * 关闭客户端
     */
    public static void destroyClient(SysSjglSjzt sjzt,Object client) throws Exception {
        KafkaClient kafkaClient = (KafkaClient) client;
        kafkaClient.close();
    }
    public static KafkaClient createClient(SysSjglSjzt sjzt) {
        return new KafkaClient(sjzt);
    }

    public Object exec(SjztExecRunnable<KafkaClient> exec) {
        KafkaClient kafkaClient = null;
        try {
            kafkaClient = borrowClient();
            return exec.exec(kafkaClient);
        } catch (Exception e) {
            throw new MyException("kafka执行异常", e);
        } finally {
            if (kafkaClient != null) {
                objectPool.returnObject(kafkaClient);
            }
        }
    }
    /**
     * 消费历史数据
     */
    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) {
        //从消费者获取所有历史消息
        return (List<IFile>) exec(kafkaClient -> {
            try {
                KafkaConsumer<String,String> consumer = kafkaClient.getKafkaConsumer();
                int s = 0;
                List<IFile> list = new ArrayList<>();
                consumer.subscribe(Collections.singleton(znjhConfig.getSrml().replace(UtilConst.FXG,"")));
                while (list.size() == 0 && s <= 10) {
                    ConsumerRecords<String, String> records = consumer.poll(Duration.ofMillis(100));
                    for (ConsumerRecord<String, String> record : records) {
                        IFile file = new KafkaFile(UtilConst.FXG, record, this);
                        file.setGzml(znjhConfig.getSrml().replace(UtilConst.FXG,""));
                        list.add(file);
                        log.debug("offset = {}, value = {}", record.offset(), record.value());
                    }
                    s++;
                }
                // 手动提交消费
                consumer.commitAsync();
                // 取消订阅不会消费信息
                consumer.unsubscribe();
                return list;
            } catch (Exception e) {
                throw new MyException("获取kafka文件列表失败", e);
            }

        });
    }

    @Override
    public InputStream getInputStream(IFile file) {
        //才开ftp封装消费者为输入流
        if(file instanceof KafkaFile){
            return new ByteArrayInputStream(((KafkaFile)file).getFile().value().getBytes());
        }
        throw new MyException("不支持非kafkafile");
    }

    @Override
    public boolean delete(IFile file) {
        if(file instanceof KafkaFile){
            //消费后就不会读取到了
            return true;
        }
        throw new MyException("不支持非kafkafile");
    }

    /**
     * 发布消息
     * @param topic 主题
     * @param msg 消息内容
     * @return 发布状态
     * @throws Exception 异常
     */
    public boolean pub(String topic,String msg) throws Exception {
        return save(new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8)),
                new BdwjFile(topic,null));
    }

    @Override
    public boolean save(InputStream is, IFile file) {
        //通过生产者推送消息
        return (boolean) exec(kafkaClient -> {
            ProducerRecord<String, String> record = null;
            try {
                AtomicInteger sfcg = new AtomicInteger(0);
                record = new ProducerRecord<>(file.getParent()
                        .replace(UtilConst.FXG, ""), Utils.read(is));
                ProducerRecord<String, String> finalRecord = record;
                kafkaClient.getKafkaProducer().send(record, (recordMetadata, e) -> {
                    if (e != null) {
                        sfcg.set(1);
                        log.error("消息推送异常：" + finalRecord.topic() + ">" + finalRecord.value(), e);
                    }else {
                        sfcg.set(2);
                    }
                });
                while (sfcg.get() == 0) {
                    //等待推送结果
                    Thread.sleep(100l);
                }
                return sfcg.get() == 2;
            }catch (Throwable t){
                if(record == null){
                    throw new MyException("消息推送异常" ,t);
                }else {
                    throw new MyException("消息推送异常：" + record.topic() + ">" + record.value(),t);
                }
            } finally {
                FileUtil.closeStream(is);
            }
        });
    }
    @Override
    public String getRootPath() {
        //group.id
        return this.sjzt.getDxgs();
    }

    @Override
    public long getSize(IFile file) {
        if(file instanceof KafkaFile){
            return ((KafkaFile)file).getFile().value().getBytes().length;
        }
        throw new SjztBzcwjdxExecption("不支持非kafkafile");
    }

    /**
     * 关所有kafka连接
     */
    @Override
    public void close() {
        //关闭所有连接
        if (!this.objectPool.isClosed()) {
            this.objectPool.close();
        }
        cache.remove(name);
        if (this == kafka) {
            kafka = null;
        }
    }

    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog log) {
        exec(clent -> {
            long jtjg = DateUtil.scSjStrToLong(znjhConfig.getJtjg());
            //根目录
            String gml = znjhConfig.getSrml();
            KafkaConsumer<String,String> consumer = clent.getKafkaConsumer();
            consumer.subscribe(Collections.singleton(gml.replace(UtilConst.FXG,"")));
            while (true){
                ConsumerRecords<String, String> records = consumer.poll(Duration.ofMillis(jtjg));
                for (ConsumerRecord<String, String> record : records) {
                    IFile file = new KafkaFile(UtilConst.FXG, record, this);
                    file.setGzml(gml);
                    znjhConfig.getTp().run(() -> znjh.znjh(znjhConfig, log,file));
                }
            }
        });
    }

    /**
     * 获取所有权限
     *
     * @return
     */
    public Collection<String> getAllAcl() {
        return (Collection<String>) exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            return adminClient.describeAcls(AclBindingFilter.ANY).values().get();
        });
    }

    /**
     * 获取主题
     *
     * @return
     */
    public Set<String> getTopics() {
        return (Set<String>) exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            return adminClient.listTopics().names().get();
        });
    }

    /**
     * 获取消费组
     *
     * @return
     */
    public Collection<String> getConsumerGroups() {
        return (Collection<String>) exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            return adminClient.listConsumerGroups().valid().get();
        });
    }

    /**
     * 添加主题读写权限
     */
    public void addTopicReadOrWriterAcl(String topic, String username) {
        exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            ResourcePattern rpn = new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL);
            AccessControlEntry aceyWrite = new AccessControlEntry("User:" + username, "*", AclOperation.WRITE, AclPermissionType.ALLOW);
            AccessControlEntry aceyRead = new AccessControlEntry("User:" + username, "*", AclOperation.READ, AclPermissionType.ALLOW);
            AclBinding aclBindingWrite = new AclBinding(rpn, aceyWrite);
            AclBinding aclBindingRead = new AclBinding(rpn, aceyRead);
            List<AclBinding> list = new ArrayList<>();
            list.add(aclBindingWrite);
            list.add(aclBindingRead);
            CreateAclsResult acls = adminClient.createAcls(list);
            acls.all().get();
            return null;
        });
    }

    /**
     * 添加消费组权限
     *
     * @param consumerGroup
     * @param username
     */
    public void addGroupReadAcl(String consumerGroup, String username) {
        exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            ResourcePattern rpn = new ResourcePattern(ResourceType.GROUP, consumerGroup, PatternType.LITERAL);
            AccessControlEntry acey = new AccessControlEntry("User:" + username, "*", AclOperation.READ, AclPermissionType.ALLOW);
            AclBinding aclBinding = new AclBinding(rpn, acey);
            CreateAclsResult acls = adminClient.createAcls(Collections.singletonList(aclBinding));
            acls.all().get();
            return null;
        });
    }

    /**
     * 创建topic
     *
     * @param topicName
     */
    public void creatTopic(String topicName) {
        exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            Set<String> topics = adminClient.listTopics().names().get();
            if (topics.contains(topicName)) {
                return null;
            }
            NewTopic newTopic = new NewTopic(topicName, 1, (short) 1);
            CreateTopicsResult topic = adminClient.createTopics(Collections.singletonList(newTopic));
            topic.all().get();
            return null;
        });
    }

    /**
     * 删除topic
     *
     * @param topicName
     * @return
     */
    public void deleteTopic(String topicName) {
        //不会删除zookeeper节点
        exec(kafkaClient -> {
            AdminClient adminClient = kafkaClient.getAdminClient();
            DeleteTopicsResult deleteTopicsResult = adminClient.deleteTopics(Collections.singletonList(topicName));
            for (Map.Entry<String, KafkaFuture<Void>> entry : deleteTopicsResult.values().entrySet()) {
                KafkaFuture<Void> future = entry.getValue();
                future.get();//执行
            }
            return null;
        });
    }

}
