package cn.benma666.sjzt.fastdfs;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglFile;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpUtil;
import cn.benma666.sjzt.*;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.client.methods.HttpGet;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.TrackerServer;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;

/**
 * FastDFS工具，类似操作数据库的Db工具
 */
public class FastDFS extends BasicSjzt {
    public static final String GROUP_NAME = "groupName";
    /**
     * 默认FastDFS
     */
    private static FastDFS fastDFS = null;
    /**
     * FastDFS客户端对象池
     */
    private final GenericObjectPool fastDFSObjectPool;

    protected FastDFS(String name, SysSjglSjzt sjzt) {
        //参考hdfs
        super(name, sjzt);
        GenericObjectPoolConfig<FastDFSClient> conf = new GenericObjectPoolConfig<>();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(2);
        conf.setMaxIdle(5);
        conf.setMaxTotal(20);
        //最大等待60秒
        conf.setMaxWait(Duration.ofSeconds(300));
        fastDFSObjectPool = new GenericObjectPool(new SjztPooledObjectFactory(sjzt), conf);
        FastDFSClient fastDFSClient = null;
        try {
            //测试获取连接
            fastDFSClient = (FastDFSClient) fastDFSObjectPool.borrowObject();
        } catch (Exception e) {
            throw new MyException(name + "初始化失败", e);
        } finally {
            fastDFSObjectPool.returnObject(fastDFSClient);
        }
        if (fastDFS == null) {
            fastDFS = this;
        }
        cache.put(name,this);
    }

    public static FastDFS use(String name) {
        FastDFS sjzt = (FastDFS) cache.get(name);
        if (sjzt == null) {
            sjzt = new FastDFS(name, getSjzt(name));
        }
        return sjzt;
    }

    public Object exec(SjztExecRunnable<FastDFSClient> exec) {
        FastDFSClient fastDFSClient = null;
        try {
            fastDFSClient = (FastDFSClient) fastDFSObjectPool.borrowObject();
            return exec.exec(fastDFSClient);
        } catch (Exception e) {
            throw new MyException("FastDFS执行异常", e);
        } finally {
            if (fastDFSClient != null) {
                fastDFSObjectPool.returnObject(fastDFSClient);
            }
        }
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            FastDFSClient dfsClient = new FastDFSClient(sjzt);
            TrackerServer trackerServer = dfsClient.getTrackerServer();
            boolean r = ProtoCommon.activeTest(trackerServer.getSocket());
            if (r) {
                return success("测试成功");
            } else {
                return failed("载体测试不通过：" + sjzt.getMc());
            }
        } catch (Throwable var2) {
            slog.debug("{}测试失败", sjzt, var2);
            return failed("载体测试不通过：" + var2.getMessage());
        }
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            FastDFSClient fastDFSClient = (FastDFSClient) client;
            TrackerServer trackerServer = fastDFSClient.getTrackerServer();
            return ProtoCommon.activeTest(trackerServer.getSocket());
        } catch (IOException e) {
            slog.debug("fastDFS验证无效：{}", sjzt.getMc(), e);
            return false;
        }
    }

    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        FastDFSClient fastDFSClient = (FastDFSClient) client;
        fastDFSClient.close();
    }

    public static FastDFSClient createClient(SysSjglSjzt sjzt) {
        return new FastDFSClient(sjzt);
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) {
        throw new MyException("不支持listFiles");
    }

    @Override
    public InputStream getInputStream(IFile file) {
        return (InputStream) exec(fastDFSClient ->{
            HttpUtil hu = HttpUtil.builder().addRp(HttpUtil.REQUEST_METHOD, HttpGet.METHOD_NAME).build();
            return hu.getInputStream(getAbsolutePath(file));
            }
        );
    }

    @Override
    public boolean delete(IFile file) {
        return (boolean) exec(fastDFSClient -> {
            boolean s = false;
            DbFile dbfile = (DbFile) file;
            SysSjglFile fastDFSFile = dbfile.getFile();
            JSONObject kzxx = JSONObject.parseObject(fastDFSFile.getKzxx());
            StorageClient storageClient = fastDFSClient.getStorageClient();
            FileInfo fileInfo = storageClient.get_file_info(kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
            if (isBlank(fileInfo)){
                throw new MyException("文件不存在："+fastDFSFile);
            }else{
                int r = storageClient.delete_file(kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
                return true;
            }
        });
    }

    @Override
    public boolean save(InputStream is, IFile file) {
        if(!(file instanceof DbFile)){
            throw new MyException("fastdfs保存文件只支持传入DbFile");
        }
        try {
            return (boolean) exec(fastDFSClient -> {
                DbFile dbfile = (DbFile) file;
                SysSjglFile fastDFSFile = dbfile.getFile();
                String type = fastDFSFile.getWjlx();
                StorageClient storageClient = fastDFSClient.getStorageClient();
                NameValuePair[] meta_list = new NameValuePair[2];
                meta_list[0] = new NameValuePair("fileName", name);
                meta_list[1] = new NameValuePair("fileType", type);
                String[] uploadResults = storageClient.upload_file(Utils.readByteArray(is), type, meta_list);
                if (!isBlank(uploadResults)) {
                    String groupName = uploadResults[0];
                    String path = uploadResults[1];
                    JSONObject kzxx = new JSONObject();
                    kzxx.put(GROUP_NAME, groupName);
                    fastDFSFile.setSclj(this.getRootPath()+FileUtil.getFilePath(UtilConst.FXG,groupName ,path));
                    fastDFSFile.setParent(path);
                    fastDFSFile.setKzxx(kzxx.toJSONString());
                    return true;
                } else {
                    return false;
                }
            });
        }finally {
            FileUtil.closeStream(is);
        }
    }

    @Override
    public String getRootPath() {
        return sjzt.getKzxxObj().getString("storage_servers");
    }

    @Override
    public String getAbsolutePath(IFile file) {
        DbFile dbfile = (DbFile) file;
        SysSjglFile fastDFSFile = dbfile.getFile();
        JSONObject kzxx = JSONObject.parseObject(fastDFSFile.getKzxx());
        return this.getRootPath()+FileUtil.getFilePath(UtilConst.FXG,kzxx.getString(GROUP_NAME) ,fastDFSFile.getParent());
    }

    @Override
    public long getSize(IFile file) {
        return (long) exec(fastDFSClient -> {
            DbFile dbfile = (DbFile) file;
            SysSjglFile fastDFSFile = dbfile.getFile();
            JSONObject kzxx = JSONObject.parseObject(fastDFSFile.getKzxx());
            StorageClient storageClient = fastDFSClient.getStorageClient();
            FileInfo fileInfo = storageClient.get_file_info(kzxx.getString(GROUP_NAME), fastDFSFile.getParent());
            return fileInfo.getFileSize();
        });
    }

    /**
     * 关所有kafka连接
     */
    @Override
    public void close() {
        //关闭所有连接
        if (!this.fastDFSObjectPool.isClosed()) {
            this.fastDFSObjectPool.close();
        }
        cache.remove(name);
        if (this == fastDFS) {
            fastDFS = null;
        }
    }

    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog znjhJob) {
        throw new BusinessException("FastDFS不支持监听");
    }

}
