package cn.benma666.sjzt.bdwj;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.DbFile;
import cn.benma666.sjzt.IFile;
import com.alibaba.druid.util.Utils;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.io.monitor.FileAlterationMonitor;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static cn.benma666.myutils.FileUtil.closeStream;
import static cn.benma666.myutils.FileUtil.getFilePath;

/**
 * 本地文件数据载体操作
 */
@Setter
@Getter
public class Bdwj extends BasicSjzt {
    /**
     * 默认本地文件操作对象
     */
    private static Bdwj bdwj;
    /**
     * 操作根路径
     */
    private final File pathFile;
    /**
     * 监听对象
     */
    private Map<String,FileAlterationMonitor> monitorMap = new HashMap<>();

    public Bdwj(String name, SysSjglSjzt sjzt){
        this(name,new File(sjzt.getLjc()));
    }
    /**
     * @param name 名称
     * @param pathFile ftp操作客户端
     */
    public Bdwj(String name, File pathFile){
        super(name);
        this.pathFile=pathFile;
        if (bdwj == null) {
            bdwj = this;
        }
        if(!pathFile.exists()){
            //如果目录不存在则自动创建
            if(!pathFile.mkdirs()){
                throw new MyException("文件创建失败："+pathFile);
            }
        }
        cache.put(name,this);
    }

    public synchronized static Bdwj use(String name){
        Bdwj bdwj = (Bdwj) cache.get(name);
        if (bdwj == null) {
            bdwj = new Bdwj(name,getSjzt(name));
        }
        return bdwj;
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        return new Result(new File(sjzt.getLjc()).exists());
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) throws Exception {
        return listFiles(new File(getFilePath(pathFile.getAbsolutePath(),znjhConfig.getSrml())),znjhConfig);
    }

    public List<IFile> listFiles(File fileInput,SysSjglZnjh znjhConfig){
        List<IFile> list = new ArrayList<>();
        log.trace("开始遍历目录：{}",fileInput.getAbsolutePath());
        // 判断文件夹是否存在
        if (!fileInput.exists()) {
            log.error("文件不存在{}",fileInput.getAbsolutePath());
            return list;
        }
        // 获取文件列表
        File[] fileList = fileInput.listFiles();
        assert fileList != null;
        for (File file : fileList) {
            log.trace("遍历到文件：{}",file.getName());
            if (file.isDirectory()) {
                if(znjhConfig.isBlbhml()){
                    if (!sftg(znjhConfig,file.lastModified(),file.getName())){
                        list.add(new BdwjFile(fileInput.getAbsolutePath().replace(
                                pathFile.getAbsolutePath(),"/"),file,this));
                    }
                }
                // 递归处理文件夹
                if(znjhConfig.isDgbl()){
                    list.addAll(listFiles(file,znjhConfig));
                }
            } else{
                if (sftg(znjhConfig,file.lastModified(),file.getName())) continue;
                list.add(new BdwjFile(fileInput.getAbsolutePath().replace(
                        pathFile.getAbsolutePath(),"/"),file,this));
            }
        }
        return list;
    }

    @Override
    public InputStream getInputStream(IFile file) throws Exception {
        return new FileInputStream(getAbsolutePath(file));
    }

    @Override
    public boolean delete(IFile file) throws Exception {
        return new File(getAbsolutePath(file)).delete();
    }

    @Override
    public boolean save(InputStream is, IFile file) throws Exception {
        FileOutputStream out = null;
        try {
            File f = new File(getAbsolutePath(file)+ UNIMASTMP);
            synchronized (this){
                if(!f.getParentFile().exists()&&!f.getParentFile().mkdirs()){
                    throw new MyException("父路径创建失败："+f.getParent());
                }
            }
            out = new FileOutputStream(f);
            boolean r = Utils.copy(is, out) > 0;
            closeStream(out);
            if(!f.renameTo(new File(getAbsolutePath(file)))){
                throw new MyException("文件重命名失败："+f.getAbsolutePath());
            }
            return r;
        }finally {
            closeStream(is);
            closeStream(out);
        }
    }

    @Override
    public String getRootPath(){
        return getFilePath(pathFile.getAbsolutePath());
    }
    @Override
    public long getSize(IFile file) throws Exception {
        File f = new File(getAbsolutePath(file));
        if(!f.exists()){
            throw new MyException("文件不存在："+f.getAbsolutePath());
        }
        return f.length();
    }

    /**
     * @param sjzt 数据载体
     * @param file 文件
     * @return 相对载体的父路径
     */
    public static IFile getIfile(BasicSjzt sjzt, File file){
        return new BdwjFile(getFilePath(file.getParent()).replace(sjzt.getRootPath(), ""),
                file,sjzt);
    }

    @Override
    public void close() throws IOException {
        log.info("{}载体关闭",getName());
    }

    @Override
    public String getUrl(IFile ifile) {
        if(ifile instanceof DbFile){
            String sclj = ((DbFile) ifile).getFile().getSclj();
            if(StringUtil.isBlank(sclj)){
                sclj = getAbsolutePath(ifile);
            }
            return UtilConst.FXG+this.name+ UtilConst.FXG+sclj.substring(sclj.indexOf(((DbFile) ifile).getFile().getParent()));
        }
        return super.getUrl(ifile);
    }

    @Override
    public boolean zcUrl(IFile iFile) {
        return true;
    }
}
