package cn.benma666.sjzt;

import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.StringKit;

public class MyNameConversion extends NameConversion {

    @Override
    public String getTableName(Class<?> c) {
        String name = getAnnotationTableName(c);
        if(name!=null){
            return name;
        }
        return StringKit.enCodeUnderlined(c.getSimpleName());
    }
    @Override
    public  String getClassName(String tableName){
        String temp = StringKit.deCodeUnderlined(tableName.toLowerCase());
        return StringKit.toUpperCaseFirstOne(temp);

    }
    @Override
    public String getColName(Class<?> c,String attrName) {
        String col = super.getAnnotationColName(c,attrName);
        if(col!=null){
            return col;
        }
        return StringKit.enCodeUnderlined(attrName);
    }

    @Override
    public String getPropertyName(Class<?> c,String colName) {
        String attrName = super.getAnnotationAttrName(c,colName);
        if(attrName!=null){
            return attrName;
        }
//        return colName.toLowerCase();
        return StringKit.deCodeUnderlined(colName);
    }
}
