package cn.benma666.sjzt;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.FileUtil;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.util.TypeUtils;
import jakarta.activation.DataHandler;
import jakarta.mail.*;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/***
 * 邮件载体
 */
public class Email extends BasicSjzt {

    private static Email email = null;
    private Session client;

    protected Email(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        client = createClient(sjzt);
        if (email == null) {
            email = this;
        }
        cache.put(name,this);
    }

    public static Email use(String name) {
        Email sjzt = (Email)cache.get(name);
        if (sjzt == null) {
            sjzt = new Email(name, parseSjzt(getSjzt(name)));
        }
        return sjzt;
    }

    public static Session createClient(SysSjglSjzt sjzt) {
        try {
            final Properties props = new Properties();
            // 发件人的账号
            props.put("mail.user", sjzt.getYhm());
            //发件人的密码
            props.put("mail.password", sjzt.getMm());
            // 要连接的SMTP服务器
            props.put("mail.smtp.host", sjzt.getIp());
            // 如果 connect()方法未明确指定一个，则要连接的SMTP服务器端口。默认为25
            props.put("mail.smtp.port", sjzt.getPort());
            props.put("mail.smtp.socketFactory.port", sjzt.getPort());
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.ssl.enable", "true");
            // 使用ssl
            props.put("mail.smtp.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            if(!isBlank(sjzt.getKzxxObj().getJSONObject("props"))){
                props.putAll(sjzt.getKzxxObj().getJSONObject("props"));
            }
            // 构建授权信息，用于进行SMTP进行身份验证
            Authenticator authenticator = new Authenticator() {
                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    // 用户名、密码
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            };
            // 使用环境属性和授权信息，创建邮件会话
            return Session.getInstance(props, authenticator);
        } catch (Exception e) {
            slog.error("初始化失败", e);
            throw new MyException("初始化失败", e);
        }
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        return new Result(validateClient(sjzt,createClient(parseSjzt(sjzt))));
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            BodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText("测试邮件数据载体-内容："+sjzt.getDm());
            sendEmail(sjzt.getYhm(),sjzt.getYhm(),"测试邮件数据载体："+sjzt.getDm(),
                    (Session) client,messageBodyPart);
            return true;
        } catch (Exception e) {
            slog.debug("验证无效：{}", sjzt.getMc(), e);
            return false;
        }
    }

    /***
     * 上传文件
     */
    public boolean save(InputStream is, IFile file) throws Exception {
        try {
            final byte[] bytes = Utils.readByteArray(is);
            file.setSize(bytes.length);
            BodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setFileName(file.getName());
            messageBodyPart.setDataHandler(new DataHandler(new ByteArrayDataSource(
                    bytes,"application/octet-stream")));
            sendEmail(sjzt.getYhm(),file.getGzml(),file.getName(),
                    client,messageBodyPart);
            return true;
        } finally {
            FileUtil.closeStream(is);
        }
    }

    /**
     * 发邮件
     * @param to 发给谁
     * @param subject 标题
     * @param bodyParts 邮件内容
     */
    public void sendEmail(String to,String subject,
                         BodyPart... bodyParts){
        sendEmail(sjzt.getYhm(),to,subject,client,bodyParts);
    }

    /***
     * 发送邮件
     */
    private static void sendEmail(String from,String to,String subject,Session client,
                                 BodyPart... bodyParts){
        try {
            // 创建邮件消息
            MimeMessage message = new MimeMessage(client);
            // 设置发件人
            InternetAddress form = new InternetAddress(from);
            message.setFrom(form);
            // 设置收件人
            InternetAddress toAddress = new InternetAddress(to);
            message.setRecipient(Message.RecipientType.TO, toAddress);
            // 设置邮件标题
            message.setSubject(subject);
            Multipart multipart = new MimeMultipart();
            for(BodyPart bp: bodyParts){
                multipart.addBodyPart(bp);
            }
            message.setContent(multipart);
            // 发送邮件
            Transport.send(message);
        }catch (Exception e){
            throw new MyException("邮件发送失败",e);
        }
    }
    /**
     * url解析正则
     */
    public static Pattern urlZz = Pattern.compile("^(email://)?([^:]*)(:(\\d+))?$");
    /**
     * 解析ftp连接 <br/>
     * 解析出ip、port、encodeing
     * @author jingma
     * @param sjztObj 数据载体对象
     * @return 解析添加了相关信息的数据载体
     */
    public static SysSjglSjzt parseSjzt(SysSjglSjzt sjztObj) {
        Matcher m = urlZz.matcher(sjztObj.getLjc());
        if(m.find()){
            sjztObj.setIp(m.group(2));
            sjztObj.setPort(TypeUtils.castToInt(valByDef(m.group(4),465)));
        }else{
            throw new MyException("连接串解析出错");
        }
        return sjztObj;
    }

    public long getSize(IFile iFile) throws Exception {
        return iFile.getSize();
    }

    @Override
    public String getUrl(IFile ifile) {
        return super.getUrl(ifile);
    }

    @Override
    public boolean zcUrl(IFile iFile) {
        return false;
    }

    public String getRootPath() {
        return UtilConst.FXG;
    }

    //绝对路径
    public String getAbsolutePath(IFile file) {
        return file.getName();
    }
    public void close() throws IOException {
        cache.remove(this.name);
        if (this == email) {
            email = null;
        }
    }
    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        //不需要关闭
    }

    public List<IFile> listFiles(SysSjglZnjh sysSjglZnjh) throws Exception {
        throw new MyException("不支持listFiles");
    }

    public InputStream getInputStream(IFile file) throws Exception {
        throw new MyException("不支持getInputStream");
    }

    /***
     * 删除文件
     */
    public boolean delete(IFile file) throws Exception {
        throw new MyException("不支持delete");
    }
    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog znjhJob) {
        throw new BusinessException("不支持监听");
    }
}
