package cn.benma666.sjzt;

import cn.benma666.constants.UtilConst;
import cn.benma666.domain.SysSjglSjdx;
import cn.benma666.domain.SysSjglSjzd;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.json.JsonUtil;
import cn.benma666.iframe.Conf;
import cn.benma666.iframe.MyParams;
import cn.benma666.iframe.PageInfo;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.core.*;
import org.beetl.sql.core.engine.SQLParameter;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * ES工具
 */
public class ES extends BasicSjzt {
    private static final String ALL = "/_all";
    private static final String SQL = "/_sql";
    private static final String BULK = "/_bulk";
    private static final String BASIC = "Basic ";
    private static final String MAPPINGS = "/_mappings";

    private ES(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        cache.put(name,this);
    }

    public static ES use(String name) {
        return use(name,getSjzt(name));
    }
    public static ES use(String name,SysSjglSjzt sjzt) {
        ES es = (ES) cache.get(name);
        if (isBlank(es)) {
            return new ES(name, sjzt);
        } else {
            return es;
        }
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        if (isBlank(sjzt)) {
            return failed("数据载体为空");
        } else {
            JSONObject res = http("", null, sjzt, HttpGet.METHOD_NAME);
            if (!isBlank(res.getString("status"))) {
                return failed("测试未通过", res);
            }
        }
        return success("测试成功");
    }

    public String getSource(SqlId sqlId, JSONObject params) {
        return Db.use().getSourceSql(sqlId, params);
    }

    /**
     * 执行查询语句
     * @param sqlId  sql模板对象
     * @param params 参数对象
     */
    public List<JSONObject> find(SqlId sqlId, JSONObject params) {
        return this.find(getSource(sqlId, params), params);
    }

    /**
     * 执行查询语句
     *
     * @param sqlTemplate 未处理的sql模板
     * @param params      参数对象
     * @return
     */
    public List<JSONObject> find(String sqlTemplate, JSONObject params) {
        JSONObject sql = strConversion(sqlTemplate, params);
        sql.remove("count");
        JSONObject esParams = params.getJSONObject("$.sys.esParams");
        sql = JsonUtil.mergeJSONObjects(sql, esParams);
        Map<String, Object> map = find(sql.toJSONString(), new ArrayList<>());
        return (List<JSONObject>) map.get("list");
    }

    /**
     * 执行查询语句
     *
     * @param sql        渲染过后的sql模板
     * @param columnList 字段列表
     * @return
     */
    private Map<String, Object> find(String sql, List<JSONObject> columnList) {
        Map<String, Object> map = new HashMap<>();
        List<JSONObject> list = new ArrayList<>();
        List<JSONObject> columns = new ArrayList<>();
        //发起Http请求
        JSONObject res = http(SQL, sql, sjzt, HttpPost.METHOD_NAME);
        if (isBlank(res.getString("status"))) {
            // 当通过滚动查询是后续的返回值中没有columns
            if (!isBlank(res.getJSONArray("columns"))) {
                columns = res.getJSONArray("columns").toJavaList(JSONObject.class);
            }
            // 如果传了字段列表则使用传入的
            if (!isBlank(columnList)) {
                columns = columnList;
            }
            // 获取行数据
            List<JSONArray> rows = res.getJSONArray("rows").toJavaList(JSONArray.class);
            String cursor = res.getString("cursor");
            for (JSONArray row : rows) {
                JSONObject r = new JSONObject();
                for (int i = 0; i < columns.size(); i++) {
                    JSONObject column = columns.get(i);
                    r.put(column.getString("name"), row.get(i));
                }
                list.add(r);
            }
            map.put("list", list);
            map.put("columns", columns);
            map.put("cursor", cursor);
            return map;
        } else {
            throw new MyException("ES http请求失败："+res);
        }
    }

    /**
     * 通过JSON方式查询ES
     * @param sql
     * @param index
     * @return
     */
    public List<JSONObject> find(String sql, String index) {
        SysSjglSjzt sjzt = this.getSjzt();
        JSONObject res = http("/" + index + "/_search", sql, sjzt, HttpPost.METHOD_NAME);
        List<JSONObject> array = res.getJSONObject("hits").getJSONArray("hits").toJavaList(JSONObject.class);
        // 解析查询结果
        List<JSONObject> list = new ArrayList<>();
        array.forEach(j -> {
            list.add(j.getJSONObject("_source"));
        });
        return list;
    }

    /**
     * 渲染sql模板，query：查询sql、count：计数sql、params：参数数组
     *
     * @param sqlTemplate 未处理的sql模板
     * @param params      参数对象
     * @return
     */
    public JSONObject strConversion(String sqlTemplate, Map<String, Object> params) {
        JSONObject res = new JSONObject();
        // 使用的数据载体代码
        SQLManager sm = sqlManager(Conf.getVal("benma666.es-sql-zhzt",UtilConst.DEFAULT));
        SqlId sqlId = sm.getSqlIdFactory().buildTemplate(sqlTemplate);
        SQLSource source = sm.getSqlLoader().queryAutoSQL(sqlId);
        if (source == null) {
            source = new SQLSource(sqlId, sqlTemplate);
            source.setSqlType(SQLType.SELECT);
            sm.getSqlLoader().addSQL(sqlId, source);
        }
        ExecuteContext executeContext = ExecuteContext.instance(sm).initSQLSource(source);
        SQLExecutor script = sm.getDbStyle().buildExecutor(executeContext);
        Map pageParas = script.beforeExecute(null, params, false);
        final SQLResult sr = script.run(params);
        pageParas.put("_page", Boolean.TRUE);
        final SQLResult count = script.run(pageParas);
        pageParas.remove("_page");
        String sql = sr.jdbcSql;
        String countSql = count.jdbcSql;
        List<SQLParameter> paramList = sr.jdbcPara;
        JSONArray arr = new JSONArray();
        switch (valByDef(sjzt.getKzxxObj().getString("$.es.version"),"7.8")) {
            case "7.8":
                //ES7.8处理方式
                paramList.forEach(i -> {
                    arr.add(i.value);
                });
                break;
            default:
                //ES7.4处理方式
                paramList.forEach(i -> {
                    JSONObject p = new JSONObject();
                    p.put("value", i.value);
                    p.put("type", "keyword");
                    arr.add(p);
                });
        }
        res.put("query", sql);
        res.put("count", countSql);
        res.put("params", arr);
        return res;
    }


    /**
     * 分页查询
     *
     * @param page   分页对象
     * @param sqlId  sql模板对象
     * @param params 参数对象
     */
    public PageInfo<JSONObject> queryPage(PageInfo<JSONObject> page, SqlId sqlId, JSONObject params) {
        return this.queryPage(page, getSource(sqlId, params), JSON.parseObject(JSON.toJSONString(params)));
    }

    /**
     * 分页查询
     *
     * @param page        分页对象
     * @param sqlTemplate 未处理过的sql模板
     * @param params      参数对象
     */
    public PageInfo<JSONObject> queryPage(PageInfo<JSONObject> page, String sqlTemplate, JSONObject params) {
        JSONObject sql = strConversion(sqlTemplate, params);
        return queryPage(page, sql, params);
    }

    /**
     * 分页查询
     *
     * @param page 分页对象
     * @param sql  经过一次处理的sql模板
     */
    private PageInfo<JSONObject> queryPage(PageInfo<JSONObject> page, JSONObject sql, JSONObject params) {
        // 当前页
        long dqy = 1;
        long pageNumber = page.getPageNumber();
        Integer maxPageNumber = TypeUtils.castToInt(Conf.getVal("benma666.es-max-page-number", "200"));
        if(pageNumber > maxPageNumber){
            throw new MyException("超出es查询最大页号限制："+pageNumber+">"+maxPageNumber);
        }
        JSONObject listSql = new JSONObject();
        JSONObject countSql = new JSONObject();
        String cursor = params.getString("$.sys.cursor");
        JSONObject esParams = params.getJSONObject("$.sys.esParams");
        List<JSONObject> columns = new ArrayList<>();
        List<JSONObject> list;
        List<JSONObject> count;
        // 判断是否返回列表数据
        if (page.isListRequired()) {
            // 当游标不为空则使用传入的游标查询一次
            if (!isBlank(cursor)) {
                columns = params.getJSONArray("$.sys.columns").toJavaList(JSONObject.class);
                listSql.put("cursor", cursor);
                // 不进行滚动查询
                dqy = pageNumber;
            }
            listSql.put("query", sql.getString("query"));
            listSql.put("params", sql.getJSONArray("params"));
            listSql.put("fetch_size", page.getPageSize());
            listSql = JsonUtil.mergeJSONObjects(listSql, esParams);
            Map<String, Object> listMap = find(listSql.toJSONString(), columns);
            // 第一次滚动查询的字段，后续的查询不会再返回字段
            columns = (List<JSONObject>) listMap.get("columns");
            // 第一次查询返回的游标
            cursor = (String) listMap.get("cursor");
            // 滚动查询
            while (dqy < pageNumber) {
                dqy++;
                listSql.set("cursor", cursor);
                listMap = find(listSql.toJSONString(), columns);
                cursor = (String) listMap.get("cursor");
            }
            list = (List<JSONObject>) listMap.get("list");
            page.setList(list);
            page.set("cursor", cursor);
            page.set("columns", columns);
        }
        // 判断是否统计
        if (page.isTotalRequired()) {
            countSql.put("query", sql.getString("count"));
            countSql.put("params", sql.getJSONArray("params"));
            Map<String, Object> countMap = find(countSql.toJSONString(), new ArrayList<>());
            count = (List<JSONObject>) countMap.get("list");
            page.setTotalRow(count.get(0).getLong("count(*)"));
        }
        return page;
    }


    /**
     * 获取索引字段
     *
     * @param index
     * @return
     */
    public List<JSONObject> getFields(String index) {
        try {
            if (!isIndexExist(index)) {
                throw new MyException("索引不存在!");
            }
        } catch (Exception e) {
            log.debug("检查es索引是否存在报错{}",index,e);
        }
        JSONObject res = http("/" + index, null, sjzt, HttpGet.METHOD_NAME);
        //字段列表
        JSONObject zdMap = res.getJSONObject("$." + res.keySet().toArray()[0] + ".mappings.properties");
        //字段注释
        JSONObject comments = res.getJSONObject("$." + res.keySet().toArray()[0] + ".mappings._meta.comments");
        List<JSONObject> list = new ArrayList<>();
        for (String i : zdMap.keySet()) {
            String type = zdMap.getString("$." + i + ".type");
            if(isBlank(type)||"nested".equals(type)||"object".equals(type)){
                //排除子字段，验证发现不支持字段查询
                continue;
            }
            JSONObject zd = new JSONObject();
            zd.put("zddm", i);
            zd.put("zdms", isBlank(comments)?i:comments.getString(i));
            zd.put("zdcd", zdMap.getString("$." + i + ".fields.keyword.ignore_above"));
            zd.put("zdlx", type);
            list.add(zd);
        }
        return list;
    }

    /**
     * 获取索引列表
     *
     * @return
     */
    public List<JSONObject> getIndexList() {
        JSONObject res = http(ALL,null,sjzt, HttpGet.METHOD_NAME);
        List<JSONObject> strList = new ArrayList<>();
        for (String i:res.keySet()) {
            JSONObject table = new JSONObject();
            JSONObject aliases = res.getJSONObject(i).getJSONObject("aliases");
            table.set("dm",i);
            table.set("mc",isBlank(aliases)?i:aliases.keySet().toArray()[0]);
            strList.add(table);
        }
        return strList;
    }

    /**
     * 批量保存
     *
     * @param myParams
     * @param map：新增列表：insertList，更新列表：updateList
     * @return
     */
    public Result update(MyParams myParams, Map<String, Object> map) {
        PageInfo r = new PageInfo();
        JSONArray insertIds = new JSONArray();
        JSONArray updateIds = new JSONArray();
        List<JSONObject> insertList = (List<JSONObject>) map.get("insertList");
        List<JSONObject> updateList = (List<JSONObject>) map.get("updateList");
        SysSjglSjdx sjdx = myParams.sjdx();
        Map<String, SysSjglSjzd> sjzdMap = myParams.fields();
        log.trace("获取到的数据字段：" + JSON.toJSONString(sjzdMap));
        List<SysSjglSjzd> sjzdList = JSONArray.parseArray(JSON.toJSONString(sjzdMap.values())).toJavaList(SysSjglSjzd.class);
        //具体对象
        String jtdx = sjdx.getJtdx();
        // 主键字段
        String zjzd = isBlank(sjdx.getZjzd()) ? "id" : sjdx.getZjzd();
        // 增量字段
        String zlzd = isBlank(sjdx.getZlzd()) ? "" : sjdx.getZlzd();
        //对象归属
        String dxgs = isBlank(sjdx.getDxgs()) ? "_doc" : sjdx.getDxgs();
        //请求参数字符串
        StringBuilder paramStr = new StringBuilder();
        JSONObject v1 = new JSONObject();
        JSONObject v2 = new JSONObject();
        //请求对象
        JSONObject qq = new JSONObject();
        //参数对象
        JSONObject cs = new JSONObject();
        if (!isBlank(insertList)) {
            /**
             * 新增数据参数格式
             * {"index":{"_id":"","_index":"","_type":""}}\n
             * {"字段名":"字段值"}\n
             */
            insertList.forEach(i -> {
                v1.clear();
                v2.clear();
                qq.clear();
                String uuid = StringUtil.getUUIDUpperStr();
                String gxsj = DateUtil.getGabDate();
                if (!isBlank(i.getString(zjzd))) {
                    qq.set("_id", i.getString(zjzd));
                    insertIds.add(i.getString(zjzd));
                } else {
                    v2.set(zjzd, uuid);
                    qq.set("_id", uuid);
                    insertIds.add(uuid);
                }
                if (!isBlank(zlzd)) {
                    v2.set(zlzd, gxsj);
                }
                for (SysSjglSjzd zd : sjzdList) {
                    if (!isBlank(i.getString(zd.getZddm())) && !StringUtil.contains(zd.getZdywlb(), "99")) {
                        if ("0".equals(myParams.getString("$.sys.sjyz"))) {
                            if ("NUMBER".equals(zd.getZdlx())) {
                                v2.set(zd.getZddm(), i.getLongValue(zd.getZddm()));
                            } else {
                                v2.set(zd.getZddm(), i.get(zd.getZddm()));
                            }
                        } else if ("password".equals(zd.getKjlx())) {
                            v2.set(zd.getZddm(), StringUtil.desEnByField(i.getString(zd.getZddm()), zd));
                        } else {
                            if ("NUMBER".equals(zd.getZdlx())) {
                                v2.set(zd.getZddm(), i.getLongValue(zd.getZddm()));
                            } else {
                                v2.set(zd.getZddm(), i.get(zd.getZddm()));
                            }
                        }
                    }
                }
                qq.set("_index", jtdx);
                qq.set("_type", dxgs);
                v1.set("index", qq);
                paramStr.append(v1.toJSONString() + "\n");
                paramStr.append(v2.toJSONString() + "\n");
            });
        }
        if (!isBlank(updateList)) {
            /**
             * 修改数据参数格式
             * {"update":{"_id":"","_index":"","_type":""}}\n
             * {"doc":{"字段名":"字段值"}\n
             */
            updateList.forEach(i -> {
                v1.clear();
                v2.clear();
                qq.clear();
                cs.clear();
                String id = i.getString(zjzd);
                String gxsj = DateUtil.getGabDate();
                updateIds.add(id);
                if (!isBlank(zlzd)) {
                    cs.set(zlzd, gxsj);
                }
                if (!"0".equals(myParams.getString("$.sys.sjyz")) && StringUtil.isNotBlank(i.getString("sjlywlkj"))) {
                    cs.set("sjlywlkj", "default");
                }
                //属性存在、不是主键、不是虚拟字段、允许编辑
                for (SysSjglSjzd zd : sjzdList) {
                    if (i.containsKey(zd.getZddm()) &&
                            !zjzd.equals(zd.getZddm()) &&
                            !zlzd.equals(zd.getZddm()) &&
                            !StringUtil.contains(zd.getZdywlb(), "99") &&
                            "1".equals(zd.getYxbj())
                    ) {
                        if ("0".equals(myParams.getString("$.sys.sjyz"))) {
                            if ("NUMBER".equals(zd.getZdlx())) {
                                cs.set(zd.getZddm(), i.getLongValue(zd.getZddm()));
                            } else {
                                cs.set(zd.getZddm(), i.get(zd.getZddm()));
                            }
                        } else if ("password".equals(zd.getKjlx())) {
                            cs.set(zd.getZddm(), StringUtil.desEnByField(zd.getZddm(), zd));
                        } else {
                            if ("NUMBER".equals(zd.getZdlx())) {
                                cs.set(zd.getZddm(), i.getLongValue(zd.getZddm()));
                            } else {
                                cs.set(zd.getZddm(), i.get(zd.getZddm()));
                            }
                        }
                    }
                }
                qq.set("_id", id);
                qq.set("_type", dxgs);
                qq.set("_index", jtdx);
                v1.set("update", qq);
                v2.set("doc", cs);
                paramStr.append(v1.toJSONString() + "\n");
                paramStr.append(v2.toJSONString() + "\n");
            });
        }
        JSONObject res = http(BULK, paramStr.toString(), sjzt, HttpPost.METHOD_NAME);
        if (isBlank(res.getJSONArray("items"))) {
            return failed("保存失败", res);
        } else {
            r.set("insertIds", insertIds);
            r.set("updateIds", updateIds);
            return success("保存成功", r);
        }
    }

    /**
     * 批量删除
     *
     * @param myParams
     * @return
     */
    public Result plsc(MyParams myParams) {
        List<String> ids = myParams.getJSONArray("$.sys.ids").toJavaList(String.class);
        SysSjglSjdx sjdx = myParams.getObject(KEY_SJDX, SysSjglSjdx.class);
        //具体对象
        String jtdx = sjdx.getJtdx();
        //对象归属
        String dxgs = isBlank(sjdx.getDxgs()) ? "_doc" : sjdx.getDxgs();
        StringBuilder paramStr = new StringBuilder();
        JSONObject v = new JSONObject();
        JSONObject del = new JSONObject();
        /**
         * 删除数据格式
         * {"delete":{"_index":"","_type":"","_id":""}}\n
         */
        ids.forEach(i -> {
            v.clear();
            del.clear();
            del.set("_id", i);
            del.set("_type", dxgs);
            del.set("_index", jtdx);
            v.set("delete", del);
            paramStr.append(v.toJSONString()).append("\n");
        });
        JSONObject res = http(BULK, paramStr.toString(), sjzt, HttpPost.METHOD_NAME);
        JSONArray items = res.getJSONArray("items");
        if (isBlank(items)) {
            return failed("删除失败", res);
        } else {
            return success("删除成功", items.size());
        }
    }

    private static JSONObject http(String cllx, String param, SysSjglSjzt sjzt, String qqfs) {
        JSONObject rp = new JSONObject();
        rp.put(HttpUtil.CONTENT_TYPE,WebUtil.CONTENTTYPE_APPLICATION_JSON);
        rp.set(HttpUtil.REQUEST_METHOD, qqfs);
        rp.set(HttpUtil.AUTHORIZATION, BASIC + Base64.getUrlEncoder().encodeToString((sjzt.getYhm()
                + ":" + sjzt.getMm()).getBytes()));
        HttpUtil http = HttpUtil.builder().hi(HttpByOk.getInstance()).rp(rp).build();
        return http.josnByJson(sjzt.getLjc() + cllx, param);
    }


    /**
     * 判断索引是否存在
     */
    public boolean isIndexExist(String index) {
        List<JSONObject> strList = getIndexList();
        return JSON.toJSONString(strList).contains(index);
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh sysSjglZnjh) throws Exception {
        throw new MyException("数据库暂不支持遍历");
    }

    @Override
    public InputStream getInputStream(IFile iFile) throws Exception {
        throw new MyException("数据库暂不支持文件");
    }

    @Override
    public boolean delete(IFile iFile) throws Exception {
        throw new MyException("数据库暂不支持文件");
    }

    @Override
    public boolean save(InputStream inputStream, IFile iFile) throws Exception {
        throw new MyException("数据库暂不支持文件");
    }

    @Override
    public String getRootPath() {
        return UtilConst.FXG;
    }

    @Override
    public long getSize(IFile iFile) throws Exception {
        throw new SjztBzcwjdxExecption("ES暂不支持文件");
    }

    @Override
    public void close() throws IOException {
        cache.remove(getName());
    }
}
