package cn.benma666.sjzt;

import cn.benma666.domain.SysSjglFile;
import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.StringUtil;
import lombok.Getter;
import lombok.Setter;

import java.io.File;

@Setter
@Getter
public class DbFile extends BasicFile {
    private SysSjglFile file;
    private String name;

    public DbFile(SysSjglFile file) {
        super(file.getParent(), BasicSjzt.useSjzt(file.getSjzt()));
        this.file = file;
        if(StringUtil.isBlank(file.getSclj())){
    		if(file.isWjmjhz()){
    			setName(file.getId()+file.getWjm());
    		}else {
                this.name = file.getWjm();
            }
        }else {
            this.name = new File(file.getSclj()).getName();
        }
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long length() {
        return file.getWjdx();
    }

    @Override
    public long lastModified() {
        return DateUtil.parseDate(this.file.getGxsj()).getTime();
    }
}
