package cn.benma666.sjzt;

import cn.benma666.constants.UtilConstInstance;
import cn.benma666.crypt.DesUtil;
import cn.benma666.domain.SysSjglSjdx;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.*;
import cn.benma666.myutils.DateUtil;
import cn.benma666.sjzt.bdwj.BdwjFile;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;

import java.io.Closeable;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

import static cn.benma666.myutils.FileUtil.closeStream;
import static cn.benma666.myutils.FileUtil.getFilePath;

/**
 * 基础数据载体
 */
@Setter
@Getter
public abstract class BasicSjzt extends BasicObject implements Closeable, UtilConstInstance {
    /**
     * 临时文件后缀，交换系统不会处理该后缀的文件
     */
    public static final String UNIMASTMP = ".unimastmp";
    /**
     * 数据载体缓存
     */
    protected static final JSONObject cache = CacheFactory.use("sjzt", CacheFactory.TYPE_MEMORY);
    /**
     * 监听器集合
     */
    public static Map<String,Thread> jtqMap = new ConcurrentHashMap<>();
    /**
     * 名称
     */
    protected String name;
    /**
     * 数据载体
     */
    protected SysSjglSjzt sjzt;
    /**
     * 智能交换
     */
    protected InterfaceZnjh znjh;

    protected BasicSjzt(String name){
        this(name,null);
    }
    protected BasicSjzt(String name,SysSjglSjzt sjzt){
        this.name = name;
        this.sjzt = sjzt;
    }

    /**
     * 通过数据载体代码获取数据对象
     * @param name 数据载体代码
     * @return 获取不到抛出异常
     */
    public static SysSjglSjzt getSjzt(String name){
        SysSjglSjzt sjzt = (SysSjglSjzt) cache.get(name+"_bean");
        if(sjzt==null){
            Map<String, SysSjglSjzt> ds = Conf.getUtilConfig().getDatasource();
            if(!isBlank(ds.get(name))){
                sjzt = ds.get(name);
            }else {
                sjzt = Db.use().lambdaQuery(SysSjglSjzt.class)
                        .andEq(SysSjglSjzt::getDm,name).singleSimple();
                if(sjzt==null){
                    throw new MyException("数据载体不存在："+name);
                }
            }
            sjzt.setMm(DesUtil.decrypt(sjzt.getMm(),getSjztEjmm()));
            //缓存json配置，避免重复查询
            cache.put(name+"_bean",sjzt);
        }
        return sjzt;
    }

    /**
     * 获取数据载体二级密码 <br/>
     * @return 数据载体二级密码
     * @author jingma
     */
    public static String getSjztEjmm() {
        return Conf.getUtilConfig().getSjztEjmm();
    }
    /**
     * 获取数据载体工具
     */
    public static BasicSjzt useSjzt(String name){
        SysSjglSjzt sjzt = getSjzt(name);
        try {
            return (BasicSjzt) ztClass(sjzt).getMethod("use",String.class).invoke(null,name);
        } catch (Exception e) {
            throw new MyException("获取载体方式执行失败："+name,e);
        }
    }
    /**
     * 测试载体
     * @return 载体是否可用
     */
    public static Result csztSjzt(SysSjglSjzt sjzt){
        try {
            return (Result) ztClass(sjzt).getMethod("cszt",SysSjglSjzt.class).invoke(null,sjzt);
        } catch (Exception e) {
            throw new MyException("测试载体方法执行失败："+sjzt.getDm(),e);
        }
    }
    /**
     * 验证客户端是否可用
     */
    public static boolean validateSjztClient(SysSjglSjzt sjzt, Object client){
        try {
            return (boolean) ztClass(sjzt).getMethod("validateClient",SysSjglSjzt.class,
                    Object.class).invoke(null,sjzt,client);
        } catch (Exception e) {
            throw new MyException("验证客户端对象执行失败："+sjzt.getDm(),e);
        }
    }
    /**
     * 是否客户端
     */
    public static void destroySjztClient(SysSjglSjzt sjzt, Object client) throws Exception {
        try {
            ztClass(sjzt).getMethod("destroyClient",SysSjglSjzt.class,
                    Object.class).invoke(null,sjzt,client);
        } catch (Exception e) {
            throw new MyException("关闭客户端对象执行失败："+sjzt.getDm(),e);
        }
    }
    /**
     * 创建数据载体客户端
     */
    public static Object createSjztClient(SysSjglSjzt sjzt) {
        try {
            return ztClass(sjzt).getMethod("createClient",
                    SysSjglSjzt.class).invoke(null,sjzt);
        }catch (Exception e) {
            throw new MyException("创建数据载体客户端执行失败："+sjzt.getDm(),e);
        }
    }

    /**
     * 获取载体工具类
     * @param sjzt 载体配置对象
     * @return 对应工具类
     */
    private static Class<?> ztClass(SysSjglSjzt sjzt){
        if(Db.isSupported(sjzt.getLx())){
            //数据库场景
            return Db.class;
        }
        if(isBlank(sjzt.getSjkqd())){
            try {
                SjztLx lx = SjztLx.valueOf(sjzt.getLx());
                return lx.getZtClass();
            }catch (IllegalArgumentException e){
                throw new MyException("暂不支持该载体类型，没有获取到对应工具类："+sjzt.getLx());
            }
        }
        try {
            return Class.forName(sjzt.getSjkqd());
        } catch (Exception e) {
            throw new MyException("根据配置的工具类获取载体工具失败："+sjzt.getSjkqd(),e);
        }
    }

    /**
     * 通过路径获得路径下所有文件 输出文件名
     * @param path FTP路径
     */
    public void printList(String path) throws Exception {
        for (IFile f : listFiles(path)){
            log.info("得到文件:" + getFilePath(f.getParent() , f.getName()));
        }
    }
    /**
     * 启动监听器
     * @param znjhConfig 交换配置
     * @param log 日志
     */
    public void startListener(SysSjglZnjh znjhConfig, InterfaceLog log) {
        if(jtqMap.containsKey(znjhConfig.getId())){
            log.info("该交换已启动过了："+znjhConfig.getJhmc());
            return;
        }
        SjztListener fl = new SjztListener(znjhConfig,log);
        Thread t = new Thread(fl);
        t.setName(znjhConfig.getJhmc());
        t.start();
        jtqMap.put(znjhConfig.getId(),t);
        log.info("成功启动遍历监听器：" + znjhConfig.getJhmc());
    }

    /**
     * 结束全部监听器
     */
    public static void stopListener() {
        for (Map.Entry<String,Thread> e : jtqMap.entrySet()){
            e.getValue().interrupt();
        }
    }
    public static void jcListener(InterfaceLog log){
        Iterator<Map.Entry<String, Thread>> i = jtqMap.entrySet().iterator();
        while (i.hasNext()){
            Map.Entry<String,Thread> e = i.next();
            if(!e.getValue().isAlive()){
                log.info("{}监听器已退出：{}",e.getValue().getName(),e.getValue().getState());
                i.remove();
            }
        }
    }
    /**
     * 停止监听器
     * @param znjhConfig 交换配置
     */
    public static void stopListener(SysSjglZnjh znjhConfig) {
        Thread m = jtqMap.get(znjhConfig.getId());
        if(m==null){
            throw new MyException("没有找到该监听器："+znjhConfig.getJhmc());
        }
        m.interrupt();
    }

    /**
     * 是否跳过监听文件
     */
    protected boolean sftg(SysSjglZnjh znjhConfig,long lastModified,String name) {
        if(znjhConfig.getClzwj().contains(name)){
            //文件处理中
            return true;
        }
        if(defaultCache.containsKey("clycwj"+znjhConfig.getId()+name)){
            //文件处理异常的忽略
            return true;
        }
        if(znjhConfig.getJtwjPattern()!=null&&!znjhConfig.getJtwjPattern().matcher(name).matches()){
            //不在监听范围
            return true;
        }
        if(!isBlank(znjhConfig.getXgsjcxy())&&System.currentTimeMillis()-lastModified> DateUtil.scStrToLong(znjhConfig.getXgsjcxy())){
            return true;
        }
        if(!isBlank(znjhConfig.getXgsjcdy())&&System.currentTimeMillis()-lastModified< DateUtil.scStrToLong(znjhConfig.getXgsjcdy())){
            return true;
        }
        return false;
    }

    /**
     * 获取目录下所有文件
     * @param path 相对目录
     * @return 文件列表
     */
    public List<IFile> listFiles(String path) throws Exception {
        SysSjglZnjh znjh = new SysSjglZnjh();
        znjh.setSrml(path);
        return listFiles(znjh);
    }

    /**
     * 根据交换配置获取文件列表
     * @param znjhConfig 交换配置
     * @return 文件文件列表
     */
    public abstract List<IFile> listFiles(SysSjglZnjh znjhConfig) throws Exception;

    /**
     * 按数据对象获取
     * @param sjdx 数据对象
     * @return
     */
    public List<IFile> listFiles(SysSjglSjdx sjdx) {
        SysSjglZnjh znjh = new SysSjglZnjh();
        znjh.setSrml(sjdx.getDxgs());
        znjh.setJtwjzz(sjdx.getJtdx()+".*");
        try {
            return listFiles(znjh);
        } catch (Exception e) {
            log.error("根据对象获取文件失败："+sjdx,e);
            throw new MyException("根据对象获取文件失败："+e.getMessage(),e);
        }
    }

    /**
     * 获取字节
     */
    public byte[] readByteArray(IFile file) throws Exception{
        InputStream in = getInputStream(file);
        try {
            return Utils.readByteArray(in);
        }finally {
            closeStream(in);
        }
    }
    /**
     * 数据载体监听
     */
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog log) {
        long jtjg = DateUtil.scSjStrToLong(znjhConfig.getJtjg());
        //根目录
        String gml = znjhConfig.getSrml();
        //处理中文件
        Set<String> clzwj = znjhConfig.getClzwj();
        InterfaceThreadPool tp = znjhConfig.getTp();
        //最大队列大小
        int maxQs = znjhConfig.getTpc().getQueueCapacity();
        //本次处理完全部文件
        boolean bcclw;
        while(true) {
            try {
                bcclw = true;
                // 查询ftp目录变更情况
                for (IFile file : this.listFiles(znjhConfig)) {
                    file.setGzml(gml);
                    file.setParent(file.getParent().replace(gml,"/"));
                    if(clzwj.contains(file.getName())){
                        //该文件在处理中
                        continue;
                    }
                    log.debug("开始添加遍历到的文件到处理池："+file.getAbsolutePath());
                    clzwj.add(file.getName());
                    //每个交换采用独立的线程池避免一个交换文件堆积导致所有交换等待
                    tp.run(() -> znjh.znjh(znjhConfig,log,file));
                    if(tp.getQueueSize()>=maxQs){
                        //已加入队列数达到最大值，暂停添加
                        bcclw = false;
                        break;
                    }
                }
                while (tp.getQueueSize()>20){
                    log.debug("等待文件处理，线程池排队数量："+tp.getQueueSize());
                    Thread.sleep(10000L);
                }
                if(bcclw){
                    Thread.sleep(jtjg);
                }
            } catch (InterruptedException e){
                log.info("退出遍历监听：{}",znjhConfig.getJhmc());
                break;
            } catch (Throwable e) {
                log.error("遍历监听异常："+znjhConfig.getJhmc()+"，"+e.getMessage(),e);
            }
        }
        jtqMap.remove(znjhConfig.getId());
    }
    /**
     * 获取输入流
     */
    public abstract InputStream getInputStream(IFile file) throws Exception;

    /**
     * 删除文件
     */
    public abstract boolean delete(IFile file) throws Exception;

    /**
     * 保存文件
     */
    public abstract boolean save(InputStream is, IFile file) throws Exception;

    /**
     * 获取载体根路径
     */
    public abstract String getRootPath();
    /**
     * @return 文件全路径
     */
    public String getAbsolutePath(IFile file){
        return getFilePath(getRootPath(),file.getGzml(),file.getParent(),file.getName());
    }

    /**
     * @return 文件大小
     */
    public abstract long getSize(IFile file) throws Exception;

    /**
     * @param ifile 文件对象
     * @return 直接访问路径
     */
    public String getUrl(IFile ifile){
        throw new MyException("不支持获取直接访问路径");
    }

    /**
     * 支持获取直接访问文件的url
     * @param iFile 文件对象
     * @return 是否
     */
    public boolean zcUrl(IFile iFile){
        return false;
    }
}
