package cn.benma666.params;

import cn.benma666.dict.LjqType;
import cn.benma666.domain.BasicBean;
import cn.benma666.iframe.MyParams;
import cn.benma666.vo.WebSocketKhdxxVo;
import com.alibaba.fastjson.JSONObject;
import lombok.*;

import java.util.List;

/**
 * 系统参数实体
 */
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class Sys extends BasicBean {
    /**
     * 处理类型;必填
     */
    private String cllx;
    /**
     * 权限代码;不传时只提供最基础功能
     */
    private String authCode;
    /**
     * 控制器
     */
    private String controller;
    /**
     * 代理数据对象主键，配置了则优先使用该数据对象，一些场景需要代理原数据对象
     */
    private String dlsjdxid;
    /**
     * 代理数据对象代码，配置了则优先使用该数据对象，一些场景需要代理原数据对象
     */
    private String dlsjdxdm;
    /**
     * 父数据对象代码，一些数据对象时基于另一个数据对象复制而来，而我们在大字典中配置sql等场景需要依赖对象代码，为避免重复配置，此处支持配置父对象代码，系统会读取父对象代码相关大字典
     */
    private String fsjdxdm;
    /**
     * 权限key
     */
    private String token;
    /**
     * 执行操作;设置执行什么操作，默认getdata，可选项：getdata获取数据，plcl执行新增修改操作，getfile获取文件
     */
    private String zxcz;
    /**
     * 请求时清除缓存，默认false，重新加载对象、字段等信息
     */
    private Boolean clearCache;
    /**
     * 数据是否使用缓存，部分功能数据存在缓存会用到，如字典等，默认true
     */
    private Boolean dataCache;
    /**
     * 页面批量操作选择的记录id列表，为数组
     */
    private List<String> ids;
    /**
     * 下载模式，1：按文件类型下载、2：二进制文件下载、3：base64、4：转为base64后作为data以json对象返回，针对代理下载文件场景。默认：1
     */
    private Integer xzms;
    /**
     * [],编辑表格数据：列表编辑的数据
     */
    private List editTableData;
    /**
     * {},参数体处理，调用接口时，需要一起执行的其他操作
     */
    private JSONObject cstcl;
    /**
     * {},可以是实现了接口HdInterface的对象或请求参数体，系统会自动采用该参数体进行回调。
     */
    private Object hdcst;
    /**
     * 任何内容
     */
    private Object context;
    /**
     * 内部调用，默认非内部调用
     */
    private Boolean nbdy;
    /**
     * 拦截器类型，默认定制拦截器
     */
    private LjqType ljqType;
    /**
     * 可以实现将请求生成文件，传到其他地方调用后结果返回,穿透调用
     */
    private String ctdy;
    /**
     * 可以实现自动将请求条件和用户信息转发到另一个应用，相当于代理功能，在穿透调用前执行,穿透前应用
     */
    private String ctqapp;
    /**
     * 可以实现自动将请求条件和用户信息转发到另一个应用，相当于代理功能,穿透应用
     */
    private String ctapp;
    /**
     * 穿透应用的相对地址,穿透url
     */
    private String cturl;
    /**
     * 超时时长,穿透调用和穿透app场景都会用到，毫秒
     */
    private Integer timeout;
    /**
     * false,不执行更新，默认false，主要针对批量保存场景
     */
    private Boolean bzxgx;
    /**
     * 批量处理
     */
    private Boolean batch;
    /**
     * false,不执行新增，默认false，主要针对批量保存场景
     */
    private Boolean bzxxz;
    /**
     * 控制是否需要穿透调用的结果，默认true，数据推送类就可以不需要，感觉有结果当然还是更完美哈,穿透调用结果
     */
    private Boolean ctdyjg;
    /**
     * {},变化的列表选择数据
     */
    private JSONObject changeCheckData;
    /**
     * {},存储树形结构展开情况
     */
    private JSONObject treeExpandData;
    /**
     * 文件数组，当我们需要上传文件时，需要先调用upload文件上传接口，文件上传后，接口会返回一个文件对象列表，后续的使用都基于该文件列表进行
     */
    private List files;
    /**
     * 用户信息;用于跨系统自动登陆
     */
    private String userInfo;
    /**
     * 客户端ip;系统会自动获取
     */
    private String clientIp;
    /**
     * 客户端真实ip;系统会自动获取，不支持代理设置，获取的真实ip
     */
    private String clientRealIp;
    /**
     * 请求主机
     */
    private String requestHost;
    /**
     * 用于自定义导出文件名，不设置则采用数据对象名称
     */
    private String dcwjm;
    /**
     * 导出排除字段列表
     */
    private List<String> dcpczdlb;
    /**
     * 导出字段列表
     */
    private List<String> dczdlb;
    /**
     * 收到请求开始的时间
     */
    private Long qqkssj;
    /**
     * 每次请求系统会自动生成一个请求id与日志id一致
     */
    private String qqid;
    /**
     * 回调请求id，异步请求时，会将请求id带回，使调用方知道是对应的哪一次请求
     */
    private String hdqqid;
    /**
     * 回调结束，告知调用方法回调完成
     */
    private Boolean hdjs;
    /**
     * 通用搜索信息
     */
    private String searchKey;
    /**
     * 国际化语言切换,如：zh_CN、en_US等
     */
    private String language;
    /**
     * 已找到记录，传入主键是否能查询到对应的记录
     */
    private Boolean yzdjl;
    /**
     * 事务提交量，主要用于批量上传时，多少条数据提交一次事务，默认5000
     */
    private Integer swtjl;
    /**
     * 物理删除，默认false，配置该数据对象是否允许物理删除
     */
    private Boolean wlsc;
    /**
     * 删除源文件，默认不删除
     */
    private Boolean scywj;
    /**
     * 是否包含字段代码，默认true，导出下载模板时会用到
     */
    private Boolean zddm;
    /**
     * 是否数据校验，1验证，0不验证，默认1，数据同步场景生效
     */
    private Integer sjyz;
    /**
     * 文件类型，下载数据模板格式等
     */
    private String fileType;
    /**
     * 终端类别，默认：PC，PC（电脑）、Android、IOS、Wx、Zfb、H5
     */
    private String zdlb;
    /**
     * {},系统字段相关配置
     */
    private JSONObject fields;
    /**
     * 公钥
     */
    private String publicKey;
    /**
     * websoket客户端回调消息
     */
    private WebSocketKhdxxVo wskhdxx;
    /**
     * 依赖参数对象，各类操作时，如果有依赖参数，则会将依赖参数对象带回，方便调用方进行处理
     */
    private MyParams ylParams;
    /**
     * 值，验证转换时会将验证转换的值存入该字段中
     */
    private Object value;
    /**
     * 规则对象，用于验证转换时存储规则信息
     */
    private JSONObject gzObj;
    /**
     * 精确搜索，默认false
     */
    private boolean jqss;
    /**
     * 精确搜索，默认true
     */
    private boolean sjjy=true;

}
