package cn.benma666.params;

import cn.benma666.domain.BasicBean;
import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * sql相关参数
 */
@Setter
@Getter
public class Sql extends BasicBean {
    /**
     * 默认sql
     */
    private String defaultSql;
    /**
     * 查询的表，含对象归属
     */
    private String from;
    /**
     * 查询的字段列表
     */
    private String selectField;
    /**
     * 查询条件
     */
    private String whereStr;
    /**
     * 权限条件
     */
    private String authWhere;
    /**
     * 排序信息
     */
    private String orderBy;
    /**
     * 更新的字段，如：xm='dsds',age=2
     */
    private String setf;
    /**
     * 要插入的字段列表
     */
    private String insertf;
    /**
     * 要插入的数据列表
     */
    private String values;
    /**
     * 去重字段
     */
    private String qczd;
    /**
     * 待进行去重查询的值列表
     */
    private List<List<Object>> qcList;
    /**
     * 结果数据，便于在模板中自由的设置返回结果
     */
    private JSONObject resultData;
    /**
     * 修改的节点
     */
    private Object changeNode;
    /**
     * sql处理的处理了，获取sql时会用到，sys.cllx主要用于找接口方法，一个接口中需要调用其他处理类型sql，所以这里独立设置一个
     */
    private String cllx;
}
