/**
* Project Name:myutils
* Date:2017年8月24日
* Copyright (c) 2017, jingma All Rights Reserved.
*/

package cn.benma666.myutils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import net.sf.json.xml.XMLSerializer;
import org.dom4j.*;

import java.util.List;

/**
 * xml工具 <br/>
 * date: 2017年8月24日 <br/>
 * @author jingma
 * @version 0.1
 */
public class XmlUtil {
    /**
    * xml转换为json，采用sf.json <br/>
    * @author jingma
    * @param xml 源xml字符串
    */
    public static Object xmlToJson(String xml){
        return JSON.parse(new XMLSerializer().read(xml).toString());
    }

    /**
     * @param xml 源xml字符串
     * @return fastjson的对象
     */
    public static JSONObject xmlToJsonObject(String xml){
        return (JSONObject) xmlToJson(xml);
    }

    /**
     * @param xml 源xml字符串
     * @return fastjson的数组
     */
    public static JSONArray xmlToJsonArray(String xml){
        return (JSONArray) xmlToJson(xml);
    }
    /**
     * xml转json，采用dom4j解析
     * @param xmlStr 源xml字符串
     * @return xml解析出的json对象-fastjson
     */
    public static JSONObject xmlToJson2(String xmlStr) throws DocumentException{
        Document doc= DocumentHelper.parseText(xmlStr);
        JSONObject json=new JSONObject();
        dom4j2Json(doc.getRootElement(), json);
        return json;
    }

    /**
     * xml转json
     * @param element dom4j对象
     * @param json json对象
     */
    private static void dom4j2Json(Element element,JSONObject json){
        //如果是属性
        for(Object o:element.attributes()){
            Attribute attr=(Attribute)o;
            if(StringUtil.isNotBlank(attr.getValue())){
                json.put("@"+attr.getName(), attr.getValue());
            }
        }
        List<Element> chdEl=element.elements();
        if(chdEl.isEmpty()&&StringUtil.isNotBlank(element.getText())){//如果没有子元素,只有一个值
            if(StringUtil.isBlank(element.getName())){
                json.put("#text", element.getText());
            }else{
                json.put(element.getName(), element.getText());
            }
        }

        for(Element e:chdEl){//有子元素
            if(!e.elements().isEmpty()){//子元素也有子元素
                JSONObject chdjson=new JSONObject();
                dom4j2Json(e,chdjson);
                Object o=json.get(e.getName());
                if(o!=null){
                    JSONArray jsona=null;
                    if(o instanceof JSONObject){//如果此元素已存在,则转为jsonArray
                        JSONObject jsono=(JSONObject)o;
                        json.remove(e.getName());
                        jsona=new JSONArray();
                        jsona.add(jsono);
                        jsona.add(chdjson);
                    }
                    if(o instanceof JSONArray){
                        jsona=(JSONArray)o;
                        jsona.add(chdjson);
                    }
                    json.put(e.getName(), jsona);
                }else{
                    if(!chdjson.isEmpty()){
                        json.put(e.getName(), chdjson);
                    }
                }
            }else{//子元素没有子元素
                for(Object o:element.attributes()){
                    Attribute attr=(Attribute)o;
                    if(StringUtil.isNotBlank(attr.getValue())){
                        json.put("@"+attr.getName(), attr.getValue());
                    }
                }
                if(!e.getText().isEmpty()){
                    if(StringUtil.isBlank(e.getName())){
                        json.put("#text", e.getText());
                    }else{
                        json.put(e.getName(), e.getText());
                    }
                }
            }
        }
    }
}
