/**
* Project Name:myutils
* Date:2016年9月10日
* Copyright (c) 2016, jingma All Rights Reserved.
*/

package cn.benma666.myutils;

import ch.qos.logback.core.util.FileSize;
import cn.benma666.constants.UtilConst;
import cn.benma666.exception.BusinessException;
import cn.benma666.sjzt.IFile;
import com.alibaba.druid.util.Utils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.math.BigInteger;
import java.security.MessageDigest;

/**
 * 文件工具 <br/>
 * date: 2016年9月10日 <br/>
 * @author jingma
 * @version 0.1
 */
public class FileUtil extends FileUtils{
    private static final Log log = LogFactory.getLog(FileUtil.class);

    /**
     * 获取文件的MD5值
     * @param file 上传文件
     * @return 文件MD5值
     */
    public static String getFileMD5(File file) throws Exception {
        return getFileMD5(new FileInputStream(file));
    }
    /**
     * 获取文件的MD5值
     * @return 文件MD5值
     */
    public static String getFileMD5(InputStream in) throws Exception {
        return getFileMD5(Utils.readByteArray(in));
    }
    /**
     * 获取文件的MD5值
     * @param bArr 上传文件
     * @return 文件MD5值
     */
    public static String getFileMD5(byte[] bArr) throws Exception {
        //信息摘要
        MessageDigest digest;
        digest = MessageDigest.getInstance("MD5");
        digest.update(bArr, 0, bArr.length);
        BigInteger bigInt = new BigInteger(1, digest.digest());
        //返回
        return bigInt.toString(16);
    }

    /**
    * 关闭流 <br/>
    * @param is 要关闭流
    */
    public static void closeStream(Closeable is){
        try {
            if(is != null){
                is.close();
            }
        } catch (IOException e) {
            log.debug("关闭文件流失败", e);
        }
    }
    /**
    * 将图片转为字节组 <br/>
    */
    public static byte[] toBytes(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
          ImageIO.write( image, "png", os );
        } finally {
          os.flush();
        }
        return os.toByteArray();
    }
    /**
     * 递归删除目录
     * @param fileName 要删除的文件或文件夹路径
     */
    public static void deleteDir(String fileName) {
        File file;
        file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] list = file.listFiles();
        if(list!=null){
            for (File f1 : list) {
                if (f1.isDirectory()) {
                    deleteDir(f1.getAbsolutePath());
                } else {
                    if(!f1.delete()){
                        throw new BusinessException("文件删除失败："+f1.getAbsolutePath());
                    }
                }
            }
        }
        if(!file.delete()){
            throw new BusinessException("文件删除失败："+file.getAbsolutePath());
        }
    }
    /**
     * 获取文件大小，针对文件持续写入场景，持续检测文件获取文件最终大小
     * @param file 文件
     * @param xwj 小文件等待时间
     * @param dwj 大文件等待时间
     * @return 文件大小
     */
    public static Long getFilelength(IFile file, long xwj, long dwj) {
        long lastLength;
        long endLength = file.length();
        try {
            Thread.sleep(xwj);
        } catch (InterruptedException e) {
            log.debug("线程中断", e);
        }
        lastLength = file.length();
        // 小文件 不进循环
        if (lastLength == endLength) {
            return endLength;
        }
        endLength = lastLength;
        do {
            lastLength = endLength;
            try {
                Thread.sleep(dwj);
            } catch (InterruptedException e) {
                log.debug("线程中断", e);
            }
            endLength = file.length();
            log.trace(" last :" + lastLength + "---- end:" + endLength);
        } while (lastLength != endLength);
        return endLength;
    }
    /**
     * @param path 多路径
     * @return 不带/后缀
     */
    public static String getFilePath(String... path){
        String fp = getPath(path);
        if(StringUtil.isNotBlank(fp)&&fp.length()>1){
            return fp.substring(0, fp.length() - 1);
        }else {
            return fp;
        }
    }
    /**
     * @param path 多路径
     * @return 带/后缀
     */
    public static String getPath(String... path){
        if(path==null){
            path = new String[]{};
        }
        StringBuilder fp = new StringBuilder();
        for (String p : path){
            if(StringUtil.isBlank(p)){
                //路径为空跳过
                continue;
            }
            fp.append(p).append(UtilConst.FXG);
        }
        String fps = fp.toString().replace("\\", UtilConst.FXG);
        while (fps.contains(UtilConst.FXG+UtilConst.FXG)){
            //替换掉重复的分隔符
            fps = fps.replace(UtilConst.FXG + UtilConst.FXG, UtilConst.FXG);
        }
        return fps;
    }

    /**
     * 获取文件目录
     * @param filePath 文件路径
     * @return 结果
     */
    public static String getMLFromPath(String filePath) {
        return new File(filePath).getParent();
    }

    /**
     * 获取文件名
     * @param filePath 文件路径
     * @return 结果
     */
    public static String getNameFromPath(String filePath) {
        return new File(filePath).getName();
    }

    /**
     * 根据文件大小字符串获取文件的byte大小。kb|mb|gb
     * @param str 带单位的大小
     * @return 字节数
     */
    public static long getSizeByStr(String str){
        return FileSize.valueOf(str).getSize();
    }

}
