package cn.benma666.myutils;

import java.util.ArrayList;
import java.util.List;

public class CollectionUtils extends org.apache.commons.collections.CollectionUtils {
    /**
     * 对list按设定大小进行分区
     * @param coll 待分区集合
     * @param num 每个区大小
     * @param <T> 参数泛型
     * @return 分区结果
     */
    public static <T> List<List<T>> partition(List<T> coll, int num){
        List<T> l1 = new ArrayList<>();
        List<List<T>> l2 = new ArrayList<>();
        for(T o : coll){
            l1.add(o);
            if(l1.size()==num){
                l2.add(l1);
                l1 = new ArrayList<>();
            }
        }
        if(!l1.isEmpty()){
            l2.add(l1);
        }
        return l2;
    }
}
