/**
* by jingma 2022-09-15
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.math.BigDecimal;

/**
 *
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "xxl_job_info")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class XxlJobInfo extends BasicBean{

	/**
	 *
	 */
	@Column("add_time")
	private String addTime;
	/**
	 * 报警邮件
	 */
	@Column("alarm_email")
	private String alarmEmail;
	/**
	 * 作者
	 */
	@Column("author")
	private String author;
	/**
	 * 子任务ID，多个逗号分隔
	 */
	@Column("child_jobid")
	private String childJobid;
	/**
	 * 阻塞处理策略
	 */
	@Column("executor_block_strategy")
	private String executorBlockStrategy;
	/**
	 * 失败重试次数
	 */
	@Column("executor_fail_retry_count")
	private BigDecimal executorFailRetryCount;
	/**
	 * 执行器任务handler
	 */
	@Column("executor_handler")
	private String executorHandler;
	/**
	 * 执行器任务参数
	 */
	@Column("executor_param")
	private String executorParam;
	/**
	 * 执行器路由策略
	 */
	@Column("executor_route_strategy")
	private String executorRouteStrategy;
	/**
	 * 任务执行超时时间，单位秒
	 */
	@Column("executor_timeout")
	private BigDecimal executorTimeout;
	/**
	 * GLUE备注
	 */
	@Column("glue_remark")
	private String glueRemark;
	/**
	 * GLUE源代码
	 */
	@Column("glue_source")
	private String glueSource;
	/**
	 * GLUE类型
	 */
	@Column("glue_type")
	private String glueType;
	/**
	 * GLUE更新时间
	 */
	@Column("glue_updatetime")
	private String glueUpdatetime;
	/**
	 *
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("id")
	private BigDecimal id;
	/**
	 *
	 */
	@Column("job_desc")
	private String jobDesc;
	/**
	 * 执行器主键ID
	 */
	@Column("job_group")
	private BigDecimal jobGroup;
	/**
	 * 调度过期策略
	 */
	@Column("misfire_strategy")
	private String misfireStrategy;
	/**
	 * 调度配置，值含义取决于调度类型
	 */
	@Column("schedule_conf")
	private String scheduleConf;
	/**
	 * 调度类型
	 */
	@Column("schedule_type")
	private String scheduleType;
	/**
	 * 上次调度时间
	 */
	@Column("trigger_last_time")
	private BigDecimal triggerLastTime;
	/**
	 * 下次调度时间
	 */
	@Column("trigger_next_time")
	private BigDecimal triggerNextTime;
	/**
	 * 调度状态：0-停止，1-运行
	 */
	@Column("trigger_status")
	private String triggerStatus;
	/**
	 *
	 */
	@Column("update_time")
	private String updateTime;
}
