/**
* by jingma 2022-10-11
*/
package cn.benma666.domain;

import cn.benma666.exception.MyException;
import cn.benma666.sjzt.Db;
import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 系统-智能交换-穿透调用
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_znjh_ctdy")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysZnjhCtdy extends BasicBean{

	/**
	 * 创建人代码
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 创建人单位代码
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 代码
	 */
	@Column("DM")
	private String dm;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 接收交换@SYS_SJGL_ZNJH;有则表示有返回数据，无则表示该穿透没有返回
	 */
	@Column("JSJH")
	private String jsjh;
	/**
	 * 目标节点@SYS_QX_APP;表示该调用穿透的目标节点，穿透调用
	 */
	@Column("MBJD")
	private String mbjd;
	/**
	 * 扩展信息
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 名称
	 */
	@Column("MC")
	private String mc;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 推送目录
	 */
	@Column("TSML")
	private String tsml;
	/**
	 * 推送交换@SYS_SJGL_ZNJH
	 */
	@Column("TSJH")
	private String tsjh;
	/**
	 * 推送节点@SYS_QX_APP
	 */
	@Column("TSJD")
	private String tsjd;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 推送交换对象
	 */
	@Transient
	private SysSjglZnjh tsjhObj;

	/**
	 * 设置推送交换，自动关联获取推送交换对象
	 * @param tsjh 推送交换
	 */
	public void setTsjh(String tsjh) {
		this.tsjh = tsjh;
		setTsjhObj(Db.useSqlManager().lambdaQuery(SysSjglZnjh.class)
				.andEq(SysSjglZnjh::getId, tsjh).singleSimple());
		if(getTsjhObj()==null){
			throw new MyException("没有找到推送交换："+tsjh);
		}
	}
}
