/**
* by jingma 2022-10-05
*/
package cn.benma666.domain;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import com.alibaba.druid.DbType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 系统-数据管理-数据载体
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_sjgl_sjzt")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysSjglSjzt extends BasicBean{

	public SysSjglSjzt(String host, int port , String yhm , String mm) {
		this.ljc = "ftp://"+host+":"+port;
		this.mm = mm;
		this.yhm = yhm;
		this.ip = host;
		this.port = port;
	}

	public SysSjglSjzt(String url, String user, String pwd) {
		this.ljc = url;
		this.yhm = user;
		this.mm = pwd;
	}

	/**
	 * 创建人代码@SYS_COMMON_USER;创建人代码@SYS_COMMON_USER
	 */
	@Column("cjrdm")
	private String cjrdm;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG;创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("cjrdwdm")
	private String cjrdwdm;
	/**
	 * 创建人单位名称;创建人单位名称
	 */
	@Column("cjrdwmc")
	private String cjrdwmc;
	/**
	 * 创建人姓名;创建人姓名
	 */
	@Column("cjrxm")
	private String cjrxm;
	/**
	 * 创建时间;创建时间
	 */
	@Column("cjsj")
	private String cjsj;
	/**
	 * 测试语句;测试语句
	 */
	@Column("csyj")
	private String csyj;
	/**
	 * 代码;代表唯一数据对象，多处使用，唯一
	 */
	@Column("dm")
	private String dm;
	/**
	 * 对象归属;就是该数据库的表所属SCHEMA
	 */
	@Column("dxgs")
	private String dxgs;
	/**
	 * 访问方式@SYS_SJGL_SJKFWFS;访问方式
	 */
	@Column("fwfs")
	private String fwfs;
	/**
	 * 更新时间;更新时间
	 */
	@Column("gxsj")
	private String gxsj;
	/**
	 * 主键;主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("id")
	private String id;
	/**
	 * JNDI名称;JNDI名称
	 */
	@Column("jndi")
	private String jndi;
	/**
	 * 简拼;简拼
	 */
	@Column("jp")
	private String jp;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("kzxx")
	private String kzxx;
	/**
	 * 连接串;连接串
	 */
	@Column("ljc")
	private String ljc;
	/**
	 * 类型@SYS_SJGL_DXZTLX;类型
	 */
	@Column("lx")
	private String lx;
	/**
	 * 名称;名称
	 */
	@Column("mc")
	private String mc;
	/**
	 * 密码;以后改为加密存储
	 */
	@Column("mm")
	private String mm;
	/**
	 * 描述;描述
	 */
	@Column("ms")
	private String ms;
	/**
	 * 排序;排序
	 */
	@Column("px")
	private BigDecimal px;
	/**
	 * 全拼;全拼
	 */
	@Column("qp")
	private String qp;
	/**
	 * 数据库驱动;数据库驱动
	 */
	@Column("sjkqd")
	private String sjkqd;
	/**
	 * 用户名;用户名
	 */
	@Column("yhm")
	private String yhm;
	/**
	 * 有效性@SYS_COMMON_LJPD;有效性@SYS_COMMON_LJPD
	 */
	@Column("yxx")
	private String yxx;
	/**
	 * 状态@SYS_COMMON_ZT;状态
	 */
	@Column("zt")
	private String zt;
	/**
	 * 所属应用@SYS_QX_APP
	 */
	@Column("ssyy")
	private String ssyy;
	/**
	 * 扩展信息对象
	 */
	@Transient
	@JSONField(serialize=false)
	@Builder.Default
	private JSONObject kzxxObj = new JSONObject();
	/**
	 * IP
	 */
	@Transient
	private String ip;
	/**
	 * PORT
	 */
	@Transient
	private int port;

	public void setKzxx(String kzxx) {
		this.kzxx = kzxx;
		if(StringUtil.isNotBlank(kzxx)){
			setKzxxObj(JSON.parseObject(kzxx));
		}
	}

	public String getLjc() {
		if(StringUtil.isNotBlank(ljc)&&!ljc.startsWith("/")&&"bdwj".equals(getLx())){
			//配置的相对目录则补充系统根目录
			return FileUtil.getFilePath(StringUtil.isNotBlank(Conf.getVal("benma666.service.xtgml"))
					?Conf.getVal("benma666.service.xtgml"):"/benma666",ljc);
		}
		return ljc;
	}

	/**
	 * mysql url解析正则
	 */
	private static Pattern mysqlUrlZz = Pattern.compile("^(jdbc:mysql://)([^/]*)/([^?]*).*$");
	/**
	 * vertica url解析正则
	 */
	private static Pattern verticaUrlZz = Pattern.compile("^(jdbc:vertica://)([^/]*)/([^?]*).*$");
	public String getDxgs() {
		if(StringUtil.isBlank(dxgs)){
			//对象归属没有人工配置
			if(DbType.oracle.name().equals(getLx())){
				return getYhm();
			}else if(DbType.mysql.name().equals(getLx())){
				Matcher m = mysqlUrlZz.matcher(getLjc());
				if(m.find()){
					return m.group(3);
				}else{
					throw new MyException("mysql连接串解析出错");
				}
			}else if(DbType.vertica.name().equals(getLx())){
				Matcher m = verticaUrlZz.matcher(getLjc());
				if(m.find()){
					return m.group(3);
				}else{
					throw new MyException("vertica连接串解析出错");
				}
			}
		}
		return dxgs;
	}
}
