/**
* by jingma 2018-12-12
*/
package cn.benma666.domain;

import cn.benma666.exception.MyException;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.clazz.kit.StringKit;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.List;

/**
 * 系统-数据管理-数据字段
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_SJGL_SJZD")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysSjglSjzd extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;

    /**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 新增展示@SYS_COMMON_LJPD
	 */
	@Column("XZZS")
	private String xzzs;
	/**
	 * 查询展示@SYS_COMMON_LJPD
	 */
	@Column("CXZS")
	private String cxzs = "0";
	/**
	 * 字典分页@SYS_COMMON_LJPD;字典下拉框是否分页展示
	 */
	@Column("ZDFY")
	private String zdfy;
	/**
	 * 编辑展示@SYS_COMMON_LJPD
	 */
	@Column("BJZS")
	private String bjzs;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 允许编辑@SYS_COMMON_LJPD
	 */
	@Column("YXBJ")
	private String yxbj;
	/**
	 * 字段字典类别@SYS_COMMON_ZDLB
	 */
	@Column("ZDZDLB")
	private String zdzdlb;
	/**
	 * 字段类型
	 */
	@Column("ZDLX")
	private String zdlx;
	/**
	 * 字典业务类别@SYS_SJGL_ZDYWLB
	 */
	@Column("ZDYWLB")
	private String zdywlb;
	/**
	 * 详情展示@SYS_COMMON_LJPD
	 */
	@Column("XQZS")
	private String xqzs = "0";
	/**
	 * 模板展示@SYS_COMMON_LJPD
	 */
	@Column("MBZS")
	private String mbzs = "0";
	/**
	 * CSS类;将填充到class中
	 */
	@Column("CSSL")
	private String cssl;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 字段名称
	 */
	@Column("ZDMC")
	private String zdmc;
	/**
	 * 字典多选@SYS_COMMON_LJPD;字典下拉框是否支持多选
	 */
	@Column("ZDDX")
	private String zddx;
	/**
	 * 控件类型@SYS_SJGL_KJLX;默认为1，1就是输入框，2是时间框，3是下拉框；
	 */
	@Column("KJLX")
	private String kjlx;
	/**
	 * 字段宽度
	 */
	@Column("ZDKD")
	private long zdkd;
	/**
	 * 字段提示
	 */
	@Column("ZDTS")
	private String zdts;
	/**
	 * 字段简拼
	 */
	@Column("ZDJP")
	private String zdjp;
	/**
	 * 后端验证规则;人工输入
	 */
	@Column("HDYZGZ")
	private String hdyzgz;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 去重编号
	 */
	@Column("QCBH")
	private int qcbh = 0;
	/**
	 * 允许排序@SYS_COMMON_LJPD
	 */
	@Column("YXPX")
	private String yxpx;
	/**
	 * 设值回调;设置值的回调方法
	 */
	@Column("SZHD")
	private String szhd;
	/**
	 * 格式化方法;方法名称，传入参数：数据、字段描述对象、行数据
	 */
	@Column("GSHFF")
	private String gshff;
	/**
	 * 字段代码
	 */
	@Column("ZDDM")
	private String zddm;
	/**
	 * 列表展示@SYS_COMMON_LJPD
	 */
	@Column("LBZS")
	private String lbzs;
	/**
	 * 字段全拼
	 */
	@Column("ZDQP")
	private String zdqp;
	/**
	 * 数据对象
	 */
	@Column("SJDX")
	private String sjdx;
	/**
	 * 前端样式;人工输入
	 */
	@Column("STYLE")
	private String style;
	/**
	 * 新增默认值
	 */
	@Column("XZMRZ")
	private String xzmrz;
	/**
	 * 标准字段
	 */
	@Column("BZZD")
	private String bzzd;
	/**
	 * 前端验证规则;人工输入
	 */
	@Column("QDYZGZ")
	private String qdyzgz;
	/**
	 * 排序
	 */
	@Column("PX")
	private int px;
	/**
	 * 查询必填@SYS_COMMON_LJPD
	 */
	@Column("CXBT")
	private String cxbt;
	/**
	 * 反格式化方法;方法名称，传入参数：数据、字段描述对象、行数据
	 */
	@Column("FGSHFF")
	private String fgshff;
	/**
	 * 字段长度
	 */
	@Column("ZDCD")
	private Long zdcd;
	/**
	 * 字段描述
	 */
	@Column("ZDMS")
	private String zdms;
	/**
	 * 字段高度
	 */
	@Column("ZDGD")
	private int zdgd;
	/**
	 * 查询默认值
	 */
	@Column("CXMRZ")
	private String cxmrz;
	/**
	 * 编辑必填@SYS_COMMON_LJPD
	 */
	@Column("BJBT")
	private String bjbt = "0";
	/**
	 * 查询模式@SYS_SJGL_SJZD_SSMS;字段的默认搜索模式，模糊、右模糊等
	 */
	@Column("CXMS")
	private String cxms;
	/**
	 * 资源等级@SYS_SJGL_ZYGJ;从高到低为1~10，按每三级分为高中低，一些较少使用的资源就设置为10级，10级默认不使用，需要使用时，需要特殊配置，系统默认6级
	 */
	@Column("ZYDJ")
	private String zydj;
	/**
	 * 原始字段代码;从载体中获取的原始字段代码，不做任何转换，进行载体相关操作时使用，本体系统全部采用驼峰
	 */
	@Column("YSZDDM")
	private String yszddm;
	/**
	 * 扩展信息的对化
	 */
	@Transient
	private JSONObject kzxxObj = new JSONObject();
	/**
	 * 导出表头背景色
	 */
	@Transient
	private String dcbtbjs;
	/**
	 * 导出默认背景色
	 */
	@Transient
	private String dcmrbjs;
	/**
	 * 导出定制背景色
	 */
	@Transient
	private JSONObject dcdzbjs=new JSONObject();
	/**
	 * excel-字典列表，存在则导出模板时会将该字典列表设置在Excel中，方便用户选择
	 */
	@Transient
	private List<String> excelZdlb;

	public void setKzxx(String kzxx) {
		if(StringUtil.isNotBlank(kzxx)&&StringUtil.isBlank(kzxxObj)){
			this.kzxx = kzxx;
			try {
				kzxxObj = JSON.parseObject(this.kzxx, Feature.OrderedField);
			}catch (Exception e){
				throw new MyException("json解析异常："+kzxx+e.getMessage(),e);
			}
		}
	}

	public String getZdywlb() {
		if(StringUtil.isBlank(zdywlb)){
			return "00";
		}
		return zdywlb;
	}

	public String getYszddm() {
		//若原始字段代码为空则取字段代码转换
		return StringUtil.isBlank(yszddm)? StringKit.enCodeUnderlined(getZddm()):yszddm;
	}
}
