/**
* by jingma 2022-10-05
*/
package cn.benma666.domain;

import cn.benma666.myutils.DateUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.math.BigDecimal;

/**
 * 系统-数据管理-编号生成
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_sjgl_bhsc")
@Setter
@Getter
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysSjglBhsc extends BasicBean{
	public SysSjglBhsc() {
		this.dqz = 0;
	}
	public SysSjglBhsc(String bhlb) {
		this.bhlb = bhlb;
	}

	/**
	 * 编号类别;编号类别
	 */
	@Column("bhlb")
	private String bhlb;
	/**
	 * 创建人代码@SYS_COMMON_USER;创建人代码@SYS_COMMON_USER
	 */
	@Column("cjrdm")
	private String cjrdm;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG;创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("cjrdwdm")
	private String cjrdwdm;
	/**
	 * 创建人单位名称;创建人单位名称
	 */
	@Column("cjrdwmc")
	private String cjrdwmc;
	/**
	 * 创建人姓名;创建人姓名
	 */
	@Column("cjrxm")
	private String cjrxm;
	/**
	 * 创建时间;创建时间
	 */
	@Column("cjsj")
	private String cjsj;
	/**
	 * 初始值;初始值
	 */
	@Column("csz")
	private int csz=1;
	/**
	 * 重置周期;重置周期
	 */
	@Column("czzq")
	private String czzq;
	/**
	 * 当前值;当前值
	 */
	@Column("dqz")
	private int dqz=0;
	/**
	 * 当前周期;当前周期
	 */
	@Column("dqzq")
	private String dqzq;
	/**
	 * 递增量;递增量
	 */
	@Column("dzl")
	private int dzl=1;
	/**
	 * 更新时间;更新时间
	 */
	@Column("gxsj")
	private String gxsj;
	/**
	 * 主键;主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("id")
	private String id;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("kzxx")
	private String kzxx;
	/**
	 * 名称;名称
	 */
	@Column("mc")
	private String mc;
	/**
	 * 描述;描述
	 */
	@Column("ms")
	private String ms;
	/**
	 * 排序;排序
	 */
	@Column("px")
	private BigDecimal px;
	/**
	 * 有效性@SYS_COMMON_LJPD;有效性@SYS_COMMON_LJPD
	 */
	@Column("yxx")
	private String yxx;
	/**
	 * 最大值;最大值
	 */
	@Column("zdz")
	private int zdz=Integer.MAX_VALUE;
	/**
	 * 编号模板
	 */
	private String bhmb;

	public String getDqzq() {
		if(StringUtil.isBlank(dqzq)){
			dqzq = DateUtil.getDateTimeStr(DateUtil.DATE_FORMATTER8);
		}
		return dqzq;
	}
}
