/**
* by jingma 2018-12-19
*/
package cn.benma666.domain;

import cn.benma666.iframe.Conf;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.SjsjEntity;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.TypeUtils;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Map;

/**
 * 系统-权限-用户信息
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "SYS_QX_YHXX")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysQxYhxx extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
    /**
     * 头像
     */
    @Column("tx")
    private String tx;
	/**
	 * 用户邮箱
	 */
	@Column("YHYX")
	private String yhyx;
	/**
	 * 有效期结束
	 */
	@Column("YXQJS")
	private String yxqjs;
	/**
	 * 备注
	 */
	@Column("BZ")
	private String bz;
	/**
	 * 政治面貌@SYS_COMMON_ZZMM
	 */
	@Column("ZZMM")
	private String zzmm;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 用户等级@SYS_QX_YHDJ
	 */
	@Column("YHDJ")
	private String yhdj;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * 用户代码
	 */
	@Column("YHDM")
	private String yhdm;
	/**
	 * 所属机构@SYS_COMMON_ORG
	 */
	@Column("SSJG")
	private String ssjg;
	/**
	 * 身份证号
	 */
	@Column("SFZH")
	private String sfzh;
	/**
	 * 联系电话
	 */
	@Column("LXDH")
	private String lxdh;
	/**
	 * 学历@SYS_COMMON_XL
	 */
	@Column("XL")
	private String xl;
	/**
	 * 用户描述
	 */
	@Column("YHMS")
	private String yhms;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 国籍@SYS_COMMON_GJ
	 */
	@Column("GJ")
	private String gj;
	/**
	 * 联系地址
	 */
	@Column("LXDZ")
	private String lxdz;
	/**
	 * 用户类型@SYS_QX_YHLX
	 */
	@Column("THLX")
	private String thlx;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 民族@SYS_COMMON_MZ
	 */
	@Column("MZ")
	private String mz;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 职务@SYS_QX_ZW
	 */
	@Column("ZW")
	private String zw;
	/**
	 * 有效期开始
	 */
	@Column("YXQKS")
	private String yxqks;
	/**
	 * 用户密码
	 */
	@Column("YHMM")
    @JSONField(serialize=false)
	private String yhmm;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 职级@SYS_QX_ZJ
	 */
	@Column("ZJ")
	private String zj;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 用户姓名
	 */
	@Column("YHXM")
	private String yhxm;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
    /**
     * 限制ip
     */
    @Column("XZIP")
    private String xzip;
    /**
     * 审核状态
     */
    @Column("SHZT")
    private String shzt;
    /**
     * 审核等级
     */
    @Column("SHDJ")
    private String shdj;
    /**
     * 微信用户id
     */
    @Column("WXYHID")
    private String wxyhid;
    /**
     * 微信用户信息json
     */
    @Column("WXYHXX")
    private String wxyhxx;
	/**
	 * 请求并发限制
	 */
	@Column("QQBFXZ")
	private int qqbfxz = 0;
	/**
	 * 请求并发限制
	 */
	@Column("SQM")
	private String sqm;
	/**
	* 机构信息
	*/
	@Transient
	private SysQxJgxx jgxx;
    /**
    * 角色信息
    */
    @Transient
    private Map<String,JSONObject> jsMap;
    /**
    * 权限信息
    */
    @Transient
//    @JSONField(serialize=false)
    private Map<String,JSONObject> qxMap;
	/**
	 * 对象权限映射关系
	 */
	@Transient
	private Map<String,JSONObject> dxqxys;
    /**
     * 客户端ip
     */
    @Transient
    private String clientIp;
    /**
     * 登陆凭证
     */
    @Transient
    private String token;
	/**
	 * 终端类别，默认PC
	 */
	@Transient
	private String zdlb = "PC";
	/**
	 * 登录失败次数
	 */
	@Transient
	private int dlsbcs;
	/**
	 * 项目代码，微信端登录使用
	 */
	@Transient
	private String projectCode;
	/**
	 * 微信登录接口返回结果
	 */
	@Transient
	private JSONObject wxLogin;
	/**
	 * 自动创建账号
	 */
	@Transient
	private Boolean zdcjZh;
	/**
	 * 登录模式，默认basic，basic：只返回token，details：返回完整用户信息
	 */
	@Transient
	private String model;

	public SysQxYhxx(String id, String tx, String yhyx, String yhdm, String ssjg,
					 String sfzh, String lxdh, String thlx, String yhxm,
					 SysQxJgxx jgxx, Map<String, JSONObject> jsMap,
					 Map<String, JSONObject> qxMap, Map<String, JSONObject> dxqxys,Map tails) {
		this.id = id;
		this.tx = tx;
		this.yhyx = yhyx;
		this.yhdm = yhdm;
		this.ssjg = ssjg;
		this.sfzh = sfzh;
		this.lxdh = lxdh;
		this.thlx = thlx;
		this.yhxm = yhxm;
		this.jgxx = jgxx;
		this.jsMap = jsMap;
		this.qxMap = qxMap;
		this.dxqxys = dxqxys;
		setTails(tails);
	}

	/**
	 * @return 转换为发送到前端的用户信息
	 */
    public SysQxYhxx toQd() {
		return new SysQxYhxx(id, tx, yhyx, yhdm, ssjg,sfzh, lxdh, thlx, yhxm,jgxx,
		 	jsMap,qxMap, dxqxys,getTails());
    }

	public int getQqbfxz() {
		if(qqbfxz==0){
			setQqbfxz(TypeUtils.castToInt(Conf.getVal("benma666.login.qqbfxz","10")));
		}
		return qqbfxz;
	}

	public String getZdlb() {
		if(StringUtil.isBlank(zdlb)){
			zdlb = "PC";
		}
		return zdlb;
	}
}
