/**
* by jingma 2023-10-23
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;
import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.annotation.entity.Table;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 系统-权限-权限信息
 */
@Table(name = "sys_qx_qxxx")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysQxQxxx extends BasicBean{

	/**
	 * 父权限@SYS_QX_QXXX;父权限
	 */
	@Column("fqx")
	private String fqx;
	/**
	 * 代码;代码
	 */
	@Column("dm")
	private String dm;
	/**
	 * 名称;名称
	 */
	@Column("mc")
	private String mc;
	/**
	 * 描述;描述
	 */
	@Column("ms")
	private String ms;
	/**
	 * 类型@SYS_QX_QXLX;类型@SYS_QX_QXLX
	 */
	@Column("lx")
	private String lx;
	/**
	 * 所属应用@SYS_QX_APP;所属应用@SYS_QX_APP
	 */
	@Column("ssyy")
	private String ssyy;
	/**
	 * 支持手机端@SYS_COMMON_LJPD;支持手机端
	 */
	@Column("zcsjd")
	private String zcsjd;
	/**
	 * 备注;备注
	 */
	@Column("bz")
	private String bz;
	/**
	 * 地址类型@SYS_QX_QXDZLX;地址类型，当为数据对象时会自动生成自带子权限
	 */
	@Column("dzlx")
	private String dzlx;
	/**
	 * 打开方式@SYS_QX_QXDKFS;打开方式@SYS_QX_QXDKFS
	 */
	@Column("dkfs")
	private String dkfs;
	/**
	 * 数据对象@SYS_SJGL_SJDX;SYS_SJGL_SJDX
	 */
	@Column("sjdx")
	private String sjdx;
	/**
	 * 权限地址;权限地址
	 */
	@Column("dz")
	private String dz;
	/**
	 * 图标@SYS_SJGL_ICON;对应文件管理的主键
	 */
	@Column("tb")
	private String tb;
	/**
	 * 排序;排序
	 */
	@Column("px")
	private BigDecimal px;
	/**
	 * 有效性@SYS_COMMON_LJPD;有效性@SYS_COMMON_LJPD
	 */
	@Column("yxx")
	private String yxx;
	/**
	 * 更新时间;更新时间
	 */
	@Column("gxsj")
	private String gxsj;
	/**
	 * 主键;主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("id")
	private String id;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("kzxx")
	private String kzxx;
	/**
	 * 创建时间;创建时间
	 */
	@Column("cjsj")
	private String cjsj;
	/**
	 * 创建人姓名;创建人姓名
	 */
	@Column("cjrxm")
	private String cjrxm;
	/**
	 * 创建人代码@SYS_COMMON_USER;创建人代码@SYS_COMMON_USER
	 */
	@Column("cjrdm")
	private String cjrdm;
	/**
	 * 创建人单位名称;创建人单位名称
	 */
	@Column("cjrdwmc")
	private String cjrdwmc;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG;创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("cjrdwdm")
	private String cjrdwdm;
	/**
	 * 名称简拼;名称简拼
	 */
	@Column("mcjp")
	private String mcjp;
	/**
	 * 名称全拼;名称全拼
	 */
	@Column("mcqp")
	private String mcqp;
	/**
	 * 图片图标;主要是移动端使用
	 */
	@Column("tptb")
	private String tptb;
	/**
	 * 是否有子权限
	 */
	@Transient
	private String myhaschild;
	/**
	 * 生成子权限
	 */
	@Transient
	private Boolean sczqx;
}
