/**
* by jingma 2022-04-02
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.math.BigDecimal;

/**
 * 系统-服务器
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_qx_fwq")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysQxFwq extends BasicBean{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 创建时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 更新时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 有效性@SYS_COMMON_LJPD
	 */
	@Column("YXX")
	private String yxx;
	/**
	 * 排序
	 */
	@Column("PX")
	private BigDecimal px;
	/**
	 * 扩展信息;JSON格式
	 */
	@Column("KZXX")
	private String kzxx;
	/**
	 * 创建人姓名
	 */
	@Column("CJRXM")
	private String cjrxm;
	/**
	 * 创建人代码@SYS_COMMON_USER
	 */
	@Column("CJRDM")
	private String cjrdm;
	/**
	 * 创建人单位名称
	 */
	@Column("CJRDWMC")
	private String cjrdwmc;
	/**
	 * 创建人单位代码@SYS_COMMON_ORG
	 */
	@Column("CJRDWDM")
	private String cjrdwdm;
	/**
	 * IP
	 */
	@Column("IP")
	private String ip;
	/**
	 * 描述
	 */
	@Column("MS")
	private String ms;
	/**
	 * 类别@SYS_QX_FWQLB
	 */
	@Column("LB")
	private String lb;
	/**
	 * 名称
	 */
	@Column("MC")
	private String mc;
	/**
	 * 类型@SYS_QX_FWQLX;win、 linux
	 */
	@Column("LX")
	private String lx;
	/**
	 * 密码
	 */
	@Column("MM")
	private String mm;
	/**
	 * 负责人
	 */
	@Column("FZR")
	private String fzr;
	/**
	 * 状态@SYS_COMMON_ZT
	 */
	@Column("ZT")
	private String zt;
	/**
	 * 远程端口
	 */
	@Column("YCDK")
	private String ycdk;
	/**
	 * 用户名
	 */
	@Column("YHM")
	private String yhm;
}
