/**
* by jingma 2022-10-05
*/
package cn.benma666.domain;

import cn.benma666.sjzt.SjsjEntity;
import lombok.*;

import org.beetl.sql.annotation.entity.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * 系统-日志-交换记录
 */
@javax.persistence.Entity
@org.beetl.sql.annotation.entity.Table(name = "sys_log_jhjl")
@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SjsjEntity
public class SysLogJhjl extends BasicBean{

	/**
	 * 备份目录;规则：配置的备份目录+年月日时，备份文件名与目标文件名一致
	 */
	@Column("BFML")
	private String bfml;
	/**
	 * 备注;如果报错可以报错异常信息
	 */
	@Column("BZ")
	private String bz;
	/**
	 * 创建时间;推送时间
	 */
	@Column("CJSJ")
	private String cjsj;
	/**
	 * 更新时间;接收时间
	 */
	@Column("GXSJ")
	private String gxsj;
	/**
	 * 工作模式@SYS_SJGL_ZNJH_GZMS
	 */
	@Column("GZMS")
	private String gzms;
	/**
	 * ID
	 */
	@Id
	@GeneratedValue(generator="idGenerator")
	@Column("ID")
	private String id;
	/**
	 * 来源目录
	 */
	@Column("LYML")
	private String lyml;
	/**
	 * 来源数据载体@GXPT2_ZNJH_WZZT;可能是本地文件或ftp
	 */
	@Column("LYSJZT")
	private String lysjzt;
	/**
	 * 来源文件大小
	 */
	@Column("LYWJDX")
	private long lywjdx;
	/**
	 * 来源文件名
	 */
	@Column("LYWJM")
	private String lywjm;
	/**
	 * 目标目录
	 */
	@Column("MBML")
	private String mbml;
	/**
	 * 目标数据载体@GXPT2_ZNJH_WZZT;可能是本地文件或ftp
	 */
	@Column("MBSJZT")
	private String mbsjzt;
	/**
	 * 目标文件大小
	 */
	@Column("MBWJDX")
	private long mbwjdx;
	/**
	 * 目标文件名;规则：当前时间17位字符串_文件编号_文件大小_源文件名
	 */
	@Column("MBWJM")
	private String mbwjm;
	/**
	 * 相关交换@SYS_SJGL_ZNJH
	 */
	@Column("XGJH")
	private String xgjh;
	/**
	 * 是否补漏@SYS_COMMON_LJPD
	 */
	@Column("SFBL")
	private int sfbl;
	/**
	 * 文件编号
	 */
	@Column("WJBH")
	private long wjbh;
	/**
	 * 文件状态@SYS_SJGL_ZNJH_WJZT;推送文件时根据情况设置：正常推送、文件名不规范、超出大小限制、推送异常
	 */
	@Column("WJZT")
	private String wjzt;
	/**
	 * 文件指纹
	 */
	@Column("WJZW")
	private String wjzw;
}
