package cn.benma666.domain;

import cn.benma666.exception.MyException;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.json.MyJSONObject;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import org.beetl.sql.core.TailBean;

import org.beetl.sql.annotation.entity.Table;
import java.io.Serializable;
import java.util.Map;


/**
* 基础bean <br/>
* date: 2019年4月17日 <br/>
* @author jingma
* @version 0.2
*/
public class BasicBean extends TailBean implements Serializable{

    /**
    *
    */
    private static final long serialVersionUID = 1710639538662210517L;

    public BasicBean(){
    }

    @Override
    public Object get(String key) {
        Object val = tailsToJSONObject().get(key);
        if(val==null){
            return toJSONObject().get(key);
        }else {
            return val;
        }
    }
    public boolean containsKey(String key){
        return StringUtil.isNotBlank(get(key));
    }

    @Override
    public void set(String key, Object value) {
        ClassUtil.setVal(key, value,this,super.getTails());
    }

    /**
     * 设置额外信息
     * @param tails 额外信息
     */
    public void setTails(Map tails){
        extMap = tails;
    }
    /**
     * 转为json对象
     */
    public MyJSONObject toJSONObject(){
        return MyJSONObject.parseObject(toString(), Feature.OrderedField);
    }
    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

    @Override
    public Object clone() {
        return toJSONObject().toJavaObject(this.getClass());
    }

    /**
     * @return 扩展参数转换出的json对象
     */
    public MyJSONObject tailsToJSONObject(){
        return new MyJSONObject(super.getTails());
    }

    /**
     * 根据bean获取对象代码
     * @param t bean类
     * @param <T> 泛型
     * @return 对象代码
     */
    public static <T extends BasicBean> String beanToDxdm(Class<T> t) {
        Table table = t.getAnnotation(Table.class);
        if(table==null){
            throw new MyException("你设置的类没有配置表，无法自动转换获取对象代码："+ t.getName());
        }
        String dxdm = table.name().toUpperCase();
        long count = Db.use().lambdaQuery(SysSjglSjdx.class)
                .andEq(SysSjglSjdx::getDxdm, dxdm).count();
        if(count!=1){
            throw new MyException("你设置的类自动转换得到的对象代码找到对应的对象配置："+dxdm);
        }
        return dxdm;
    }

    @Override
    public Map<String, Object> getTails() {
        Map<String, Object> tails = super.getTails();
        if(tails==null||tails.size()==0){
            return null;
        }
        return tails;
    }
}
