package cn.benma666.crypt;

import cn.benma666.exception.MyException;
import cn.hutool.log.LogFactory;
import org.apache.commons.net.util.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;

public class DesUtil {

    private final static String DES = "DES";

    public static void main(String[] args) throws Exception {
        String data = "事实上是测试内容 456 sss";
//        String key = "s2&%34%7(*7s!@8#";
        String key = "12345678";
        System.err.println(encrypt(data, key));
        System.err.println(decrypt(
                "+lDDdfvKtQF87Z4pG+rK9A==", "YA3EPe3fj/XrUtXDBr0y/Q=="));
    }

    /**
     * Description 根据键值进行加密
     *
     * @param data 待加密数据
     * @param key  加密键byte数组
     * @return 加密结果
     */
    public static String encrypt(String data, String key) {
        byte[] bt;
        try {
            bt = encrypt(data.getBytes(StandardCharsets.UTF_8), key.getBytes());
        } catch (Exception e) {
            LogFactory.get().debug(data + "->" + key + "加密异常", e);
            throw new MyException("des加密密出错");
        }
        return Base64.encodeBase64String(bt).replace("\r","").replace("\n","");
    }

    /**
     * Description 根据键值进行解密
     *
     * @param data 待加密数据
     * @param key  加密键byte数组
     * @return 加密结果
     */
    public static String decrypt(String data, String key) {
        if (data == null)
            return null;
        byte[] buf;
        try {
            buf = Base64.decodeBase64(data);
            byte[] bt = decrypt(buf, key.getBytes());
            return new String(bt, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new MyException("des解密出错",e,data + "->" + key + "解密异常");
        }
    }

    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();

        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);

        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);

        // Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance(DES);

        // 用密钥初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, securekey, sr);

        return cipher.doFinal(data);
    }

    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();

        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);

        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);

        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance(DES);

        // 用密钥初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, securekey, sr);

        return cipher.doFinal(data);
    }
}
