/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sm.sm2;

import cn.benma666.myutils.ByteUtil;
import cn.benma666.sm.sm2.Cipher;
import cn.benma666.sm.sm2.SM2;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2EncDecUtils {
    public static final String public_key = "public_key";
    public static final String private_key = "private_key";

    public static Map<String, String> generateKeyPair() {
        AsymmetricCipherKeyPair key;
        SM2 sm2 = SM2.Instance();
        while (((ECPrivateKeyParameters)(key = sm2.ecc_key_pair_generator.generateKeyPair()).getPrivate()).getD().toByteArray().length != 32) {
        }
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        String pubk = ByteUtil.byteToHex(publicKey.getEncoded());
        String prik = ByteUtil.byteToHex(privateKey.toByteArray());
        System.out.println("\u516c\u94a5: " + pubk);
        System.out.println("\u79c1\u94a5: " + prik);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(public_key, pubk);
        result.put(private_key, prik);
        return result;
    }

    public static String encrypt(byte[] publicKey, byte[] data) throws IOException {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return new StringBuffer(ByteUtil.byteToHex(c1.getEncoded())).append(ByteUtil.byteToHex(c3)).append(ByteUtil.byteToHex(source)).toString();
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        String data = ByteUtil.byteToHex(encryptedData);
        byte[] c1Bytes = ByteUtil.hexToByte(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c3 = ByteUtil.hexToByte(data.substring(130, 194));
        byte[] c2 = ByteUtil.hexToByte(data.substring(194, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }

    public static void main(String[] args) throws Exception {
    }

    private static void singleThreadTest() throws Exception {
        String plainText = "sourceText";
        byte[] sourceData = plainText.getBytes();
        Map<String, String> keymap = SM2EncDecUtils.generateKeyPair();
        long start = System.currentTimeMillis();
        int counts = 100;
        for (int j = 0; j < counts; ++j) {
            String cipherText = SM2EncDecUtils.encrypt(ByteUtil.hexToByte(keymap.get(public_key)), sourceData);
            System.out.println("\u52a0\u5bc6\u524d\u957f\u5ea6: " + plainText.length() + ";\u52a0\u5bc6\u540e\u957f\u5ea6: " + cipherText.length());
            String plainTextEncripted = new String(SM2EncDecUtils.decrypt(ByteUtil.hexToByte(keymap.get(private_key)), ByteUtil.hexToByte(cipherText)));
            if (!plainText.equals(plainTextEncripted)) continue;
            System.out.println("------\u89e3\u5bc6\u540e\u540c\u539f\u6587\u662f\u5426\u4e00\u81f4: " + plainText.equals(plainTextEncripted) + "----------------------");
        }
        long end = System.currentTimeMillis();
        System.out.println("\u5e73\u5747\u8017\u65f6:" + (end - start) / (long)counts + "ms\u3002");
    }

    private static void mutiThreadTest() {
        String plainText = "sourceText";
        byte[] sourceData = plainText.getBytes();
        Map<String, String> keymap = SM2EncDecUtils.generateKeyPair();
        int counts = 10;
        for (int i = 0; i < counts; ++i) {
            new Thread(() -> {
                try {
                    for (int j = 0; j < counts; ++j) {
                        String cipherText = SM2EncDecUtils.encrypt(ByteUtil.hexToByte((String)keymap.get(public_key)), sourceData);
                        if (plainText.equals(new String(SM2EncDecUtils.decrypt(ByteUtil.hexToByte((String)keymap.get(private_key)), ByteUtil.hexToByte(cipherText))))) continue;
                        System.out.println("------\u89e3\u5bc6\u540e\u540c\u539f\u6587\u4e0d\u4e00\u81f4:" + Thread.currentThread().getName() + "--------------");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println(" --------------->\u7ebf\u7a0b" + Thread.currentThread().getName() + "\u6267\u884c\u5b8c\u6210.---------------------");
            }).start();
        }
    }
}

