/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sm;

import cn.benma666.myutils.ByteUtil;
import cn.benma666.sm.SM4Base;
import cn.benma666.sm.SM4_Context;
import com.alibaba.druid.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.Base64;

public class SM4 {
    private String secretKey = "";
    private String iv = "";
    private boolean hexString = false;

    public static void main(String[] args) throws IOException {
        String plainText = "ererfeiisgod";
        SM4 sm4 = new SM4();
        sm4.secretKey = "JeF8U9wHFOMfs2Y8";
        sm4.hexString = false;
        System.out.println("ECB\u6a21\u5f0f");
        String cipherText = sm4.encryptDataToString_ECB(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        System.out.println("");
        plainText = sm4.decryptDataToString_ECB(cipherText);
        System.out.println("\u660e\u6587: " + plainText);
        System.out.println("");
        System.out.println("CBC\u6a21\u5f0f");
        sm4.iv = "UISwD9fW6cFh9SNS";
        cipherText = sm4.encryptDataToString_CBC(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        System.out.println("");
        plainText = sm4.decryptDataToString_CBC(cipherText);
        System.out.println("\u660e\u6587: " + plainText);
    }

    public String decryptDataToString_CBC(String cipherText) {
        return this.decryptDataToString_CBC(cipherText, "GBK");
    }

    public String decryptDataToString_CBC(String cipherText, String charset) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, charset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptDataToString_CBC(byte[] bytes) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, bytes);
            return new String(decrypted, "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decryptData_ECB(byte[] bytes) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decryptData_ECB(String cipherText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64((String)cipherText));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptDataToString_ECB(String cipherText) {
        return this.decryptDataToString_ECB(cipherText, "GBK");
    }

    public String decryptDataToString_ECB(String cipherText, String charset) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, charset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptDataToString_CBC(byte[] bytes) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, bytes);
            String cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptDataToString_CBC(String plainText) {
        return this.encryptDataToString_CBC(plainText, "GBK");
    }

    public String encryptDataToString_CBC(String plainText, String charset) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes(charset));
            return this.getString(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getString(byte[] encrypted) {
        String cipherText = Base64.encodeBase64String((byte[])encrypted);
        if (cipherText != null && cipherText.trim().length() > 0) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(cipherText);
            cipherText = m.replaceAll("");
        }
        return cipherText;
    }

    public byte[] encryptData_CBC(String plainText, String charset) {
        try {
            return this.encryptData_CBC(plainText.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encryptData_CBC(byte[] bytes) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            return sm4.sm4_crypt_cbc(ctx, ivBytes, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encryptData_ECB(byte[] bytes) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encryptData_ECB(File f) throws IOException {
        if (f.exists()) {
            FileInputStream inStream = new FileInputStream(f);
            return this.encryptData_ECB(Utils.readByteArray((InputStream)inStream));
        }
        throw new IOException("File not Found");
    }

    public byte[] encryptData_ECB(String plainText) {
        return this.encryptData_ECB(plainText, "GBK");
    }

    public byte[] encryptData_ECB(String plainText, String charset) {
        try {
            return this.encryptData_ECB(plainText.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptDataToString_ECB(String plainText) {
        return this.encryptDataToString_ECB(plainText, "GBK");
    }

    public String encryptDataToString_ECB(String plainText, String charset) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4Base sm4 = new SM4Base();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes(charset));
            return this.getString(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setIv(String iv) {
        StringBuilder ivBuilder = new StringBuilder(iv);
        while (ivBuilder.length() < 16) {
            ivBuilder.append("0");
        }
        iv = ivBuilder.toString();
        if (iv.length() > 16) {
            iv = iv.substring(0, 16);
        }
        this.iv = iv;
    }

    public void setSecretKey(String secretKey) {
        StringBuilder secretKeyBuilder = new StringBuilder(secretKey);
        while (secretKeyBuilder.length() < 16) {
            secretKeyBuilder.append("0");
        }
        secretKey = secretKeyBuilder.toString();
        if (secretKey.length() > 16) {
            secretKey = secretKey.substring(0, 16);
        }
        this.secretKey = secretKey;
    }

    public void setHexString(boolean hexString) {
        this.hexString = hexString;
    }
}

