/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sm;

import cn.benma666.iframe.BasicObject;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FMSM4
extends BasicObject {
    SecretKey key = null;
    private String mm;

    public FMSM4(String mm) {
        if (mm.length() > 16) {
            this.mm = mm.substring(0, 16);
        } else {
            StringBuilder mmBuilder = new StringBuilder(mm);
            while (mmBuilder.length() < 16) {
                mmBuilder.append("0");
            }
            this.mm = mmBuilder.toString();
        }
        try {
            KeyGenerator skg = KeyGenerator.getInstance("SM4", "FishermanJCE");
            skg.init(128);
            this.key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("gen SM4 key fail");
            e.printStackTrace();
        }
    }

    public SecretKey GenerateKey(String alg, int bits) {
        SecretKey key = null;
        try {
            KeyGenerator skg = KeyGenerator.getInstance(alg, "FishermanJCE");
            skg.init(bits);
            key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("gen " + alg + " key fail");
            e.printStackTrace();
            return null;
        }
        return key;
    }

    public void SYSEncAndDecTest() {
        byte[] sm4key = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
        SecretKeySpec key1 = new SecretKeySpec(sm4key, "SM4");
        byte[] plainData = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
        byte[] cipherdata1 = this.SYSEnc(key1, "ECB", false, plainData, null);
        if (cipherdata1 == null) {
            this.log.error("SM4  enc is error!");
            return;
        }
        this.log.info("SM4  enc is ok!");
        SecretKey key = this.GenerateKey("AES", 128);
        byte[] indata = new byte[126];
        for (int i = 0; i < indata.length; ++i) {
            indata[i] = (byte)i;
        }
        byte[] iv = new byte[16];
        SecureRandom ran = null;
        try {
            ran = SecureRandom.getInstance("TrueRandom", "FishermanJCE");
            ran.nextBytes(iv);
        }
        catch (Exception e) {
            this.log.error("gen iv random error");
            e.printStackTrace();
        }
        byte[] cipherdata = this.SYSEnc(key, "CBC", true, indata, iv);
        if (cipherdata1 == null) {
            this.log.error("AES  enc is error!");
            return;
        }
        this.log.info("AES  enc is ok!");
        byte[] tmpdata = this.SYSDec(key, "CBC", true, cipherdata, iv);
        if (!new String(indata).equalsIgnoreCase(new String(tmpdata))) {
            this.log.error("AES Enc and Dec is error");
            return;
        }
        this.log.info("AES Enc and Dec is ok");
        key = this.GenerateInternalKey(1);
        indata = new byte[128];
        for (int i = 0; i < indata.length; ++i) {
            indata[i] = (byte)i;
        }
        cipherdata = this.SYSEnc(key, "ECB", false, indata, null);
        if (cipherdata == null) {
            this.log.error("SM4  enc is error!");
            return;
        }
        this.log.info("SM4  enc is ok!");
        tmpdata = this.SYSDec(key, "ECB", false, cipherdata, null);
        if (!new String(indata).equalsIgnoreCase(new String(tmpdata))) {
            this.log.error("SM4 Enc and Dec is error");
            return;
        }
        this.log.info("SM4 Enc and Dec is ok");
        cipherdata = this.InternalSM4Enc(1, "CBC", true, indata);
        if (cipherdata == null) {
            this.log.error("SM4 internal enc is error!");
            return;
        }
        this.log.info("SM4 internal enc is ok!");
        tmpdata = this.InternalSM4Dec(1, "CBC", true, cipherdata);
        if (!new String(indata).equalsIgnoreCase(new String(tmpdata))) {
            this.log.error("SM4 internal Enc and Dec is error");
            return;
        }
        this.log.info("SM4 internal Enc and Dec is ok");
    }

    public SecretKey ExportInternalKey(int keyid) {
        SecretKey sm1key = null;
        String keyalg = "RandomSM4InnerKey" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(keyalg, "FishermanJCE");
            KeyGenerator skg = KeyGenerator.getInstance("SM4", "FishermanJCE");
            skg.init(128, ran);
            sm1key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("export SM1 key fail,keynum is " + keyid);
            e.printStackTrace();
        }
        return sm1key;
    }

    public SecretKey GenerateInternalKey(int keyid) {
        SecretKey sm1key = null;
        String keyalg = "RandomSM4" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(keyalg, "FishermanJCE");
            KeyGenerator skg = KeyGenerator.getInstance("SM4", "FishermanJCE");
            skg.init(128, ran);
            sm1key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("gen SM1 key fail,keynum is " + keyid);
            e.printStackTrace();
        }
        return sm1key;
    }

    public byte[] SYSEnc(SecretKey key, String mode, boolean ispad, byte[] indata, byte[] iv) {
        String alg = "";
        byte[] cipherdata = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = key.getAlgorithm();
        alg = alg + "/";
        alg = alg + mode;
        alg = alg + "/";
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        try {
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(1, (Key)key, ivspe);
            } else {
                cp.init(1, key);
            }
            cipherdata = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " enc error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            ret = new byte[cipherdata.length + tail.length];
            System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
            System.arraycopy(tail, 0, ret, cipherdata.length, tail.length);
        } else {
            ret = new byte[cipherdata.length];
            System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
        }
        return ret;
    }

    public byte[] SYSDec(SecretKey key, String mode, boolean ispad, byte[] indata, byte[] iv) {
        String alg = "";
        byte[] data = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = key.getAlgorithm();
        alg = alg + "/";
        alg = alg + mode;
        alg = alg + "/";
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        try {
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(2, (Key)key, ivspe);
            } else {
                cp.init(2, key);
            }
            data = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " dec error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            ret = new byte[data.length + tail.length];
            System.arraycopy(data, 0, ret, 0, data.length);
            System.arraycopy(tail, 0, ret, data.length, tail.length);
        } else {
            ret = new byte[data.length];
            System.arraycopy(data, 0, ret, 0, data.length);
        }
        return ret;
    }

    public byte[] InternalSM4Enc(int keyid, String mode, boolean ispad, byte[] indata) {
        byte[] iv = this.mm.getBytes();
        String alg = "SM4/" + mode + "/";
        byte[] cipherdata = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        String sysalg = "RandomSM4" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(sysalg, "FishermanJCE");
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(1, (Key)this.key, ivspe, ran);
            } else {
                cp.init(1, (Key)this.key, ran);
            }
            cipherdata = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " internal enc error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            if (cipherdata == null) {
                ret = new byte[tail.length];
                System.arraycopy(tail, 0, ret, 0, tail.length);
            } else {
                ret = new byte[cipherdata.length + tail.length];
                System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
                System.arraycopy(tail, 0, ret, cipherdata.length, tail.length);
            }
        } else {
            ret = new byte[cipherdata.length];
            System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
        }
        return ret;
    }

    public byte[] InternalSM4Dec(int keyid, String mode, boolean ispad, byte[] indata) {
        byte[] iv = this.mm.getBytes();
        String alg = "SM4/" + mode + "/";
        byte[] data = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        String sysran = "RandomSM4" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(sysran, "FishermanJCE");
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(2, (Key)this.key, ivspe, ran);
            } else {
                cp.init(2, (Key)this.key, ran);
            }
            data = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " internal dec error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            if (data != null) {
                ret = new byte[data.length + tail.length];
                System.arraycopy(data, 0, ret, 0, data.length);
                System.arraycopy(tail, 0, ret, data.length, tail.length);
            } else {
                ret = new byte[tail.length];
                System.arraycopy(tail, 0, ret, 0, tail.length);
            }
        } else {
            ret = new byte[data.length];
            System.arraycopy(data, 0, ret, 0, data.length);
        }
        return ret;
    }
}

