/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sm;

import cn.benma666.iframe.BasicObject;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class FMSM1
extends BasicObject {
    public static final int DATALEN = 16384;
    SecretKey key = null;
    private String mm;

    public FMSM1(String mm) {
        if (mm.length() > 16) {
            this.mm = mm.substring(0, 16);
        } else {
            StringBuilder mmBuilder = new StringBuilder(mm);
            while (mmBuilder.length() < 16) {
                mmBuilder.append("0");
            }
            this.mm = mmBuilder.toString();
        }
        try {
            KeyGenerator skg = KeyGenerator.getInstance("SM1", "FishermanJCE");
            skg.init(128);
            this.key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("gen SM1 key fail");
            e.printStackTrace();
        }
    }

    public void SM1EncAndDecTest() {
        byte[] cipherdata = null;
        byte[] tmpdata = null;
        byte[] indata = new byte[126];
        for (int i = 0; i < indata.length; ++i) {
            indata[i] = (byte)i;
        }
        byte[] iv = new byte[16];
        SecureRandom ran = null;
        try {
            ran = SecureRandom.getInstance("TrueRandom", "FishermanJCE");
            ran.nextBytes(iv);
        }
        catch (Exception e) {
            this.log.error("gen iv random error");
            e.printStackTrace();
        }
        cipherdata = this.InternalSM1Enc(1, "CBC", true, indata);
        if (cipherdata == null) {
            this.log.error("SM1 internal enc is error!");
            return;
        }
        this.log.info("SM1 internal enc is ok!");
        tmpdata = this.InternalSM1Dec(1, "CBC", true, cipherdata);
        if (!new String(indata).equalsIgnoreCase(new String(tmpdata))) {
            this.log.error("SM1 internal Enc and Dec is error");
            return;
        }
        this.log.info("SM1 internal Enc and Dec is ok");
        SecretKey sm1Key = this.ExportInternalKey(1);
        cipherdata = this.ExternalSM1Enc("CBC", true, indata, sm1Key, iv);
        if (cipherdata == null) {
            this.log.error("SM1 external enc is error!");
            return;
        }
        this.log.info("SM1 external enc is ok!");
        tmpdata = this.ExternalSM1Dec("CBC", true, cipherdata, sm1Key, iv);
        if (!new String(indata).equalsIgnoreCase(new String(tmpdata))) {
            this.log.error("SM1 external Enc and Dec is error");
            return;
        }
        this.log.info("SM1 external Enc and Dec is ok");
        indata = new byte[17408];
        for (int i = 0; i < indata.length; ++i) {
            indata[i] = (byte)i;
        }
        cipherdata = this.ExternalSM1MultiEnc("CBC", true, indata, sm1Key, iv);
        if (cipherdata == null) {
            this.log.error("SM1 external multiple enc is error!");
            return;
        }
        this.log.info("SM1 external multiple enc is ok!");
        tmpdata = this.ExternalSM1MultiDec("CBC", true, cipherdata, sm1Key, iv);
        if (!new String(indata).equalsIgnoreCase(new String(tmpdata))) {
            this.log.error("SM1 external multiple Enc and Dec is error");
            return;
        }
        this.log.info("SM1 external multiple Enc and Dec is ok");
    }

    public SecretKey ExportInternalKey(int keyid) {
        SecretKey sm1key = null;
        String keyalg = "RandomSM1InnerKey" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(keyalg, "FishermanJCE");
            KeyGenerator skg = KeyGenerator.getInstance("SM1", "FishermanJCE");
            skg.init(128, ran);
            sm1key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("export SM1 key fail,keynum is " + keyid);
            e.printStackTrace();
        }
        return sm1key;
    }

    public SecretKey GenerateInternalKey(int keyid) {
        SecretKey sm1key = null;
        String keyalg = "RandomSM1" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(keyalg, "FishermanJCE");
            KeyGenerator skg = KeyGenerator.getInstance("SM1", "FishermanJCE");
            skg.init(128, ran);
            sm1key = skg.generateKey();
        }
        catch (Exception e) {
            this.log.error("gen SM1 key fail,keynum is " + keyid);
            e.printStackTrace();
        }
        return sm1key;
    }

    public byte[] InternalSM1Enc(int keyid, String mode, boolean ispad, byte[] indata) {
        byte[] iv = this.mm.getBytes();
        String alg = "SM1/" + mode + "/";
        byte[] cipherdata = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        String sysalg = "RandomSM1" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(sysalg, "FishermanJCE");
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(1, (Key)this.key, ivspe, ran);
            } else {
                cp.init(1, (Key)this.key, ran);
            }
            cipherdata = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " internal enc error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            if (cipherdata == null) {
                ret = new byte[tail.length];
                System.arraycopy(tail, 0, ret, 0, tail.length);
            } else {
                ret = new byte[cipherdata.length + tail.length];
                System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
                System.arraycopy(tail, 0, ret, cipherdata.length, tail.length);
            }
        } else {
            ret = new byte[cipherdata.length];
            System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
        }
        return ret;
    }

    public byte[] InternalSM1Dec(int keyid, String mode, boolean ispad, byte[] indata) {
        byte[] iv = this.mm.getBytes();
        String alg = "SM1/" + mode + "/";
        byte[] data = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        String sysran = "RandomSM1" + keyid;
        try {
            SecureRandom ran = SecureRandom.getInstance(sysran, "FishermanJCE");
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(2, (Key)this.key, ivspe, ran);
            } else {
                cp.init(2, (Key)this.key, ran);
            }
            data = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " internal dec error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            if (data != null) {
                ret = new byte[data.length + tail.length];
                System.arraycopy(data, 0, ret, 0, data.length);
                System.arraycopy(tail, 0, ret, data.length, tail.length);
            } else {
                ret = new byte[tail.length];
                System.arraycopy(tail, 0, ret, 0, tail.length);
            }
        } else {
            ret = new byte[data.length];
            System.arraycopy(data, 0, ret, 0, data.length);
        }
        return ret;
    }

    public byte[] ExternalSM1Enc(String mode, boolean ispad, byte[] indata, SecretKey keyBuf, byte[] iv) {
        String alg = "SM1/" + mode + "/";
        byte[] cipherdata = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        try {
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(1, (Key)keyBuf, ivspe);
            } else {
                cp.init(1, keyBuf);
            }
            cipherdata = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " external enc error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            if (cipherdata == null) {
                ret = new byte[tail.length];
                System.arraycopy(tail, 0, ret, 0, tail.length);
            } else {
                ret = new byte[cipherdata.length + tail.length];
                System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
                System.arraycopy(tail, 0, ret, cipherdata.length, tail.length);
            }
        } else {
            ret = new byte[cipherdata.length];
            System.arraycopy(cipherdata, 0, ret, 0, cipherdata.length);
        }
        return ret;
    }

    public byte[] ExternalSM1Dec(String mode, boolean ispad, byte[] indata, SecretKey keyBuf, byte[] iv) {
        String alg = "SM1/" + mode + "/";
        byte[] data = null;
        byte[] tail = null;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        try {
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(2, (Key)keyBuf, ivspe);
            } else {
                cp.init(2, keyBuf);
            }
            data = cp.update(indata);
            tail = cp.doFinal();
        }
        catch (Exception e) {
            this.log.error(alg + " external dec error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = null;
        if (tail != null) {
            if (data != null) {
                ret = new byte[data.length + tail.length];
                System.arraycopy(data, 0, ret, 0, data.length);
                System.arraycopy(tail, 0, ret, data.length, tail.length);
            } else {
                ret = new byte[tail.length];
                System.arraycopy(tail, 0, ret, 0, tail.length);
            }
        } else {
            ret = new byte[data.length];
            System.arraycopy(data, 0, ret, 0, data.length);
        }
        return ret;
    }

    public byte[] ExternalSM1MultiEnc(String mode, boolean ispad, byte[] indata, SecretKey keyBuf, byte[] iv) {
        String alg = "SM1/" + mode + "/";
        int len = indata.length;
        byte[] cipherdata = new byte[len + 16];
        byte[] tail = null;
        byte[] tempData = null;
        int tailLen = 0;
        int offset = 0;
        int cipheroffset = 0;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        try {
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(1, (Key)keyBuf, ivspe);
            } else {
                cp.init(1, keyBuf);
            }
            while ((tailLen = len - offset) > 16384) {
                tempData = cp.update(indata, offset, 16384);
                System.arraycopy(tempData, 0, cipherdata, cipheroffset, tempData.length);
                offset += 16384;
                cipheroffset += tempData.length;
            }
            tempData = cp.update(indata, offset, tailLen);
            tail = cp.doFinal();
            System.arraycopy(tempData, 0, cipherdata, cipheroffset, tempData.length);
            System.arraycopy(tail, 0, cipherdata, cipheroffset += tempData.length, tail.length);
        }
        catch (Exception e) {
            System.out.println(alg + " external enc error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = new byte[cipheroffset += tail.length];
        System.arraycopy(cipherdata, 0, ret, 0, cipheroffset);
        return ret;
    }

    public byte[] ExternalSM1MultiDec(String mode, boolean ispad, byte[] indata, SecretKey keyBuf, byte[] iv) {
        String alg = "SM1/" + mode + "/";
        int len = indata.length;
        byte[] cipherdata = new byte[len];
        byte[] tail = null;
        byte[] tempData = null;
        int tailLen = 0;
        int offset = 0;
        int cipheroffset = 0;
        IvParameterSpec ivspe = null;
        alg = ispad ? alg + "PKCS5PADDING" : alg + "NOPADDING";
        try {
            Cipher cp = Cipher.getInstance(alg, "FishermanJCE");
            if (mode.equalsIgnoreCase("CBC")) {
                ivspe = new IvParameterSpec(iv, 0, 16);
                cp.init(2, (Key)keyBuf, ivspe);
            } else {
                cp.init(2, keyBuf);
            }
            while ((tailLen = len - offset) > 16384) {
                tempData = cp.update(indata, offset, 16384);
                System.arraycopy(tempData, 0, cipherdata, cipheroffset, tempData.length);
                offset += 16384;
                cipheroffset += tempData.length;
            }
            tempData = cp.update(indata, offset, tailLen);
            tail = cp.doFinal();
            System.arraycopy(tempData, 0, cipherdata, cipheroffset, tempData.length);
            System.arraycopy(tail, 0, cipherdata, cipheroffset += tempData.length, tail.length);
        }
        catch (Exception e) {
            System.out.println(alg + " external dec error");
            e.printStackTrace();
            return null;
        }
        byte[] ret = new byte[cipheroffset += tail.length];
        System.arraycopy(cipherdata, 0, ret, 0, cipheroffset);
        return ret;
    }
}

