/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.rabbit;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.myutils.FileUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.SjztBzcwjdxExecption;
import cn.benma666.sjzt.SjztExecRunnable;
import cn.benma666.sjzt.SjztPooledObjectFactory;
import cn.benma666.sjzt.bdwj.BdwjFile;
import cn.benma666.sjzt.rabbit.MQConsumer;
import cn.benma666.sjzt.rabbit.RabbitMQClient;
import cn.benma666.sjzt.rabbit.RabbitMQFile;
import com.alibaba.druid.util.Utils;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.GetResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RabbitMQ
extends BasicSjzt {
    private static RabbitMQ rabbitMQ = null;
    private final GenericObjectPool objectPool;

    protected RabbitMQ(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        SjztPooledObjectFactory factory = new SjztPooledObjectFactory(sjzt);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setTestOnCreate(true);
        config.setTestOnBorrow(true);
        config.setMinIdle(2);
        config.setMaxIdle(5);
        config.setMaxTotal(20);
        config.setMaxWait(Duration.ofSeconds(300L));
        this.objectPool = new GenericObjectPool((PooledObjectFactory)factory, config);
        RabbitMQClient rabbitMQClient = null;
        try {
            rabbitMQClient = this.borrowClient();
        }
        catch (Exception e) {
            throw new MyException(name + "\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            this.returnClient(rabbitMQClient);
        }
        if (rabbitMQ == null) {
            rabbitMQ = this;
        }
        cache.put(name, (Object)this);
    }

    public void returnClient(RabbitMQClient client) {
        this.log.trace("\u91ca\u653e\u56de\u8fde\u63a5\u6c60\uff1a{}", (Object)this.name);
        if (client != null) {
            this.objectPool.returnObject((Object)client);
        }
    }

    public RabbitMQClient borrowClient() throws Exception {
        this.log.trace("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6\uff1a{}", (Object)this.name);
        return (RabbitMQClient)this.objectPool.borrowObject();
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        RabbitMQClient adminClient = (RabbitMQClient)client;
        return adminClient != null && adminClient.getChannel() != null && adminClient.getChannel().isOpen();
    }

    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        RabbitMQClient rabbitMQClient = (RabbitMQClient)client;
        rabbitMQClient.close();
    }

    public static RabbitMQClient createClient(SysSjglSjzt sjzt) {
        try {
            return new RabbitMQClient(sjzt);
        }
        catch (Exception e) {
            throw new MyException("rabbitMQ\u5ba2\u6237\u7aef\u521b\u5efa\u5931\u8d25", e);
        }
    }

    public Object exec(SjztExecRunnable<RabbitMQClient> exec) {
        RabbitMQClient rabbitMQClient = null;
        try {
            rabbitMQClient = this.borrowClient();
            Object object = exec.exec(rabbitMQClient);
            return object;
        }
        catch (Exception e) {
            throw new MyException("rabbitmq\u6267\u884c\u5f02\u5e38", e);
        }
        finally {
            if (rabbitMQClient != null) {
                this.objectPool.returnObject((Object)rabbitMQClient);
            }
        }
    }

    public static RabbitMQ use(String name) {
        return RabbitMQ.use(name, RabbitMQ.getSjzt(name));
    }

    public static RabbitMQ use(String name, SysSjglSjzt sjzt) {
        RabbitMQ rabbitMQ = (RabbitMQ)cache.get((Object)name);
        if (rabbitMQ == null) {
            rabbitMQ = new RabbitMQ(name, sjzt);
        }
        return rabbitMQ;
    }

    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog log) {
        if (!this.queueVerification(znjhConfig.getSrml().replace("/", ""))) {
            throw new MyException("\u961f\u5217\u4e0d\u5b58\u5728,\u6216\u961f\u5217\u7531\u53e6\u4e00\u4e2a\u8fde\u63a5\u72ec\u5360");
        }
        this.exec(rabbitMQClient -> {
            Channel channel = rabbitMQClient.getChannel();
            MQConsumer consumer = new MQConsumer(channel, this, znjhConfig, log);
            channel.basicConsume(znjhConfig.getSrml().replace("/", ""), false, (Consumer)consumer);
            return null;
        });
    }

    public boolean queueVerification(String queueName) {
        return (Boolean)this.exec(rabbitMQClient -> {
            try {
                Channel channel = rabbitMQClient.getChannel();
                channel.queueDeclarePassive(queueName);
                return true;
            }
            catch (Exception e) {
                slog.info("{}\u961f\u5217\u4e0d\u5b58\u5728,\u6216\u961f\u5217\u7531\u53e6\u4e00\u4e2a\u8fde\u63a5\u72ec\u5360", (Object)queueName);
                return false;
            }
        });
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjh) throws Exception {
        String queueName = znjh.getSrml().replace("/", "");
        if (!this.queueVerification(queueName)) {
            throw new MyException("\u961f\u5217\u4e0d\u5b58\u5728,\u6216\u961f\u5217\u7531\u53e6\u4e00\u4e2a\u8fde\u63a5\u72ec\u5360");
        }
        return (List)this.exec(rabbitMQClient -> {
            ArrayList<RabbitMQFile> list = new ArrayList<RabbitMQFile>();
            Channel channel = rabbitMQClient.getChannel();
            long count = channel.messageCount(queueName);
            if (count > 0L) {
                for (long i = 0L; i < count; ++i) {
                    GetResponse response = channel.basicGet(queueName, false);
                    long deliveryTag = response.getEnvelope().getDeliveryTag();
                    list.add(new RabbitMQFile("/", this, UUID.randomUUID().toString(), response));
                    channel.basicAck(deliveryTag, false);
                }
            } else {
                slog.info("rabbitmq\u672a\u83b7\u53d6\u5230\u6d88\u606f");
            }
            return list;
        });
    }

    @Override
    public InputStream getInputStream(IFile iFile) throws Exception {
        if (iFile instanceof RabbitMQFile) {
            return new ByteArrayInputStream(((RabbitMQFile)iFile).getResponse().getBody());
        }
        throw new MyException("\u4e0d\u652f\u6301\u975erabbitmq");
    }

    @Override
    public boolean delete(IFile iFile) throws Exception {
        if (iFile instanceof RabbitMQFile) {
            return true;
        }
        throw new MyException("\u4e0d\u652f\u6301\u975eRabbitMQ");
    }

    public boolean deleteQueueData(String queue) {
        return (Boolean)this.exec(rabbitMQClient -> {
            int messageCount = rabbitMQClient.getChannel().queuePurge(queue).getMessageCount();
            if (messageCount > 0) {
                return true;
            }
            return false;
        });
    }

    public boolean createQueue(String queue) {
        return (Boolean)this.exec(rabbitMQClient -> {
            try {
                Channel channel = rabbitMQClient.getChannel();
                channel.queueDeclare(queue, true, false, false, null);
                return true;
            }
            catch (Exception e) {
                slog.info("\u521b\u5efa\u961f\u5217\u5f02\u5e38\uff1a", (Throwable)e);
                return false;
            }
        });
    }

    public boolean deleteQueue(String queue) throws Exception {
        return (Boolean)this.exec(rabbitMQClient -> {
            int messageCount = rabbitMQClient.getChannel().queueDelete(queue).getMessageCount();
            if (messageCount > 0) {
                return true;
            }
            return false;
        });
    }

    public boolean pub(String topic, String msg) throws Exception {
        return this.save(new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8)), new BdwjFile(topic, null));
    }

    @Override
    public boolean save(InputStream in, IFile iFile) throws Exception {
        return (Boolean)this.exec(rabbitMQClient -> {
            try {
                Channel channel = rabbitMQClient.getChannel();
                channel.queueDeclare(iFile.getParent().replace("/", ""), true, false, false, null);
                byte[] data = Utils.readByteArray((InputStream)in);
                channel.confirmSelect();
                channel.basicPublish("", iFile.getParent().replace("/", ""), null, data);
                boolean flag = channel.waitForConfirms();
                Boolean bl = flag;
                return bl;
            }
            catch (Exception e) {
                slog.info("\u6d88\u606f\u4fdd\u5b58\u9519\u8bef", (Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                FileUtil.closeStream(in);
            }
        });
    }

    @Override
    public String getRootPath() {
        return this.sjzt.getDxgs();
    }

    @Override
    public long getSize(IFile iFile) {
        if (iFile instanceof RabbitMQFile) {
            return ((RabbitMQFile)iFile).getResponse().getBody().length;
        }
        throw new SjztBzcwjdxExecption("\u4e0d\u652f\u6301\u975eRabbitMQFile");
    }

    @Override
    public void close() throws IOException {
        if (!this.objectPool.isClosed()) {
            this.objectPool.close();
        }
        cache.remove((Object)this.name);
        if (this == rabbitMQ) {
            rabbitMQ = null;
        }
    }
}

