/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.mqtt;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.InterfaceLog;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.myutils.FileUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.SjztBzcwjdxExecption;
import cn.benma666.sjzt.SjztExecRunnable;
import cn.benma666.sjzt.SjztPooledObjectFactory;
import cn.benma666.sjzt.mqtt.MqttCallBack;
import cn.benma666.sjzt.mqtt.MqttFile;
import cn.benma666.sjzt.mqtt.MqttQos;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class Mqtt
extends BasicSjzt {
    private static Mqtt mqtt = null;
    private final GenericObjectPool objectPool;

    protected Mqtt(String name, SysSjglSjzt sjzt) {
        super(name, sjzt);
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setTestOnCreate(true);
        conf.setTestOnBorrow(true);
        conf.setMinIdle(1);
        conf.setMaxIdle(2);
        conf.setMaxTotal(5);
        conf.setMaxWait(Duration.ofSeconds(300L));
        ClassUtil.plMethodInvoke(conf, this.getSjzt().getKzxxObj().getJSONObject("ljcpz"));
        this.objectPool = new GenericObjectPool((PooledObjectFactory)new SjztPooledObjectFactory(sjzt), conf);
        MqttClient client = null;
        try {
            client = this.borrowClient();
        }
        catch (Exception e) {
            throw new MyException(name + "\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            this.returnClient(client);
        }
        if (mqtt == null) {
            mqtt = this;
        }
        cache.put(name, (Object)this);
    }

    public void returnClient(MqttClient client) {
        this.log.trace("\u91ca\u653e\u56de\u8fde\u63a5\u6c60\uff1a{}", (Object)this.name);
        if (client != null) {
            this.objectPool.returnObject((Object)client);
        }
    }

    public MqttClient borrowClient() throws Exception {
        this.log.trace("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6\uff1a{}", (Object)this.name);
        return (MqttClient)this.objectPool.borrowObject();
    }

    public static Mqtt use(String name) {
        return Mqtt.use(name, Mqtt.getSjzt(name));
    }

    public static Mqtt use(String name, SysSjglSjzt sjzt) {
        Mqtt mqtt = (Mqtt)cache.get((Object)name);
        if (mqtt == null) {
            mqtt = new Mqtt(name, sjzt);
        }
        return mqtt;
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        try {
            Result r = Mqtt.success("\u6d4b\u8bd5\u6210\u529f");
            MqttClient client = Mqtt.createClient(sjzt);
            if (!Mqtt.validateClient(sjzt, client)) {
                r = Mqtt.failed("\u6d4b\u8bd5\u5931\u8d25");
            }
            Mqtt.destroyClient(sjzt, client);
            return r;
        }
        catch (Throwable t) {
            slog.debug("{}\u6d4b\u8bd5\u5931\u8d25", (Object)sjzt, (Object)t);
            return Mqtt.failed("\u8f7d\u4f53\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + t.getMessage());
        }
    }

    public static boolean validateClient(SysSjglSjzt sjzt, Object client) {
        try {
            return ((MqttClient)client).isConnected();
        }
        catch (Throwable t) {
            slog.debug("\u9a8c\u8bc1\u65e0\u6548\uff1a{}", (Object)sjzt.getMc(), (Object)t);
            return false;
        }
    }

    public static void destroyClient(SysSjglSjzt sjzt, Object client) throws Exception {
        MqttClient mqttClient = (MqttClient)client;
        mqttClient.disconnect();
        mqttClient.close();
    }

    public static MqttClient createClient(SysSjglSjzt sjzt) {
        try {
            MqttClient mqttClient = new MqttClient(sjzt.getLjc(), sjzt.getDm(), (MqttClientPersistence)new MemoryPersistence());
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(false);
            options.setUserName(sjzt.getYhm());
            options.setPassword(sjzt.getMm().toCharArray());
            options.setConnectionTimeout(100);
            options.setKeepAliveInterval(20);
            options.setWill("willTopic", (sjzt.getDm() + "\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5").getBytes(), 0, false);
            mqttClient.setCallback((MqttCallback)new MqttCallBack());
            JSONObject mttpz = sjzt.getKzxxObj().getJSONObject("mttpz");
            if (mttpz != null) {
                ClassUtil.plMethodInvoke(mqttClient, mttpz.getJSONObject("MqttClient"));
                ClassUtil.plMethodInvoke(options, mttpz.getJSONObject("MqttConnectOptions"));
            }
            mqttClient.connect(options);
            if (mqttClient.isConnected()) {
                return mqttClient;
            }
            throw new MyException("mqtt\u8fde\u63a5\u5931\u8d25\uff0c\u672a\u77e5\u5f02\u5e38");
        }
        catch (MqttException e) {
            throw new MyException("mqtt\u6570\u636e\u8f7d\u4f53\u521b\u5efa\u5931\u8d25\uff1a" + sjzt.getDm(), e);
        }
    }

    public Object exec(SjztExecRunnable<MqttClient> exec) {
        MqttClient client = null;
        try {
            client = this.borrowClient();
            Object object = exec.exec(client);
            return object;
        }
        catch (Exception e) {
            throw new MyException("\u6267\u884c\u5f02\u5e38", e);
        }
        finally {
            if (client != null) {
                this.objectPool.returnObject((Object)client);
            }
        }
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) throws Exception {
        throw new MyException("mqtt\u4e0d\u652f\u6301\u83b7\u53d6\u6587\u4ef6\u5217\u8868");
    }

    @Override
    public InputStream getInputStream(IFile file) throws Exception {
        if (file instanceof MqttFile) {
            return new ByteArrayInputStream(((MqttFile)file).getFile().getPayload());
        }
        throw new MyException("\u4e0d\u652f\u6301\u975emqttfile");
    }

    @Override
    public boolean delete(IFile file) throws Exception {
        if (file instanceof MqttFile) {
            return true;
        }
        throw new MyException("\u4e0d\u652f\u6301\u975eMqttfile");
    }

    public void subscribe(String topicFilter, IMqttMessageListener messageListener) {
        this.subscribe(topicFilter, MqttQos.ZHYC.getCode(), messageListener);
    }

    public void subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) {
        this.exec(client -> {
            client.subscribe(topicFilter, qos, messageListener);
            return null;
        });
    }

    public boolean pub(String topic, String msg) throws Exception {
        return this.pub(topic, msg, MqttQos.ZSYC);
    }

    public boolean pub(String topic, String msg, MqttQos qos) throws Exception {
        return this.save(new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8)), new MqttFile(topic, qos));
    }

    @Override
    public boolean save(InputStream is, IFile file) throws Exception {
        return (Boolean)this.exec(client -> {
            MqttQos qos = MqttQos.ZSYC;
            if (file instanceof MqttFile) {
                qos = ((MqttFile)file).getQos();
            }
            String topic = file.getParent();
            try {
                MqttMessage mqttMessage = new MqttMessage();
                mqttMessage.setQos(qos.getCode());
                mqttMessage.setPayload(Utils.readByteArray((InputStream)is));
                MqttTopic mqttTopic = client.getTopic(topic);
                MqttDeliveryToken token = mqttTopic.publish(mqttMessage);
                token.waitForCompletion();
                Boolean bl = true;
                return bl;
            }
            catch (Throwable t) {
                throw new MyException("\u6d88\u606f\u63a8\u9001\u5f02\u5e38\uff1a" + topic, t);
            }
            finally {
                FileUtil.closeStream(is);
            }
        });
    }

    @Override
    public String getRootPath() {
        return this.sjzt.getDxgs();
    }

    @Override
    public long getSize(IFile file) throws Exception {
        if (file instanceof MqttFile) {
            return ((MqttFile)file).getFile().getPayload().length;
        }
        throw new SjztBzcwjdxExecption("\u4e0d\u652f\u6301\u975emqttfile");
    }

    @Override
    public void sjztjt(SysSjglZnjh znjhConfig, InterfaceLog log) {
        this.exec(client -> {
            String topic = znjhConfig.getSrml();
            try {
                client.subscribe(topic, MqttQos.ZHYC.getCode(), (s, mqttMessage) -> {
                    MqttFile file = new MqttFile(topic, mqttMessage, this, s.replace("/", "_") + "_" + mqttMessage.getId() + ".json");
                    file.setGzml(topic);
                    znjhConfig.getTp().run(() -> this.znjh.znjh(znjhConfig, log, file));
                });
                while (client.isConnected()) {
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException e) {
                log.info("\u9000\u51fa\u904d\u5386\u76d1\u542c\uff1a{}", znjhConfig.getJhmc());
                client.unsubscribe(topic);
            }
            catch (Throwable e) {
                log.error("\u904d\u5386\u76d1\u542c\u5f02\u5e38\uff1a" + znjhConfig.getJhmc() + "\uff0c" + e.getMessage(), e);
                client.unsubscribe(topic);
            }
            jtqMap.remove(znjhConfig.getId());
            return null;
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.objectPool.isClosed()) {
            this.objectPool.close();
        }
        cache.remove((Object)this.name);
        if (this == mqtt) {
            mqtt = null;
        }
    }
}

