/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.kafka;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.MyException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;

public class KafkaClient {
    private AdminClient adminClient;
    private KafkaProducer kafkaProducer;
    private KafkaConsumer kafkaConsumer;

    public KafkaClient(SysSjglSjzt sjzt) {
        this.adminClient = KafkaClient.createAdminClient(sjzt);
        this.kafkaProducer = KafkaClient.createProducer(sjzt);
        this.kafkaConsumer = KafkaClient.createConsumer(sjzt);
    }

    public void close() {
        this.adminClient.close();
        this.kafkaProducer.close();
        this.kafkaConsumer.close();
    }

    public static AdminClient createAdminClient(SysSjglSjzt sjzt) {
        Properties conf = new Properties();
        String servers = sjzt.getLjc();
        conf.setProperty("sasl.mechanism", "PLAIN");
        conf.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required\n username=\"" + sjzt.getYhm() + "\"\n password=\"" + sjzt.getMm() + "\";");
        conf.setProperty("security.protocol", "SASL_PLAINTEXT");
        conf.setProperty("bootstrap.servers", servers);
        if (sjzt.getKzxxObj().containsKey((Object)"adminConfig")) {
            conf.putAll((Map<?, ?>)sjzt.getKzxxObj().getJSONObject("adminConfig"));
        }
        return AdminClient.create((Properties)conf);
    }

    public static KafkaProducer<String, String> createProducer(SysSjglSjzt sjzt) {
        Properties conf = new Properties();
        String servers = sjzt.getLjc();
        if (servers == null) {
            throw new MyException("kafka servers \u4e3a\u7a7a,\u6784\u9020\u914d\u7f6e\u5bf9\u8c61\u5931\u8d25");
        }
        conf.put("bootstrap.servers", servers);
        conf.setProperty("sasl.mechanism", "PLAIN");
        conf.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required\n username=\"" + sjzt.getYhm() + "\"\n password=\"" + sjzt.getMm() + "\";");
        conf.setProperty("security.protocol", "SASL_PLAINTEXT");
        conf.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        conf.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        if (sjzt.getKzxxObj().containsKey((Object)"producerConfig")) {
            conf.putAll((Map<?, ?>)sjzt.getKzxxObj().getJSONObject("producerConfig"));
        }
        return new KafkaProducer(conf);
    }

    public static KafkaConsumer<String, String> createConsumer(SysSjglSjzt sjzt) {
        String servers = sjzt.getLjc();
        if (servers == null) {
            throw new MyException("kafka servers \u4e3a\u7a7a,\u6784\u9020\u914d\u7f6e\u5bf9\u8c61\u5931\u8d25");
        }
        Properties conf = new Properties();
        conf.setProperty("bootstrap.servers", servers);
        conf.setProperty("sasl.mechanism", "PLAIN");
        conf.setProperty("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required\n username=\"" + sjzt.getYhm() + "\"\n password=\"" + sjzt.getMm() + "\";");
        conf.setProperty("security.protocol", "SASL_PLAINTEXT");
        conf.setProperty("group.id", sjzt.getDxgs());
        conf.setProperty("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        conf.setProperty("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        if (sjzt.getKzxxObj().containsKey((Object)"consumerConfig")) {
            conf.putAll((Map<?, ?>)sjzt.getKzxxObj().getJSONObject("consumerConfig"));
        }
        return new KafkaConsumer(conf);
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public KafkaConsumer getKafkaConsumer() {
        return this.kafkaConsumer;
    }

    public void setAdminClient(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public void setKafkaProducer(KafkaProducer kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public void setKafkaConsumer(KafkaConsumer kafkaConsumer) {
        this.kafkaConsumer = kafkaConsumer;
    }
}

