/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt.bdwj;

import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Result;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.DbFile;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.bdwj.BdwjFile;
import com.alibaba.druid.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationMonitor;

public class Bdwj
extends BasicSjzt {
    private static Bdwj bdwj;
    private final File pathFile;
    private Map<String, FileAlterationMonitor> monitorMap = new HashMap<String, FileAlterationMonitor>();

    public Bdwj(String name, SysSjglSjzt sjzt) {
        this(name, new File(sjzt.getLjc()));
    }

    public Bdwj(String name, File pathFile) {
        super(name);
        this.pathFile = pathFile;
        if (bdwj == null) {
            bdwj = this;
        }
        if (!pathFile.exists() && !pathFile.mkdirs()) {
            throw new MyException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff1a" + pathFile);
        }
        cache.put(name, (Object)this);
    }

    public static synchronized Bdwj use(String name) {
        Bdwj bdwj = (Bdwj)cache.get((Object)name);
        if (bdwj == null) {
            bdwj = new Bdwj(name, Bdwj.getSjzt(name));
        }
        return bdwj;
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        return new Result(new File(sjzt.getLjc()).exists());
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) throws Exception {
        return this.listFiles(new File(FileUtil.getFilePath(this.pathFile.getAbsolutePath(), znjhConfig.getSrml())), znjhConfig);
    }

    public List<IFile> listFiles(File fileInput, SysSjglZnjh znjhConfig) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        this.log.trace("\u5f00\u59cb\u904d\u5386\u76ee\u5f55\uff1a{}", (Object)fileInput.getAbsolutePath());
        if (!fileInput.exists()) {
            this.log.error("\u6587\u4ef6\u4e0d\u5b58\u5728{}", (Object)fileInput.getAbsolutePath());
            return list;
        }
        File[] fileList = fileInput.listFiles();
        assert (fileList != null);
        for (File file : fileList) {
            this.log.trace("\u904d\u5386\u5230\u6587\u4ef6\uff1a{}", (Object)file.getName());
            if (file.isDirectory()) {
                if (znjhConfig.isBlbhml() && !this.sftg(znjhConfig, file.lastModified(), file.getName())) {
                    list.add(new BdwjFile(fileInput.getAbsolutePath().replace(this.pathFile.getAbsolutePath(), "/"), file, (BasicSjzt)this));
                }
                if (!znjhConfig.isDgbl()) continue;
                list.addAll(this.listFiles(file, znjhConfig));
                continue;
            }
            if (this.sftg(znjhConfig, file.lastModified(), file.getName())) continue;
            list.add(new BdwjFile(fileInput.getAbsolutePath().replace(this.pathFile.getAbsolutePath(), "/"), file, (BasicSjzt)this));
        }
        return list;
    }

    @Override
    public InputStream getInputStream(IFile file) throws Exception {
        return new FileInputStream(this.getAbsolutePath(file));
    }

    @Override
    public boolean delete(IFile file) throws Exception {
        return new File(this.getAbsolutePath(file)).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(InputStream is, IFile file) throws Exception {
        boolean bl;
        FileOutputStream out = null;
        try {
            File f = new File(this.getAbsolutePath(file) + ".unimastmp");
            Bdwj bdwj = this;
            synchronized (bdwj) {
                if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                    throw new MyException("\u7236\u8def\u5f84\u521b\u5efa\u5931\u8d25\uff1a" + f.getParent());
                }
            }
            out = new FileOutputStream(f);
            boolean r = Utils.copy((InputStream)is, (OutputStream)out) > 0L;
            FileUtil.closeStream(out);
            if (!f.renameTo(new File(this.getAbsolutePath(file)))) {
                throw new MyException("\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25\uff1a" + f.getAbsolutePath());
            }
            bl = r;
        }
        catch (Throwable throwable) {
            FileUtil.closeStream(is);
            FileUtil.closeStream(out);
            throw throwable;
        }
        FileUtil.closeStream(is);
        FileUtil.closeStream(out);
        return bl;
    }

    @Override
    public String getRootPath() {
        return FileUtil.getFilePath(this.pathFile.getAbsolutePath());
    }

    @Override
    public long getSize(IFile file) throws Exception {
        File f = new File(this.getAbsolutePath(file));
        if (!f.exists()) {
            throw new MyException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + f.getAbsolutePath());
        }
        return f.length();
    }

    public static IFile getIfile(BasicSjzt sjzt, File file) {
        return new BdwjFile(FileUtil.getFilePath(file.getParent()).replace(sjzt.getRootPath(), ""), file, sjzt);
    }

    @Override
    public void close() throws IOException {
        this.log.info("{}\u8f7d\u4f53\u5173\u95ed", (Object)this.getName());
    }

    @Override
    public String getUrl(IFile ifile) {
        if (ifile instanceof DbFile) {
            String sclj = ((DbFile)ifile).getFile().getSclj();
            if (StringUtil.isBlank((String)sclj)) {
                sclj = this.getAbsolutePath(ifile);
            }
            return "/" + this.name + "/" + sclj.substring(sclj.indexOf(((DbFile)ifile).getFile().getParent()));
        }
        return super.getUrl(ifile);
    }

    @Override
    public boolean zcUrl(IFile iFile) {
        return true;
    }

    public void setMonitorMap(Map<String, FileAlterationMonitor> monitorMap) {
        this.monitorMap = monitorMap;
    }

    public File getPathFile() {
        return this.pathFile;
    }

    public Map<String, FileAlterationMonitor> getMonitorMap() {
        return this.monitorMap;
    }
}

