/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.sjzt;

import cn.benma666.crypt.DesUtil;
import cn.benma666.domain.SysQxYhxx;
import cn.benma666.domain.SysSjglBlob;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.domain.SysSjglZnjh;
import cn.benma666.exception.MyException;
import cn.benma666.exception.SuccessException;
import cn.benma666.iframe.Conf;
import cn.benma666.iframe.MyParams;
import cn.benma666.iframe.PageInfo;
import cn.benma666.iframe.Result;
import cn.benma666.json.JsonUtil;
import cn.benma666.myutils.ClassUtil;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.StringUtil;
import cn.benma666.myutils.TmplUtil;
import cn.benma666.sjzt.BasicSjzt;
import cn.benma666.sjzt.DbFile;
import cn.benma666.sjzt.IFile;
import cn.benma666.sjzt.MyLambdaQuery;
import cn.benma666.sjzt.MyNameConversion;
import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.DamengStyle;
import org.beetl.sql.core.db.DerbyStyle;
import org.beetl.sql.core.db.GreenplumDBStyle;
import org.beetl.sql.core.db.H2Style;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.db.OpenGaussStyle;
import org.beetl.sql.core.db.OracleStyle;
import org.beetl.sql.core.db.PolarDBStyle;
import org.beetl.sql.core.db.PostgresStyle;
import org.beetl.sql.core.db.SQLiteStyle;
import org.beetl.sql.core.db.SqlServerStyle;
import org.beetl.sql.core.db.VerticaDBStyle;
import org.beetl.sql.core.nosql.HBaseStyle;
import org.beetl.sql.core.nosql.HiveStyle;
import org.beetl.sql.core.query.LambdaQuery;

public class Db
extends BasicSjzt {
    public static Map<DbType, Class<?>> dbStyleMap = new HashMap();
    public static NameConversion defaultNameConversion = new MyNameConversion();
    private static Db db = null;
    private DbType dbType;
    private DataSource dataSource;
    private SQLManager sqlManager;

    public Db() {
        super(null);
    }

    private Db(String name, String url, String user, String pwd) {
        this(name, Db.createDruidDataSource(url, user, pwd));
    }

    private Db(String name, DruidDataSource dataSource) {
        this(name, (DataSource)dataSource, JdbcUtils.getDbType((String)dataSource.getUrl(), null));
    }

    private Db(String name, DataSource dataSource, String dbType) {
        super(name);
        if (!Db.isSupported(dbType)) {
            throw new MyException("\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u6682\u65f6\u4e0d\u652f\u6301\uff1a" + dbType);
        }
        this.dbType = DbType.of((String)dbType);
        this.dataSource = dataSource;
        SQLManagerBuilder builder = new SQLManagerBuilder(ConnectionSourceHelper.getSingle((DataSource)dataSource));
        builder.setName(name);
        try {
            builder.setDbStyle((DBStyle)dbStyleMap.get(this.dbType).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new MyException("\u6570\u636e\u5e93\u65b9\u8a00\u5b9e\u4f8b\u5316\u5931\u8d25", e);
        }
        builder.setNc(defaultNameConversion);
        builder.setProduct(!Conf.getUtilConfig().isDebug());
        builder.addIdAutoGen("idGenerator", params -> StringUtil.getUUIDUpperStr());
        this.sqlManager = builder.build();
        if (db == null) {
            db = this;
        }
        cache.put(name, (Object)this);
    }

    public static boolean isSupported(String dbType) {
        return DbType.of((String)dbType) != null && dbStyleMap.containsKey(DbType.of((String)dbType));
    }

    public static Db use() throws MyException {
        if (db == null) {
            throw new MyException("\u9ed8\u8ba4\u6570\u636e\u6e90\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u521d\u59cb\u5316\u540e\u5728\u4f7f\u7528");
        }
        return db;
    }

    public static SQLManager useSqlManager() throws MyException {
        return Db.use().getSqlManager();
    }

    public static Db use(String name) {
        if ("default".equals(name)) {
            return Db.use();
        }
        Object db = cache.get((Object)name);
        if (db != null) {
            return (Db)db;
        }
        return Db.use(name, Db.getSjzt(name));
    }

    public static synchronized Db use(String name, SysSjglSjzt sjzt) {
        Object db = cache.get((Object)name);
        if (db != null) {
            return (Db)db;
        }
        Result r = Db.testDb(sjzt, false);
        if (!r.isStatus()) {
            throw new MyException(name + r.getMsg());
        }
        DruidDataSource ds = Db.createDruidDataSource(sjzt.getLjc(), sjzt.getYhm(), sjzt.getMm(), sjzt.getSjkqd(), sjzt.getCsyj(), sjzt.getLx());
        ds.setName(name);
        Db.configDataSource(sjzt, ds, "druid");
        if (StringUtil.isNotBlank((String)Conf.getAppdm())) {
            Db.configDataSource(sjzt, ds, "druid." + Conf.getAppdm());
        }
        return Db.use(name, (DataSource)ds, sjzt.getLx());
    }

    public static Db use(String name, DruidDataSource ds) {
        return Db.use(name, (DataSource)ds, JdbcUtils.getDbType((String)ds.getUrl(), null));
    }

    public static synchronized Db use(String name, DataSource ds, String lx) {
        Object db = cache.get((Object)name);
        if (db != null) {
            return (Db)db;
        }
        return new Db(name, ds, lx);
    }

    public static Result cszt(SysSjglSjzt sjzt) {
        return Db.testDb(sjzt, false);
    }

    @Override
    public List<IFile> listFiles(SysSjglZnjh znjhConfig) throws Exception {
        throw new MyException("\u6570\u636e\u5e93\u6682\u4e0d\u652f\u6301\u904d\u5386");
    }

    @Override
    public InputStream getInputStream(IFile file) throws Exception {
        if (file instanceof DbFile) {
            DbFile dbfile = (DbFile)file;
            LambdaQuery query = this.getSqlManager().lambdaQuery(SysSjglBlob.class);
            SysSjglBlob blob = (SysSjglBlob)query.andEq(SysSjglBlob::getId, (Object)dbfile.getFile().getId()).singleSimple();
            if (blob == null) {
                throw new MyException("\u8be5\u6587\u4ef6\u6ca1\u627e\u5230\uff1a" + file.getParent());
            }
            return new ByteArrayInputStream(blob.getNr());
        }
        throw new MyException("\u4e0d\u652f\u6301\u975eDbFile");
    }

    @Override
    public boolean delete(IFile file) throws Exception {
        if (file instanceof DbFile) {
            DbFile dbfile = (DbFile)file;
            if (StringUtil.isBlank((String)dbfile.getFile().getId())) {
                throw new MyException("\u6ca1\u6709\u8bbe\u7f6e\u6587\u4ef6\u4e3b\u952e\uff0c\u65e0\u6cd5\u5220\u9664\u6587\u4ef6");
            }
            return this.sqlManager().deleteById(SysSjglBlob.class, (Object)dbfile.getFile().getId()) > 0;
        }
        throw new MyException("\u4e0d\u652f\u6301\u975eDbFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(InputStream is, IFile file) throws Exception {
        if (file instanceof DbFile) {
            try {
                DbFile dbfile = (DbFile)file;
                SysSjglBlob blob = SysSjglBlob.builder().nr(Utils.readByteArray((InputStream)is)).id(dbfile.getFile().getId()).build();
                boolean bl = this.sqlManager().insertTemplate((Object)blob) > 0;
                return bl;
            }
            finally {
                FileUtil.closeStream(is);
            }
        }
        throw new MyException("\u4e0d\u652f\u6301\u975eDbFile");
    }

    @Override
    public String getRootPath() {
        return "/";
    }

    @Override
    public long getSize(IFile file) throws Exception {
        return Utils.readByteArray((InputStream)this.getInputStream(file)).length;
    }

    public static SQLManager useSqlManager(String name) {
        return Db.use(name).getSqlManager();
    }

    public static void configDataSource(SysSjglSjzt sjzt, DruidDataSource druidDataSource, String druidKey) {
        String dcObj = sjzt.getKzxxObj().getString("$." + druidKey);
        if (dcObj != null) {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)JSON.parseObject((String)dcObj.toString()));
            druidDataSource.configFromPropety(p);
        }
    }

    public static Result testDb(SysSjglSjzt yobj, boolean mmjm) {
        if (yobj == null) {
            return Result.failed("\u6570\u636e\u8f7d\u4f53\u4e3a\u7a7a");
        }
        String mm = yobj.getMm();
        if (mmjm && StringUtil.isNotBlank((String)Db.getSjztEjmm())) {
            try {
                mm = DesUtil.decrypt(mm, Db.getSjztEjmm());
            }
            catch (Exception e) {
                return Result.failed("\u6570\u636e\u8f7d\u4f53\u5bc6\u7801\u89e3\u6790\u9519\u8bef" + yobj, e);
            }
        }
        try {
            SQLManager sm;
            if (StringUtil.isBlank((String)yobj.getSjkqd())) {
                try {
                    yobj.setSjkqd(JdbcUtils.getDriverClassName((String)yobj.getLjc()));
                }
                catch (SQLException e) {
                    slog.debug(yobj + "\u9a71\u52a8\u83b7\u53d6\u5931\u8d25", (Throwable)e);
                    return Result.failed("\u9a71\u52a8\u83b7\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
                }
            }
            try {
                sm = SQLManager.newBuilder((String)yobj.getSjkqd(), (String)yobj.getLjc(), (String)yobj.getYhm(), (String)mm).setDbStyle((DBStyle)dbStyleMap.get(DbType.of((String)yobj.getLx())).newInstance()).build();
            }
            catch (Exception e) {
                throw new MyException("\u6784\u5efaSQL\u6267\u884c\u5668\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            if (StringUtil.isBlank((String)yobj.getCsyj())) {
                yobj.setCsyj(sm.getSQLResult((SqlId)SqlId.of((String)"util", (String)"getDate14"), null).jdbcSql);
            }
            sm.execute(new SQLReady(yobj.getCsyj()), JSONObject.class);
            return Result.success("\u6d4b\u8bd5\u6210\u529f");
        }
        catch (Exception e) {
            slog.debug(yobj.toString(), (Throwable)e);
            return Result.failed("\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + e.getMessage(), e);
        }
    }

    public static boolean isCz(String dbCode) {
        return cache.containsKey((Object)dbCode);
    }

    public static int update(Db db, String sql, Object ... params) {
        return db.update(sql, params);
    }

    public static int update(Db db, String sqlTemplate, Map<String, Object> params) {
        return db.update(sqlTemplate, params);
    }

    public static List<JSONObject> find(Db db, String sql, Object ... params) {
        return db.find(sql, params);
    }

    public static List<JSONObject> find(Db db, String sqlTemplate, Map<String, Object> params) {
        return db.find(sqlTemplate, params);
    }

    public static JSONObject findFirst(Db db, String sql, Object ... params) {
        return db.findFirst(sql, params);
    }

    public static JSONObject findFirst(Db db, String sqlTemplate, Map<String, Object> params) {
        return db.findFirst(sqlTemplate, params);
    }

    public static Map<String, JSONObject> findMap(Db db, String keyName, String sql, Object ... params) {
        return db.findMap(keyName, sql, params);
    }

    public static Map<String, JSONObject> findMap(Db db, String keyName, String sqlTemplate, Map<String, Object> params) {
        return db.findMap(keyName, sqlTemplate, params);
    }

    public static String queryStr(Db db, String sql, Object ... params) {
        return db.queryStr(sql, params);
    }

    public static String queryStr(Db db, String sqlTemplate, Map<String, Object> params) {
        return db.queryStr(sqlTemplate, params);
    }

    public static int queryInt(Db db, String sql, Object ... params) {
        return db.queryInt(sql, params);
    }

    public static int queryInt(Db db, String sqlTemplate, Map<String, Object> params) {
        return db.queryInt(sqlTemplate, params);
    }

    public static <T> Map<String, T> listToMap(List<T> list, String keyName) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        for (T jo : list) {
            Object o = null;
            if (jo instanceof Map) {
                o = ((Map)jo).get(keyName);
            }
            if ((o = ClassUtil.getVal(keyName, o, jo)) == null) continue;
            result.put(o.toString(), jo);
        }
        return result;
    }

    public static JSONObject buildMap(Object ... params) {
        JSONObject ps = new JSONObject();
        for (int i = 0; i < params.length; ++i) {
            ps.put("p" + (i + 1), params[i]);
        }
        return ps;
    }

    public static JSONObject buildKeyMap(Object ... params) {
        JSONObject ps = new JSONObject();
        for (int i = 0; i < params.length; i += 2) {
            ps.set(params[i].toString(), params[i + 1]);
        }
        return ps;
    }

    public static String[] parseDictExp(String sql) {
        return Db.parseDictExp(sql, null);
    }

    public static String[] parseDictExp(String sql, String defaultSjzt) {
        if (StringUtil.isBlank((String)sql)) {
            return null;
        }
        String[] result = new String[2];
        String[] strs = sql.split(";");
        if (strs.length > 1 && strs[strs.length - 1].startsWith("ds=")) {
            result[0] = strs[strs.length - 1].substring(3).trim();
            result[1] = sql.substring(0, sql.lastIndexOf(";"));
        } else {
            result[0] = StringUtil.isNotBlank((String)defaultSjzt) ? defaultSjzt : "default";
        }
        if (Db.isBlank(result[1])) {
            result[1] = sql;
        }
        return result;
    }

    public static String getZdSqlTmpl(MyParams myParams, String sqlKey, String sjztlx) {
        String key = sqlKey + "." + sjztlx;
        String sqlTmpl = Conf.getVal(key);
        if (StringUtil.isBlank((String)sqlTmpl)) {
            key = sqlKey;
            sqlTmpl = Conf.getVal(key);
        }
        if (StringUtil.isNotBlank((String)sqlTmpl)) {
            try {
                String sql = TmplUtil.buildStrSql(sqlTmpl, (Map<String, Object>)((Object)myParams)).trim();
                if (sql.startsWith("error:")) {
                    throw new MyException(sql.substring("error:".length()));
                }
                if (sql.startsWith("success:")) {
                    throw new SuccessException(sql.substring("success:".length()));
                }
                if (sql.startsWith("json:")) {
                    throw new SuccessException("\u8bf7\u6c42\u6210\u529f", JSON.parseObject((String)sql.substring("json:".length())));
                }
                if (sql.startsWith("result:")) {
                    throw Result.parse((Map<String, Object>)JSON.parseObject((String)sql.substring("result:".length()))).newMyException();
                }
                myParams.sql().setDefaultSql(sql);
                return sql;
            }
            catch (MyException e) {
                throw e;
            }
            catch (Exception e) {
                slog.error("\u6a21\u677f\u6e32\u67d3\u5931\u8d25", (Throwable)e);
                throw new MyException(e.getMessage(), e);
            }
        }
        return myParams.sql().getDefaultSql();
    }

    public static DruidDataSource createDruidDataSource(String url, String user, String pwd) {
        return Db.createDruidDataSource(url, user, pwd, null, null, null);
    }

    public static DruidDataSource createDruidDataSource(String url, String user, String pwd, String driverClassName, String validationQuery, String lx) {
        try {
            boolean isDebug = Conf.getUtilConfig().isDebug();
            DruidDataSource ds = new DruidDataSource();
            ds.setInitialSize(TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.initial-size", "2")).intValue());
            ds.setMinIdle(TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.min-idle", "2")).intValue());
            ds.setMaxActive(TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.max-active", "150")).intValue());
            ds.setMaxWait((long)TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.max-wait", "600000")).intValue());
            ds.setTestOnBorrow(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.test-on-borrow"), false)).booleanValue());
            ds.setTestWhileIdle(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.test-while-idle"), true)).booleanValue());
            ds.setSocketTimeout(TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.socket-timeout", "600000")).intValue());
            ds.setTestOnReturn(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.test-on-return"), false)).booleanValue());
            ds.setTimeBetweenEvictionRunsMillis((long)TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.time-between-eviction-runs-millis", "300000")).intValue());
            ds.setMinEvictableIdleTimeMillis((long)TypeUtils.castToInt((Object)Conf.getVal("min-evictable-idle-time-millis", "300000")).intValue());
            ds.setMaxEvictableIdleTimeMillis((long)TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.max-evictable-idle-time-millis", "900000")).intValue());
            ds.setKeepAlive(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.keep-alive"), true)).booleanValue());
            ds.setKeepAliveBetweenTimeMillis((long)TypeUtils.castToInt((Object)Conf.getVal("spring.datasource.druid.keep-alive-between-time-millis", "600000")).intValue());
            if (StringUtil.isNotBlank((String)lx)) {
                ds.setDbType(DbType.of((String)lx));
            }
            ds.setUrl(url);
            ds.setUsername(user);
            ds.setPassword(pwd);
            ds.setValidationQuery(validationQuery);
            ds.setDriverClassName(driverClassName);
            ArrayList<Object> filters = new ArrayList<Object>();
            StatFilter stat = new StatFilter();
            stat.setLogSlowSql(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.stat.log-slow-sql"), true)).booleanValue());
            stat.setSlowSqlMillis((long)TypeUtils.castToInt((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slow-sql-millis"), "30000")).intValue());
            stat.setMergeSql(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.stat.merge-sql"), true)).booleanValue());
            filters.add(stat);
            Slf4jLogFilter slf4j = new Slf4jLogFilter();
            slf4j.setStatementExecutableSqlLogEnable(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-executable-sql-log-enable"), isDebug)).booleanValue());
            slf4j.setStatementCreateAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-create-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementPrepareAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-prepare-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementParameterSetLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-parameter-set-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementExecuteAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-execute-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementCloseAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-close-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementExecuteBatchAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-execute-batch-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementExecuteQueryAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-execute-query-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementExecuteUpdateAfterLogEnabled(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-execute-update-after-log-enabled"), isDebug)).booleanValue());
            slf4j.setStatementParameterClearLogEnable(TypeUtils.castToBoolean((Object)Db.valByDef(Conf.getValByConfig("spring.datasource.druid.filter.slf4j.statement-parameter-clear-log-enable"), isDebug)).booleanValue());
            filters.add(slf4j);
            ds.setProxyFilters(filters);
            if (db != null) {
                ds.setConnectProperties(Conf.getPropertiesByDict());
            }
            return ds;
        }
        catch (Exception e) {
            throw new MyException("\u521b\u5efa\u6570\u636e\u6e90\u5931\u8d25", e);
        }
    }

    public static String getDbtypeByDatasource(DataSource dataSource) {
        String dbType = null;
        if (dataSource instanceof DruidDataSource) {
            dbType = ((DruidDataSource)dataSource).getDbType();
        }
        return dbType;
    }

    public static NameConversion getDefaultNameConversion() {
        return defaultNameConversion;
    }

    public static void setDefaultNameConversion(NameConversion defaultNameConversion) {
        Db.defaultNameConversion = defaultNameConversion;
    }

    @Override
    public void close() {
        if (this.dataSource instanceof DruidDataSource) {
            ((DruidDataSource)this.dataSource).close();
        }
        cache.remove((Object)this.getName());
        if (db == this) {
            db = null;
        }
    }

    public String getDate14() {
        return this.queryStr(SqlId.of((String)"util", (String)"getDate14"), (Map<String, Object>)Db.buildMap(new Object[0]));
    }

    public String getSourceSql(SqlId sqlId, Map<String, Object> params) {
        if (Conf.getUtilConfig().isDebug()) {
            this.sqlManager.getSqlTemplateEngine().getSqlTemplate(sqlId);
        }
        return TmplUtil.buildStrSql(this.sqlManager.getScript((SqlId)sqlId).getExecuteContext().sqlSource.getTemplate(), params);
    }

    public int update(String sql, Object ... params) {
        return this.sqlManager.executeUpdate(new SQLReady(sql, params));
    }

    public int update(String sqlTemplate, Map<String, Object> params) {
        return this.sqlManager.executeUpdate(sqlTemplate, params);
    }

    public int update(SqlId sqlId, Map<String, Object> params) {
        return this.update(this.getSourceSql(sqlId, params), params);
    }

    public List<JSONObject> find(String sql, Object ... params) {
        return this.sqlManager.execute(new SQLReady(sql, params), JSONObject.class);
    }

    public List<JSONObject> find(String sqlTemplate, Map<String, Object> params) {
        return this.sqlManager.execute(sqlTemplate, JSONObject.class, params);
    }

    public List<JSONObject> find(SqlId sqlId, Map<String, Object> params) {
        return this.find(this.getSourceSql(sqlId, params), params);
    }

    public JSONObject findFirst(String sql, Object ... params) {
        List<JSONObject> list = this.find(sql, params);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public JSONObject findFirst(String sqlTemplate, Map<String, Object> params) {
        List<JSONObject> list = this.find(sqlTemplate, params);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public JSONObject findFirst(SqlId sqlId, Map<String, Object> params) {
        List<JSONObject> list = this.find(sqlId, params);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Map<String, JSONObject> findMap(String keyName, String sql, Object ... params) {
        List<JSONObject> list = this.find(sql, params);
        return Db.listToMap(list, keyName);
    }

    public Map<String, JSONObject> findMap(String keyName, String sqlTemplate, Map<String, Object> params) {
        List<JSONObject> list = this.find(sqlTemplate, params);
        return Db.listToMap(list, keyName);
    }

    public Map<String, JSONObject> findMap(String keyName, SqlId sqlId, Map<String, Object> params) {
        List<JSONObject> list = this.find(sqlId, params);
        return Db.listToMap(list, keyName);
    }

    public String queryStr(String sql, Object ... params) {
        JSONObject obj = this.findFirst(sql, params);
        if (obj != null && obj.size() > 0) {
            return obj.values().toArray()[0] + "";
        }
        return null;
    }

    public String queryStr(String sqlTemplate, Map<String, Object> params) {
        JSONObject obj = this.findFirst(sqlTemplate, params);
        if (obj != null && obj.size() > 0) {
            return obj.values().toArray()[0] + "";
        }
        return null;
    }

    public String queryStr(SqlId sqlId, Map<String, Object> params) {
        JSONObject obj = this.findFirst(sqlId, params);
        if (obj != null && obj.size() > 0) {
            return obj.values().toArray()[0] + "";
        }
        return null;
    }

    public int queryInt(String sql, Object ... params) {
        Integer integer = TypeUtils.castToInt((Object)this.queryStr(sql, params));
        if (Db.isBlank(integer)) {
            return 0;
        }
        return integer;
    }

    public int queryInt(String sqlTemplate, Map<String, Object> params) {
        Integer integer = TypeUtils.castToInt((Object)this.queryStr(sqlTemplate, params));
        if (Db.isBlank(integer)) {
            return 0;
        }
        return integer;
    }

    public int queryInt(SqlId sqlId, Map<String, Object> params) {
        Integer integer = TypeUtils.castToInt((Object)this.queryStr(sqlId, params));
        if (Db.isBlank(integer)) {
            return 0;
        }
        return integer;
    }

    public PageInfo<JSONObject> queryPage(PageInfo<JSONObject> page, String sqlTemplate, Map<String, Object> params) {
        params = JsonUtil.clone(params);
        return (PageInfo)this.sqlManager.executePageQuery(sqlTemplate, JSONObject.class, params, page);
    }

    public PageInfo<JSONObject> queryPage(PageInfo<JSONObject> page, SqlId sqlId, Map<String, Object> params) {
        return this.queryPage(page, this.getSourceSql(sqlId, params), params);
    }

    public <T> MyLambdaQuery<T> lambdaQuery(Class<T> clazz) {
        return this.lambdaQuery(clazz, null);
    }

    public <T> MyLambdaQuery<T> lambdaQuery(Class<T> clazz, SysQxYhxx user) {
        if (BeanKit.queryLambdasSupport) {
            MyLambdaQuery q = new MyLambdaQuery(this.sqlManager, clazz);
            q.setUser(user);
            return q;
        }
        throw new UnsupportedOperationException("\u9700\u8981Java8\u4ee5\u4e0a");
    }

    @Override
    public String getName() {
        return this.sqlManager.getName();
    }

    public static boolean isDefaultInit() {
        return db != null;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSqlManager(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    static {
        dbStyleMap.put(DbType.h2, H2Style.class);
        dbStyleMap.put(DbType.mysql, MySqlStyle.class);
        dbStyleMap.put(DbType.oracle, OracleStyle.class);
        dbStyleMap.put(DbType.postgresql, PostgresStyle.class);
        dbStyleMap.put(DbType.gaussdb, OpenGaussStyle.class);
        dbStyleMap.put(DbType.greenplum, GreenplumDBStyle.class);
        dbStyleMap.put(DbType.polardb, PolarDBStyle.class);
        dbStyleMap.put(DbType.sqlserver, SqlServerStyle.class);
        dbStyleMap.put(DbType.sqlite, SQLiteStyle.class);
        dbStyleMap.put(DbType.dm, DamengStyle.class);
        dbStyleMap.put(DbType.derby, DerbyStyle.class);
        dbStyleMap.put(DbType.hive, HiveStyle.class);
        dbStyleMap.put(DbType.hbase, HBaseStyle.class);
        dbStyleMap.put(DbType.vertica, VerticaDBStyle.class);
    }
}

