/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.crypt.DesUtil;
import cn.benma666.crypt.MD5Util;
import cn.benma666.dict.Jmfs;
import cn.benma666.dict.Ljpd;
import cn.benma666.domain.SysSjglSjzd;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.myutils.ByteUtil;
import cn.benma666.myutils.DateUtil;
import cn.benma666.sm.FMSM1;
import cn.benma666.sm.FMSM4;
import cn.benma666.sm.SM3;
import cn.benma666.sm.SM4;
import cn.benma666.sm.sm2.SM2EncDecUtils;
import cn.hutool.log.LogFactory;
import com.alibaba.druid.util.Utils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.beetl.ext.fn.EmptyExpressionFunction;

public class StringUtil
extends StringUtils {
    public static final String KEY_CHILDREN = "children";
    public static final EmptyExpressionFunction isEmpty = new EmptyExpressionFunction();

    public static String getUUIDUpperStr() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    public static boolean isBlank(Object obj) {
        return isEmpty.call(new Object[]{obj}, null) != false || StringUtil.isBlank((String)obj.toString());
    }

    public static <T> T requireNonNull(T obj, String msg) {
        if (StringUtil.isBlank(obj)) {
            throw new BusinessException(msg);
        }
        return obj;
    }

    public static boolean isNotBlank(Object obj) {
        return !StringUtil.isBlank(obj);
    }

    public static <T> T valByDef(T val, T def) {
        if (StringUtil.isBlank(val)) {
            return def;
        }
        return val;
    }

    public static <T> T fastNotNull(T ... ts) {
        for (T t : ts) {
            if (StringUtil.isBlank(t)) continue;
            return t;
        }
        return null;
    }

    public static String strJoin(List<String> list, String separator) {
        return StringUtils.join(list, (String)separator);
    }

    public static Boolean validateNumber(String str) {
        if (StringUtil.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\d+(\\.\\d+)?$");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String humpToUnderline(String str) {
        if (StringUtil.isBlank((String)str)) {
            return null;
        }
        Pattern compile = Pattern.compile("[A-Z]");
        Matcher matcher = compile.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String underlineTohump(String str) {
        if (StringUtil.isBlank((String)str)) {
            return null;
        }
        str = str.toLowerCase();
        Pattern compile = Pattern.compile("_[a-z]");
        Matcher matcher = compile.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(0).toUpperCase().replace("_", ""));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String upperCaseFast(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String lowerCaseFast(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String addInput(String zddm, Object value) {
        if (StringUtil.isBlank(value)) {
            return "";
        }
        if (value.toString().contains("%")) {
            return " like #{yobj." + zddm + "_like} ";
        }
        return " = #{yobj." + zddm + "} ";
    }

    public static void clEqDate(SysSjglSjzd field, JSONObject yobj) {
        String start;
        String zddm = field.getZddm();
        if (StringUtil.isBlank(yobj.get((Object)zddm))) {
            return;
        }
        String end = null;
        if (yobj.get((Object)zddm) instanceof List) {
            JSONArray value = yobj.getJSONArray(zddm);
            if (StringUtil.isBlank(value)) {
                return;
            }
            start = value.getString(0);
            if (value.size() > 1) {
                end = value.getString(1);
            }
        } else {
            String[] values = yobj.getString(zddm).split(";");
            start = values[0];
            if (values.length > 1) {
                end = values[1];
            }
        }
        String hdgs = field.getKzxxObj().getString("$.yzgz.insert.date.value");
        if ("date".equals(hdgs) || StringUtil.isBlank((String)hdgs)) {
            hdgs = "yyyyMMddHHmmss";
        }
        if (StringUtil.isNotBlank((String)start)) {
            yobj.put(zddm + "_start", (Object)DateUtil.doFormatDate(start, hdgs));
        }
        if (StringUtil.isNotBlank((String)end)) {
            yobj.put(zddm + "_end", (Object)DateUtil.doFormatDate(end, hdgs));
        }
    }

    public static String desEnByField(String data, SysSjglSjzd field) {
        Jmfs jmfsE;
        String jmfs = field.getKzxxObj().getString("$.kjkz.jmsf");
        try {
            jmfsE = Jmfs.valueOf(StringUtil.valByDef(jmfs, "des"));
        }
        catch (IllegalArgumentException e) {
            jmfsE = Jmfs.des;
        }
        return StringUtil.encodeing(data, jmfsE, Conf.getUtilConfig().getData().getPassword(), field.getKzxxObj().getString("$.kjkz.mm"));
    }

    public static String encodeing(String data, Jmfs jmsf, String mm1, String mm2) {
        SM4 sm4 = new SM4();
        switch (jmsf) {
            case md5: {
                return MD5Util.encode(data);
            }
            case sm3: {
                try {
                    return SM3.decode(data);
                }
                catch (Exception e) {
                    throw new MyException("SM3\u52a0\u5bc6\u5931\u8d25\uff1a" + data, e);
                }
            }
            case des: {
                mm2 = StringUtil.isBlank((String)mm2) ? mm1 : DesUtil.encrypt(mm2, mm1);
                return DesUtil.encrypt(data, mm2);
            }
            case sm4ecb: {
                if (StringUtil.isBlank((String)mm2)) {
                    mm2 = mm1;
                } else {
                    sm4.setSecretKey(mm1);
                    mm2 = sm4.encryptDataToString_ECB(mm2);
                }
                sm4.setSecretKey(mm2);
                return sm4.encryptDataToString_ECB(data);
            }
            case sm4cbc: {
                sm4.setSecretKey(mm1);
                if (StringUtil.isBlank((String)mm2)) {
                    sm4.setIv(mm1);
                } else {
                    sm4.setIv(mm2);
                }
                return sm4.encryptDataToString_CBC(data);
            }
            case fmsm1: {
                FMSM1 fmsm1 = new FMSM1(mm1);
                return Base64.getEncoder().encodeToString(fmsm1.InternalSM1Enc(Integer.parseInt(mm2), "CBC", true, data.getBytes(StandardCharsets.UTF_8)));
            }
            case fmsm4: {
                FMSM4 fmsm4 = new FMSM4(mm1);
                return Base64.getEncoder().encodeToString(fmsm4.InternalSM4Enc(Integer.parseInt(mm2), "CBC", true, data.getBytes(StandardCharsets.UTF_8)));
            }
            case sm2: {
                try {
                    return SM2EncDecUtils.encrypt(ByteUtil.hexToByte(mm2), data.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new MyException("sm2\u52a0\u5bc6\u5931\u8d25", e);
                }
            }
            case sm2Dcmy: {
                try {
                    return SM2EncDecUtils.generateKeyPair().toString();
                }
                catch (Exception e) {
                    throw new MyException("sm2\u751f\u6210\u79d8\u94a5\u5931\u8d25\u5931\u8d25", e);
                }
            }
        }
        throw new MyException("\u6682\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\uff1a" + (Object)((Object)jmsf));
    }

    public static String generateKeyPair(String val, String jmsf) {
        switch (jmsf) {
            case "sm2": {
                try {
                    return SM2EncDecUtils.generateKeyPair().toString();
                }
                catch (Exception e) {
                    throw new MyException("\u751f\u6210\u79d8\u94a5\u5931\u8d25\u5931\u8d25", e);
                }
            }
        }
        throw new MyException("\u6682\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\uff1a" + jmsf);
    }

    public static String desDeByField(String data, SysSjglSjzd field) {
        Jmfs jmfs;
        try {
            jmfs = Jmfs.valueOf(StringUtil.valByDef(field.getKzxxObj().getString("$.kjkz.jmsf"), Jmfs.des.name()));
        }
        catch (IllegalArgumentException e) {
            jmfs = Jmfs.des;
        }
        return StringUtil.decodeing(data, jmfs, Conf.getUtilConfig().getData().getPassword(), field.getKzxxObj().getString("$.kjkz.mm"));
    }

    public static String decodeing(String data, Jmfs jmsf, String mm1, String mm2) {
        SM4 sm4 = new SM4();
        switch (jmsf) {
            case md5: {
                throw new MyException("md5\u52a0\u5bc6\u4fe1\u606f\u65e0\u6cd5\u89e3\u5bc6");
            }
            case sm3: {
                throw new MyException("sm3\u52a0\u5bc6\u4fe1\u606f\u65e0\u6cd5\u89e3\u5bc6");
            }
            case des: {
                mm2 = StringUtil.isBlank((String)mm2) ? mm1 : DesUtil.encrypt(mm2, mm1);
                return DesUtil.decrypt(data, mm2);
            }
            case sm4ecb: {
                if (StringUtil.isBlank((String)mm2)) {
                    mm2 = mm1;
                } else {
                    sm4.setSecretKey(mm1);
                    mm2 = sm4.encryptDataToString_ECB(mm2);
                }
                sm4.setSecretKey(mm2);
                return sm4.decryptDataToString_ECB(data);
            }
            case sm4cbc: {
                sm4.setSecretKey(mm1);
                if (StringUtil.isBlank((String)mm2)) {
                    sm4.setIv(mm1);
                } else {
                    sm4.setIv(mm2);
                }
                return sm4.decryptDataToString_CBC(data);
            }
            case fmsm1: {
                FMSM1 fmsm1 = new FMSM1(mm1);
                return new String(fmsm1.InternalSM1Dec(Integer.parseInt(mm2), "CBC", true, Base64.getDecoder().decode(data)));
            }
            case fmsm4: {
                FMSM4 fmsm4 = new FMSM4(mm1);
                return new String(fmsm4.InternalSM4Dec(Integer.parseInt(mm2), "CBC", true, Base64.getDecoder().decode(data)));
            }
            case sm2: {
                try {
                    return new String(SM2EncDecUtils.decrypt(ByteUtil.hexToByte(mm2), ByteUtil.hexToByte(data.toUpperCase())), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new MyException("sm2\u52a0\u5bc6\u5931\u8d25", e);
                }
            }
        }
        throw new MyException("\u6682\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\uff1a" + (Object)((Object)jmsf));
    }

    public static String getSimpleSpell(Reader source) throws PinyinException {
        return StringUtil.getSimpleSpell(Utils.read((Reader)source));
    }

    public static String getSimpleSpell(String source) throws PinyinException {
        if (StringUtil.isBlank((String)source)) {
            return null;
        }
        return PinyinHelper.getShortPinyin((String)source).toUpperCase();
    }

    public static String getFullSpell(Reader source) throws PinyinException {
        return StringUtil.getFullSpell(Utils.read((Reader)source));
    }

    public static String getFullSpell(String source) throws PinyinException {
        if (StringUtil.isBlank((String)source)) {
            return null;
        }
        return PinyinHelper.convertToPinyinString((String)source, (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE).toUpperCase();
    }

    public static String bytesToHexString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (byte b : byteArray) {
            if ((b & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & b));
        }
        return hexString.toString().toLowerCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (StringUtil.isEmpty((String)hexString)) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    public static String toUtf8(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                LogFactory.get().debug(s + "\u8f6c\u6362\u5f02\u5e38", new Object[]{ex});
                b = new byte[]{};
            }
            for (int n : b) {
                int k = n;
                if (k < 0) {
                    k += 256;
                }
                sb.append("%").append(Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static int whether(Object obj) {
        return TypeUtils.castToBoolean((Object)obj) != false ? Ljpd.TURE.getCode() : Ljpd.FALSE.getCode();
    }

    public static JSONArray buildTree(List<JSONObject> list, String upkey, String key) {
        return StringUtil.buildTree(list, upkey, key, null);
    }

    public static JSONArray buildTree(List<JSONObject> list, String upkey, String key, String rootKey) {
        if (StringUtil.isBlank((String)rootKey)) {
            rootKey = "_root";
        }
        JSONObject zdUpnode = new JSONObject(true);
        for (JSONObject zd : list) {
            String upnode = StringUtil.valByDef(zd.getString(upkey), rootKey);
            JSONArray upnodeObj = zdUpnode.getJSONArray(upnode);
            if (upnodeObj == null) {
                upnodeObj = new JSONArray();
                zdUpnode.put(upnode, (Object)upnodeObj);
            }
            upnodeObj.add((Object)zd);
        }
        JSONArray zdTree = new JSONArray();
        if (!zdUpnode.containsKey((Object)rootKey)) {
            return zdTree;
        }
        zdTree.addAll((Collection)zdUpnode.getJSONArray(rootKey));
        zdUpnode.remove((Object)rootKey);
        StringUtil.buildTree(zdTree, zdUpnode, key);
        return zdTree;
    }

    private static void buildTree(JSONArray list, JSONObject zdUpnode, String key) {
        for (int i = 0; i < list.size(); ++i) {
            JSONObject zd = list.getJSONObject(i);
            JSONArray children = zdUpnode.getJSONArray(zd.getString(key));
            if (children == null) continue;
            zdUpnode.remove((Object)zd.getString(key));
            zd.put(KEY_CHILDREN, (Object)children);
            StringUtil.buildTree(children, zdUpnode, key);
        }
    }

    public static String substrByByte(Object obj, int maxLength) {
        if (StringUtil.isBlank(obj)) {
            return "";
        }
        String str = obj.toString();
        long length = str.getBytes(StandardCharsets.UTF_8).length;
        if (length <= (long)maxLength) {
            return str;
        }
        if ((str = str.substring(0, (int)((long)maxLength * (long)str.length() / length))).getBytes(StandardCharsets.UTF_8).length > maxLength) {
            return StringUtil.substrByByte(str, maxLength);
        }
        return str;
    }
}

