/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import com.alibaba.fastjson.JSONObject;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

public class JVMUtil {
    public static JSONObject getProcessList() {
        JSONObject result = new JSONObject();
        try {
            MonitoredHost local = MonitoredHost.getMonitoredHost("localhost");
            HashSet<Integer> vmlist = new HashSet<Integer>(local.activeVms());
            for (Object e : vmlist) {
                MonitoredVm vm = local.getMonitoredVm(new VmIdentifier("//" + e));
                String processname = MonitoredVmUtil.mainClass(vm, true);
                result.put(e.toString(), (Object)processname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.split("@")[0];
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindow() {
        return JVMUtil.getOsName().contains("Windows");
    }

    public static String getSysEncoding() {
        return JVMUtil.isWindow() ? "GBK" : "UTF-8";
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

