/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import ch.qos.logback.core.util.FileSize;
import cn.benma666.exception.BusinessException;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.IFile;
import com.alibaba.druid.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil
extends FileUtils {
    private static final Log log = LogFactory.getLog(FileUtil.class);

    public static String getFileMD5(File file) throws Exception {
        return FileUtil.getFileMD5(new FileInputStream(file));
    }

    public static String getFileMD5(InputStream in) throws Exception {
        return FileUtil.getFileMD5(Utils.readByteArray((InputStream)in));
    }

    public static String getFileMD5(byte[] bArr) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(bArr, 0, bArr.length);
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    public static void closeStream(Closeable is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            log.debug((Object)"\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
        }
    }

    public static byte[] toBytes(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        finally {
            os.flush();
        }
        return os.toByteArray();
    }

    public static void deleteDir(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] list = file.listFiles();
        if (list != null) {
            for (File f1 : list) {
                if (f1.isDirectory()) {
                    FileUtil.deleteDir(f1.getAbsolutePath());
                    continue;
                }
                if (f1.delete()) continue;
                throw new BusinessException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + f1.getAbsolutePath());
            }
        }
        if (!file.delete()) {
            throw new BusinessException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + file.getAbsolutePath());
        }
    }

    public static Long getFilelength(IFile file, long xwj, long dwj) {
        long endLength = file.length();
        try {
            Thread.sleep(xwj);
        }
        catch (InterruptedException e) {
            log.debug((Object)"\u7ebf\u7a0b\u4e2d\u65ad", (Throwable)e);
        }
        long lastLength = file.length();
        if (lastLength == endLength) {
            return endLength;
        }
        endLength = lastLength;
        do {
            lastLength = endLength;
            try {
                Thread.sleep(dwj);
            }
            catch (InterruptedException e) {
                log.debug((Object)"\u7ebf\u7a0b\u4e2d\u65ad", (Throwable)e);
            }
            endLength = file.length();
            log.trace((Object)(" last :" + lastLength + "---- end:" + endLength));
        } while (lastLength != endLength);
        return endLength;
    }

    public static String getFilePath(String ... path) {
        String fp = FileUtil.getPath(path);
        if (StringUtil.isNotBlank((String)fp) && fp.length() > 1) {
            return fp.substring(0, fp.length() - 1);
        }
        return fp;
    }

    public static String getPath(String ... path) {
        if (path == null) {
            path = new String[]{};
        }
        StringBuilder fp = new StringBuilder();
        for (String p : path) {
            if (StringUtil.isBlank((String)p)) continue;
            fp.append(p).append("/");
        }
        String fps = fp.toString().replace("\\", "/");
        while (fps.contains("//")) {
            fps = fps.replace("//", "/");
        }
        return fps;
    }

    public static String getMLFromPath(String filePath) {
        return new File(filePath).getParent();
    }

    public static String getNameFromPath(String filePath) {
        return new File(filePath).getName();
    }

    public static long getSizeByStr(String str) {
        return FileSize.valueOf((String)str).getSize();
    }
}

