/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import cn.benma666.myutils.StringUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil
extends DateUtils {
    private static final Log log = LogFactory.getLog(DateUtil.class);
    public static final String DATE_FORMATTER_L = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMATTER_S = "yyyy-MM-dd";
    public static final String DATE_FORMATTER17 = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMATTER14 = "yyyyMMddHHmmss";
    public static final String DATE_FORMATTER10 = "yyyyMMddHH";
    public static final String DATE_FORMATTER8 = "yyyyMMdd";
    public static final SimpleDateFormat sdf14 = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat sdf19 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date parseDate(String dateStr) {
        return DateUtil.parseDate(dateStr, false);
    }

    public static Date parseDate(String dateStr, boolean lenient) {
        if (StringUtil.isEmpty((String)dateStr)) {
            return null;
        }
        String parse = dateStr;
        SimpleDateFormat format = null;
        parse = parse.replaceFirst("^(18|19|20|21){1}[0-9]{2}([^0-9]?)", "yyyy$2");
        parse = parse.replaceFirst("^[0-9]{2}([^0-9]?)", "yy$1");
        parse = parse.replaceFirst("([^0-9]?)(1{1}[0-2]{1}|0?[1-9]{1})([^0-9]?)", "$1MM$3");
        parse = parse.replaceFirst("([^0-9]?)(3{1}[0-1]{1}|[0-2]?[0-9]{1})([^0-9]?)", "$1dd$3");
        parse = parse.replaceFirst("([^0-9]?)(2[0-3]{1}|[0-1]?[0-9]{1})([^0-9]?)", "$1HH$3");
        parse = parse.replaceFirst("([^0-9]?)[0-5]?[0-9]{1}([^0-9]?)", "$1mm$2");
        parse = parse.replaceFirst("([^0-9]?)[0-5]?[0-9]{1}([^0-9]?)", "$1ss$2");
        parse = parse.replaceFirst("([^0-9]?)[0-9]{1,3}([^0-9]*)", "$1SSS$2");
        try {
            if (!parse.startsWith("yy") || !parse.contains("MM")) {
                log.debug((Object)String.format("\u65e5\u671f\u683c\u5f0f\u6ca1\u6709\u7cbe\u786e\u5230\u6708\uff1a%s-->%s", parse, dateStr));
                return null;
            }
            format = new SimpleDateFormat(parse);
            format.setLenient(lenient);
            Date date = format.parse(dateStr);
            return date;
        }
        catch (Exception e) {
            log.debug((Object)String.format("\u65e5\u671f\u89e3\u6790\u51fa\u9519\uff1a%s-->%s", parse, dateStr), (Throwable)e);
            return null;
        }
    }

    public static String dateToStr14(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return sdf14.format((Date)value);
        }
        if (value instanceof Long) {
            return sdf14.format(DateUtil.longToDate((Long)value));
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date sqlDate = (java.sql.Date)value;
            return sdf14.format(new Date(sqlDate.getTime()));
        }
        Date val = DateUtil.parseDate(value.toString());
        if (val == null) {
            return null;
        }
        return sdf14.format(val);
    }

    public static int getSeasons(Date date) {
        int m = DateUtil.getMonth(date);
        if (m <= 0) {
            return 0;
        }
        if (m < 4) {
            return 1;
        }
        if (m < 7) {
            return 2;
        }
        if (m < 10) {
            return 3;
        }
        if (m < 13) {
            return 4;
        }
        return 0;
    }

    public static Date getNowSeasonsFirstDay(Date date) {
        int m = DateUtil.getSeasons(date);
        if (m > 0) {
            return DateUtil.parseDate(DateUtil.getYear(date) + "-" + (3 * m + 1) + "-01");
        }
        return null;
    }

    public static Date getYearLastDay(String year) {
        if (year == null || "".equals(year)) {
            return null;
        }
        Date nd = DateUtil.parseDate(year + "-01-01");
        return DateUtil.addDays((Date)DateUtil.addYears((Date)nd, (int)1), (int)-1);
    }

    public static Date getNextMonthFirstDay(String year, String month) {
        if (year == null || "".equals(year) || month == null || "".equals(month)) {
            return null;
        }
        Date nd = DateUtil.parseDate(year + "-" + month + "-01");
        return DateUtil.addMonths((Date)nd, (int)1);
    }

    public static Date getMonthLastDay(String year, String month) {
        if (year == null || "".equals(year) || month == null || "".equals(month)) {
            return null;
        }
        Date nd = DateUtil.parseDate(year + "-" + month + "-01");
        return DateUtil.addDays((Date)DateUtil.addMonths((Date)nd, (int)1), (int)-1);
    }

    public static int compareMonth(Date st, Date end) {
        int y = Math.abs((DateUtil.getYear(end) < 0 ? 0 : DateUtil.getYear(end)) - (DateUtil.getYear(st) < 0 ? 0 : DateUtil.getYear(st)));
        int m = 0;
        if (y > 0) {
            --y;
            m = Math.abs(12 - DateUtil.getMonth(st) + DateUtil.getMonth(end));
        } else {
            m = Math.abs(DateUtil.getMonth(end) - DateUtil.getMonth(st));
        }
        return y * 12 + m;
    }

    public static long compare(Date start, Date end) {
        if (start != null && end != null) {
            return end.getTime() - start.getTime();
        }
        return 0L;
    }

    public static boolean compareDate(Date date) {
        if (date != null) {
            return date.before(DateUtil.parseDate(DateUtil.doFormatDate(new Date(), DATE_FORMATTER_S)));
        }
        return false;
    }

    public static String doFormatDate(String date, String format) {
        return DateUtil.doFormatDate(DateUtil.parseDate(date), format);
    }

    public static String doFormatDate(long date, String format) {
        return DateUtil.doFormatDate(new Date(date), format);
    }

    public static String doFormatDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static int getYear() {
        return DateUtil.getYear(new Date());
    }

    public static int getYear(Date date) {
        if (date == null) {
            return -1;
        }
        return DateUtil.DateToCalendar(date).get(1);
    }

    public static int getMonth() {
        return DateUtil.getMonth(new Date());
    }

    public static int getMonth(Date date) {
        if (date == null) {
            return 0;
        }
        return DateUtil.DateToCalendar(date).get(2) + 1;
    }

    public static int getDay() {
        return DateUtil.getDay(new Date());
    }

    public static int getDay(Date da) {
        if (da == null) {
            return 0;
        }
        return DateUtil.DateToCalendar(da).get(5);
    }

    public static Calendar DateToCalendar(Date dd) {
        Calendar cc = Calendar.getInstance();
        cc.setTime(dd);
        return cc;
    }

    public static Date longToDate(long datenum) {
        Calendar cc = Calendar.getInstance();
        cc.setTimeInMillis(datenum);
        return cc.getTime();
    }

    public static String longToDateString(long datenum) {
        return DateUtil.doFormatDate(DateUtil.longToDate(datenum), DATE_FORMATTER_L);
    }

    public static Date getUpWeekDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(date);
        int week = cc.get(7);
        return DateUtils.addDays((Date)date, (int)(1 - week));
    }

    public static Date getMonday(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(date);
        int week = cc.get(7);
        return DateUtils.addDays((Date)date, (int)(2 - week));
    }

    public static int getWeek(Date date) {
        if (date == null) {
            return -1;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTime(date);
        int week = cc.get(7);
        week = week == 1 ? 7 : --week;
        return week;
    }

    public static Timestamp dateToTime(Date dt) {
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getTime());
    }

    public static Timestamp string2Time(String dateString) throws ParseException {
        Timestamp dateTime = new Timestamp(DateUtil.parseDate(dateString).getTime());
        return dateTime;
    }

    public static java.sql.Date dateToSqlDate(Date de) {
        return new java.sql.Date(de.getTime());
    }

    public static String getDateTimeStr(String format) {
        return DateUtil.doFormatDate(new Date(), format);
    }

    public static String getDateTimeStr(String format, int jiaTian) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, jiaTian);
        return DateUtil.doFormatDate(cal.getTime(), format);
    }

    public static String getDateTimeStr() {
        return DateUtil.getDateTimeStr(DATE_FORMATTER_L);
    }

    public static String getGabDate() {
        return DateUtil.getDateTimeStr(DATE_FORMATTER14);
    }

    public static Date getCurrDate() {
        return new Date();
    }

    public static Duration pareSjScStr(String str) {
        return Duration.parse("PT" + str);
    }

    public static long scSjStrToLong(String str) {
        return Duration.parse("PT" + str).toMillis();
    }

    public static Duration pareScStr(String str) {
        return Duration.parse(str);
    }

    public static long scStrToLong(String str) {
        return Duration.parse(str).toMillis();
    }
}

