/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import java.text.ParseException;
import java.util.Date;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public class CronUtil {
    public static long getLastTriggerTime(String cron) {
        if (!CronExpression.isValidExpression((String)cron)) {
            return 0L;
        }
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("Caclulate Date").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
        Date time0 = trigger.getStartTime();
        Date time1 = trigger.getFireTimeAfter(time0);
        Date time2 = trigger.getFireTimeAfter(time1);
        Date time3 = trigger.getFireTimeAfter(time2);
        long l = time1.getTime() - (time3.getTime() - time2.getTime());
        return l;
    }

    public static long getNextTriggerTime(String cron) {
        if (!CronExpression.isValidExpression((String)cron)) {
            return 0L;
        }
        try {
            CronExpression cronExpression = new CronExpression(cron);
            return cronExpression.getNextValidTimeAfter(new Date()).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }
}

