/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.myutils;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public class ByteUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String[] BIN_String = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmpd[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String getHexString(byte[] bytes) {
        return ByteUtil.getHexString(bytes, true);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return upperCase ? ret.toString().toUpperCase() : ret.toString();
    }

    public static void printHexString(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            System.out.print("0x" + hex.toUpperCase() + ",");
        }
        System.out.println("");
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtil.charToByte(hexChars[pos]) << 4 | ByteUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] data) {
        return ByteUtil.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return ByteUtil.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        return ByteUtil.encodeHexString(data, toDigits).toCharArray();
    }

    public static String encodeHexString(byte[] data) {
        return ByteUtil.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return ByteUtil.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexString(byte[] data, char[] toDigits) {
        int l = data.length;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < l; ++i) {
            out.append(toDigits[(0xF0 & data[i]) >>> 4]);
            out.append(toDigits[0xF & data[i]]);
        }
        return out.toString();
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < len; i += 2) {
            out.write((ByteUtil.toDigit(data[i], i) << 4 | ByteUtil.toDigit(data[i + 1], i + 1)) & 0xFF);
        }
        return out.toByteArray();
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String StringToAsciiString(String content) {
        StringBuilder result = new StringBuilder();
        for (char c : content.toCharArray()) {
            result.append(Integer.toHexString(c));
        }
        return result.toString();
    }

    public static String hexStringToString(String hexString, int encodeType) {
        StringBuilder result = new StringBuilder();
        int max = hexString.length() / encodeType;
        for (int i = 0; i < max; ++i) {
            char c = (char)ByteUtil.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result.append(c);
        }
        return result.toString();
    }

    public static int hexStringToAlgorism(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        StringBuffer sb = new StringBuffer();
        for (char c : hex.toCharArray()) {
            sb.append(BIN_String[ByteUtil.charToByte(c)]);
        }
        return sb.toString();
    }

    public static String AsciiStringToString(String content) {
        StringBuffer result = new StringBuffer();
        int length = content.length() / 2;
        for (int i = 0; i < length; i += 2) {
            String c = content.substring(i, i + 2);
            int a = ByteUtil.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result.append(d);
        }
        return result.toString();
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return ByteUtil.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytearray) {
        StringBuilder resultBuffer = new StringBuilder();
        for (byte b : bytearray) {
            resultBuffer.append(b);
        }
        return resultBuffer.toString();
    }

    public static int binaryToAlgorism(String binary) {
        return Integer.parseInt(binary, 2);
    }

    public static String algorismToHEXString(int algorism) {
        String result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < maxLength - str.length(); ++i) {
            sb.append("0");
        }
        str = (sb.toString() + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (hex.length() < 1) {
            return null;
        }
        byte[] result = new byte[hex.length() / 2];
        int j = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            result[j++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return result;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() < 2) {
                hex = "0" + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] subByte(byte[] input, int startIndex, int length) {
        return Arrays.copyOfRange(input, startIndex, startIndex + length);
    }
}

