/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.json;

import cn.benma666.domain.BasicBean;
import cn.benma666.exception.MyException;
import cn.benma666.myutils.ClassUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final ParserConfig defaultRedisConfig = new ParserConfig();

    public static void copy(Object mb, Object ly, String path) {
        JSONPath.set((Object)mb, (String)path, (Object)JSONPath.eval((Object)ly, (String)path));
    }

    public static String objToStr(Object o) {
        return new String(JSON.toJSONBytes((Object)o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}), IOUtils.UTF8);
    }

    public static <T> T strToObj(String str, Class<T> t) {
        return (T)JSON.parseObject((String)str, t, (ParserConfig)defaultRedisConfig, (Feature[])new Feature[0]);
    }

    public static <T> T clone(T o) {
        return (T)JsonUtil.strToObj(JsonUtil.objToStr(o), Object.class);
    }

    public static JSONObject mergeJSONObjects(JSONObject newObj, JSONObject ... jsonObjects) {
        if (newObj == null) {
            newObj = new JSONObject(true);
        }
        for (JSONObject obj : jsonObjects) {
            JsonUtil.mergeJSONObject(newObj, obj);
        }
        return newObj;
    }

    public static JSONObject mergeJSONObject(JSONObject newObj, BasicBean obj) {
        JsonUtil.mergeJSONObject(newObj, obj.toJSONObject());
        return newObj;
    }

    public static <T extends BasicBean> T mergeJSONObject(T newObj, Object obj) {
        JSONObject json;
        if (obj instanceof JSONObject) {
            json = (JSONObject)obj;
        } else if (obj instanceof BasicBean) {
            json = ((BasicBean)obj).toJSONObject();
        } else {
            throw new MyException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + obj.getClass());
        }
        for (Map.Entry e : json.entrySet()) {
            if (e.getValue() == null) continue;
            Object val = ClassUtil.getVal((String)e.getKey(), null, newObj);
            if (val instanceof JSONObject) {
                if (e.getValue() instanceof JSONObject) {
                    JsonUtil.mergeJSONObject((JSONObject)val, (JSONObject)e.getValue());
                    continue;
                }
                if (e.getValue() instanceof BasicBean) {
                    JsonUtil.mergeJSONObject((JSONObject)val, (BasicBean)e.getValue());
                    continue;
                }
                throw new MyException("\u5bf9\u8c61\u5408\u5e76\u5f02\u5e38\uff0c\u6a21\u677f\u662fjson\u5bf9\u8c61\uff0c\u6765\u6e90\u4e3a\uff1a" + e.getValue().getClass().getName());
            }
            if (val instanceof BasicBean) {
                if (e.getValue() instanceof JSONObject) {
                    JsonUtil.mergeJSONObject((BasicBean)val, e.getValue());
                    continue;
                }
                if (e.getValue() instanceof BasicBean) {
                    JsonUtil.mergeJSONObject((BasicBean)val, e.getValue());
                    continue;
                }
                throw new MyException("\u5bf9\u8c61\u5408\u5e76\u5f02\u5e38\uff0c\u6a21\u677f\u662fjson\u5bf9\u8c61\uff0c\u6765\u6e90\u4e3a\uff1a" + e.getValue().getClass().getName());
            }
            ClassUtil.setVal((String)e.getKey(), e.getValue(), newObj);
        }
        return newObj;
    }

    public static <T> JSONObject mergeJSONObject(JSONObject newObj, Map<String, T> obj) {
        if (obj == null) {
            return newObj;
        }
        for (Map.Entry<String, T> e : obj.entrySet()) {
            JSONObject nk;
            if (">delete".equals(e.getValue())) {
                newObj.remove((Object)e.getKey());
                continue;
            }
            if (newObj.get((Object)e.getKey()) instanceof BasicBean) {
                JsonUtil.mergeJSONObject((BasicBean)newObj.get((Object)e.getKey()), e.getValue());
                continue;
            }
            if (e.getValue() instanceof BasicBean) {
                nk = newObj.getJSONObject(e.getKey());
                if (nk == null) {
                    newObj.put(e.getKey(), e.getValue());
                    continue;
                }
                JsonUtil.mergeJSONObject(nk, (BasicBean)e.getValue());
                newObj.put(e.getKey(), JSON.parseObject((String)JSON.toJSONString((Object)nk, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), newObj.get((Object)e.getKey()).getClass()));
                continue;
            }
            if (e.getValue() instanceof JSONObject) {
                nk = newObj.getJSONObject(e.getKey());
                if (nk == null) {
                    newObj.put(e.getKey(), e.getValue());
                    continue;
                }
                JsonUtil.mergeJSONObject(nk, (JSONObject)e.getValue());
                if (newObj.get((Object)e.getKey()) instanceof BasicBean) {
                    newObj.put(e.getKey(), JSON.parseObject((String)JSON.toJSONString((Object)nk, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), newObj.get((Object)e.getKey()).getClass()));
                    continue;
                }
                newObj.put(e.getKey(), (Object)nk);
                continue;
            }
            if (e.getValue() instanceof List) {
                nk = newObj.getJSONArray(e.getKey());
                if (nk == null) {
                    nk = new JSONArray();
                    newObj.put(e.getKey(), (Object)nk);
                }
                nk.addAll((List)e.getValue());
                newObj.put(e.getKey(), (Object)nk);
                continue;
            }
            newObj.put(e.getKey(), e.getValue());
        }
        return newObj;
    }

    static {
        defaultRedisConfig.setAutoTypeSupport(true);
    }
}

