/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.iframe;

import cn.benma666.exception.MyException;
import cn.benma666.iframe.MyParams;
import cn.benma666.iframe.PageInfo;
import cn.benma666.myutils.StringUtil;
import cn.hutool.log.LogFactory;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class Result
extends JSONObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DATE_TYPE = "dateType";
    public static final String STATUS = "status";
    public static final String CODE = "code";
    public static final String MSG = "msg";
    public static final String DATA = "data";
    public static final String QQID = "qqid";

    public Result() {
    }

    public Result(boolean status) {
        this(status, "");
    }

    public Result(boolean status, String msg) {
        this(status, msg, null);
    }

    public Result(boolean status, String msg, Object data) {
        this.put(DATE_TYPE, "application/json");
        this.put(STATUS, status);
        this.put(CODE, status ? 200 : 400);
        this.put(MSG, msg);
        this.put(DATA, data);
    }

    public static Result success(String msg) {
        return new Result(true, msg);
    }

    public static Result success(String msg, Object data) {
        return new Result(true, msg, data);
    }

    public static Result failed(String msg) {
        return new Result(false, msg);
    }

    public static Result failed(String msg, Object data) {
        return new Result(false, msg, data);
    }

    public static Result parse(Map<String, Object> map) {
        Result r = new Result(TypeUtils.castToBoolean((Object)map.get(STATUS)));
        r.putAll(map);
        return r;
    }

    public static Result parse(String str) {
        return Result.parse(str, Feature.OrderedField);
    }

    public static Result parse(String str, Feature ... features) {
        return Result.parse((Map<String, Object>)Result.parseObject((String)str, (Feature[])features));
    }

    public void addMsg(String msg) {
        if (StringUtil.isBlank((String)msg)) {
            return;
        }
        String msg1 = this.getString(MSG);
        if (StringUtil.isNotBlank((String)msg1)) {
            msg1 = msg1 + "\uff0c";
        }
        msg1 = msg1 + msg;
        this.put(MSG, msg1);
    }

    public boolean isStatus() {
        return this.getBoolean(STATUS);
    }

    public void setStatus(boolean status) {
        this.put(STATUS, status);
    }

    public String getMsg() {
        return this.getString(MSG);
    }

    public void setMsg(String msg) {
        this.put(MSG, msg);
    }

    public int getCode() {
        return this.getIntValue(CODE);
    }

    public void setCode(int code) {
        this.put(CODE, code);
    }

    public String getQqid() {
        return this.getString(QQID);
    }

    public void setQqid(String qqid) {
        this.put(QQID, qqid);
    }

    public Object getData() {
        return this.get(DATA);
    }

    public <R> R getData(Class<R> t) {
        Object o = this.get(DATA);
        return o == null ? null : (R)t.cast(o);
    }

    public <R> List<R> getPageList(Class<R> t) {
        return this.getData(PageInfo.class).getList(t);
    }

    public void setData(Object data) {
        this.put(DATA, data);
    }

    public String getDateType() {
        return this.getString(DATE_TYPE);
    }

    public void setDateType(String dateType) {
        this.put(DATE_TYPE, dateType);
    }

    public String toString() {
        if (this.getData() instanceof MyParams) {
            JSONObject t = ((JSONObject)this.getData()).clone();
            this.put(DATA, t);
        }
        try {
            return super.toString(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Throwable t) {
            LogFactory.get().error("\u8be5Result\u8f6c\u4e3a\u5b57\u7b26\u4e32\u5931\u8d25", new Object[]{t});
            return Result.failed("\u8be5Result\u8f6c\u4e3a\u5b57\u7b26\u4e32\u5931\u8d25\uff1a" + t.getMessage()).toString();
        }
    }

    public MyException newMyException() {
        MyException e = new MyException(this.getMsg(), this.getData());
        e.setCode(this.getCode());
        return e;
    }
}

