/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.iframe;

import cn.benma666.domain.BasicBean;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.List;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;

public class PageInfo<T>
extends BasicBean
implements Serializable,
PageRequest<T>,
PageResult<T> {
    private static final long serialVersionUID = 1L;
    private boolean totalRequired = true;
    private boolean listRequired = true;
    private long pageNumber = 1L;
    private int pageSize = 10;
    private long totalRow = -1L;
    private long totalPage;
    private List<T> list;
    private String orderBy;

    public PageInfo(List<T> list, int pageSize, int totalRow, int pageNumber) {
        this.list = list;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        this.setTotalRow(totalRow);
    }

    public boolean isTotalRequired() {
        return this.totalRequired;
    }

    public void setTotalRequired(boolean totalRequired) {
        this.totalRequired = totalRequired;
    }

    public boolean isListRequired() {
        return this.listRequired;
    }

    public void setListRequired(boolean listRequired) {
        this.listRequired = listRequired;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getList() {
        return this.list;
    }

    public <R> List<R> getList(Class<R> t) {
        return JSON.parseArray((String)this.list.toString(), t);
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(long totalRow) {
        if (this.pageSize > 0 && totalRow > 0L) {
            this.setTotalPage(totalRow / (long)this.pageSize + (long)(totalRow % (long)this.pageSize > 0L ? 1 : 0));
            if (this.getPageNumber() > this.getTotalPage()) {
                this.setPageNumber(this.getTotalPage());
            }
        }
        this.totalRow = totalRow;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    @Override
    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public PageResult<T> of(List<T> result) {
        this.setList(result);
        return this;
    }

    public PageResult<T> of(List<T> result, Long total) {
        this.setList(result);
        this.setTotalRow(total);
        return this;
    }

    public static <T> PageInfoBuilder<T> builder() {
        return new PageInfoBuilder();
    }

    public PageInfo() {
    }

    public PageInfo(boolean totalRequired, boolean listRequired, long pageNumber, int pageSize, long totalRow, long totalPage, List<T> list, String orderBy) {
        this.totalRequired = totalRequired;
        this.listRequired = listRequired;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalRow = totalRow;
        this.totalPage = totalPage;
        this.list = list;
        this.orderBy = orderBy;
    }

    public static class PageInfoBuilder<T> {
        private boolean totalRequired;
        private boolean listRequired;
        private long pageNumber;
        private int pageSize;
        private long totalRow;
        private long totalPage;
        private List<T> list;
        private String orderBy;

        PageInfoBuilder() {
        }

        public PageInfoBuilder<T> totalRequired(boolean totalRequired) {
            this.totalRequired = totalRequired;
            return this;
        }

        public PageInfoBuilder<T> listRequired(boolean listRequired) {
            this.listRequired = listRequired;
            return this;
        }

        public PageInfoBuilder<T> pageNumber(long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public PageInfoBuilder<T> pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PageInfoBuilder<T> totalRow(long totalRow) {
            this.totalRow = totalRow;
            return this;
        }

        public PageInfoBuilder<T> totalPage(long totalPage) {
            this.totalPage = totalPage;
            return this;
        }

        public PageInfoBuilder<T> list(List<T> list) {
            this.list = list;
            return this;
        }

        public PageInfoBuilder<T> orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public PageInfo<T> build() {
            return new PageInfo<T>(this.totalRequired, this.listRequired, this.pageNumber, this.pageSize, this.totalRow, this.totalPage, this.list, this.orderBy);
        }

        public String toString() {
            return "PageInfo.PageInfoBuilder(totalRequired=" + this.totalRequired + ", listRequired=" + this.listRequired + ", pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", totalRow=" + this.totalRow + ", totalPage=" + this.totalPage + ", list=" + this.list + ", orderBy=" + this.orderBy + ")";
        }
    }
}

