/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.iframe;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.iframe.DictManager;
import cn.benma666.iframe.InterfaceThreadPool;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;

public class MyLogBackAppender<E extends ILoggingEvent>
extends UnsynchronizedAppenderBase<E> {
    private static InterfaceThreadPool tp;
    protected Encoder<E> encoder;
    protected Encoder<E> msgEncoder;
    private String dbName = "default";
    private String insertSql;

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setInsertSql(String insertSql) {
        this.insertSql = insertSql;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public void start() {
        int errors = 0;
        if (this.encoder == null) {
            this.addStatus((Status)new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", (Object)this));
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    public void setLayout(Layout<E> layout) {
        LayoutWrappingEncoder lwe = new LayoutWrappingEncoder();
        lwe.setLayout(layout);
        lwe.setContext(this.context);
        this.encoder = lwe;
    }

    public void setMsgLayout(Layout<E> layout) {
        LayoutWrappingEncoder lwe = new LayoutWrappingEncoder();
        lwe.setLayout(layout);
        lwe.setContext(this.context);
        this.msgEncoder = lwe;
    }

    protected void append(E e) {
        if (tp != null) {
            tp.run(() -> this.clrz(e));
        } else {
            this.clrz(e);
        }
    }

    public void clrz(E e) {
        try {
            String msg = new String(this.msgEncoder.encode(e));
            for (String hl : DictManager.zdMap("SYS_LOG_HTRZ_HL").keySet()) {
                if (!msg.contains(hl)) continue;
                return;
            }
            String[] msgs = new String(this.encoder.encode(e)).split("#!#");
            JSONObject p = JSON.parseObject((String)msgs[0]);
            p.put("message", (Object)StringUtil.substrByByte(msg, 4000));
            p.put("id", (Object)StringUtil.getUUIDUpperStr());
            p.put("ssxm", (Object)Conf.getAppdm());
            Db.use(this.dbName).update(this.insertSql, (Map<String, Object>)p);
        }
        catch (MyException msg) {
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage() + ":" + new String(this.encoder.encode(e)));
            ex.printStackTrace();
        }
    }

    public static InterfaceThreadPool getTp() {
        return tp;
    }

    public static void setTp(InterfaceThreadPool tp) {
        MyLogBackAppender.tp = tp;
    }
}

