/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.iframe;

import cn.benma666.dict.Zdlb;
import cn.benma666.domain.SysSjglSjzt;
import cn.benma666.exception.BusinessException;
import cn.benma666.exception.DictException;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.CacheFactory;
import cn.benma666.iframe.MyParams;
import cn.benma666.iframe.PageInfo;
import cn.benma666.myutils.StringUtil;
import cn.benma666.myutils.TmplUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.beetl.sql.core.SqlId;

public class DictManager
extends BasicObject {
    public static final String NOCACHE = "_nocache";
    public static final String TREE = "_tree";
    public static final String LBSQL = "_lbsql";
    private static final JSONObject dictCache = CacheFactory.use("dict");

    public static void clearDict() {
        dictCache.clear();
    }

    public static void clearDict(String zdlb) {
        dictCache.remove((Object)zdlb);
        dictCache.remove((Object)(zdlb + NOCACHE));
        dictCache.remove((Object)(zdlb + TREE));
        dictCache.remove((Object)(zdlb + LBSQL));
    }

    private static JSONObject zdlbToSql(MyParams myParams) {
        String lbsql;
        String zdlb = myParams.getString("$.yobj.zdlb");
        JSONObject zdlbObj = dictCache.getJSONObject(zdlb + LBSQL);
        if (zdlbObj == null) {
            zdlbObj = Db.use().findFirst(SqlId.of((String)"util", (String)"findTyzdLbsql"), (Map<String, Object>)((Object)myParams));
            if (zdlbObj == null) {
                throw new DictException("\u8be5\u5b57\u5178\u7c7b\u522b\u4e0d\u5b58\u5728" + myParams.getJSONObject("yobj"));
            }
            lbsql = zdlbObj.getString("lbsql");
            if (!DictManager.isBlank(lbsql) && lbsql.startsWith("ds=")) {
                String ysjztdm = lbsql.substring(3).trim();
                String sjztdm = TmplUtil.buildStr(ysjztdm, (Map<String, Object>)((Object)myParams));
                JSONObject dbObj = DictManager.zdObjByDm(Zdlb.SYS_COMMON_SJZT.name(), sjztdm);
                if (dbObj == null) {
                    throw new DictException("\u6ca1\u627e\u5230\u6570\u636e\u8f7d\u4f53\uff1a" + sjztdm);
                }
                myParams.put("sjzt", dbObj.toJavaObject(SysSjglSjzt.class));
                lbsql = Db.getZdSqlTmpl(myParams, "zd." + zdlb, dbObj.getString("lx"));
                if (!lbsql.contains(";ds=")) {
                    lbsql = lbsql + ";ds=" + sjztdm;
                }
                if (DictManager.isBlank(lbsql)) {
                    throw new DictException("\u6ca1\u6709\u5728\u914d\u7f6e\u4e2d\u8bbe\u7f6e\u8be5\u5b57\u5178\u7c7b\u522b\u6570\u636e\u83b7\u53d6\u7684sql\uff1a" + zdlb);
                }
                if (sjztdm.equals(ysjztdm)) {
                    dictCache.put(zdlb + LBSQL, (Object)zdlbObj);
                }
            } else {
                dictCache.put(zdlb + LBSQL, (Object)zdlbObj);
            }
            zdlbObj.put("lbsqlYs", (Object)lbsql);
        }
        if (zdlbObj.getIntValue("sjdj") < DictManager.valByDef(myParams.getIntValue("$.user.yhdj"), -1)) {
            throw new BusinessException("\u6ca1\u6709\u8bbf\u95ee\u8be5\u5b57\u5178\u7684\u6743\u9650\uff1a" + zdlb);
        }
        lbsql = zdlbObj.getString("lbsqlYs");
        String defaultVal = Db.use().getSourceSql(SqlId.of((String)"util", (String)"findTyzdMrsql"), (Map<String, Object>)((Object)myParams));
        if (StringUtil.isBlank((String)lbsql)) {
            lbsql = defaultVal;
        } else {
            myParams.set("$.sql.defaultSql", defaultVal);
            lbsql = TmplUtil.buildStrSql(lbsql, (Map<String, Object>)((Object)myParams));
            if (lbsql.startsWith("error:")) {
                throw new DictException(lbsql.substring("error:".length()));
            }
        }
        zdlbObj = zdlbObj.clone();
        zdlbObj.put("lbsql", (Object)lbsql);
        return zdlbObj;
    }

    public static JSONObject zdMapNoCache(MyParams myParams) {
        JSONObject zdlbObj = DictManager.zdlbToSql(myParams);
        String zdlb = myParams.getString("$.yobj.zdlb");
        if (!zdlbObj.getBooleanValue("cache")) {
            if (!dictCache.containsKey((Object)zdlb)) {
                dictCache.put(zdlb + NOCACHE, (Object)true);
                dictCache.put(zdlb, (Object)new JSONObject());
            }
            return null;
        }
        String expStr = zdlbObj.getString("lbsql");
        String[] exps = Db.parseDictExp(expStr);
        myParams.set("$.sql.defaultSql", exps[1]);
        JSONObject result = new JSONObject(true);
        result.putAll(DictManager.db(exps[0]).findMap("dm", SqlId.of((String)"util", (String)"findTyzdSjlb"), (Map<String, Object>)((Object)myParams)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject zdMap(MyParams myParams) {
        DictManager.zdlbToSql(myParams);
        String zdlb = myParams.getString("$.yobj.zdlb");
        if (dictCache.containsKey((Object)(zdlb + NOCACHE))) {
            return null;
        }
        JSONObject l = dictCache.getJSONObject(zdlb);
        if (l != null) {
            return l;
        }
        JSONObject jSONObject = dictCache;
        synchronized (jSONObject) {
            l = dictCache.getJSONObject(zdlb);
            if (l == null && (l = DictManager.zdMapNoCache(myParams)) != null) {
                dictCache.put(zdlb, (Object)l);
            }
        }
        return l;
    }

    public static JSONObject zdMap(String zdlb) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        return DictManager.zdMap(myParams);
    }

    public static JSONArray zdTreeNoCache(MyParams myParams) {
        String zdlb = myParams.getString("$.yobj.zdlb");
        JSONObject zdlbObj = DictManager.zdlbToSql(myParams);
        String expStr = zdlbObj.getString("lbsql");
        String[] exps = Db.parseDictExp(expStr);
        myParams.set("$.sql.defaultSql", exps[1]);
        List<JSONObject> zdList = DictManager.db(exps[0]).find(SqlId.of((String)"util", (String)"findTyzdSjlb"), (Map<String, Object>)((Object)myParams));
        JSONArray l = StringUtil.buildTree(zdList, "upnode", "dm");
        if (zdlbObj.getBooleanValue("cache")) {
            dictCache.put(zdlb + TREE, (Object)l);
        }
        return l;
    }

    public static JSONArray zdTree(MyParams myParams) {
        DictManager.zdlbToSql(myParams);
        String zdlb = myParams.getString("$.yobj.zdlb");
        JSONArray l = dictCache.getJSONArray(zdlb + TREE);
        if (l == null) {
            l = DictManager.zdTreeNoCache(myParams);
        }
        return l;
    }

    public static JSONArray zdTree(String zdlb) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        return DictManager.zdTree(myParams);
    }

    public static JSONObject zdObjNoCache(MyParams myParams) {
        JSONObject zdlbObj = DictManager.zdlbToSql(myParams);
        String[] exps = Db.parseDictExp(zdlbObj.getString("lbsql"));
        myParams.set("$.sql.defaultSql", exps[1]);
        return DictManager.db(exps[0]).findFirst(SqlId.of((String)"util", (String)"findTyzdSjx"), (Map<String, Object>)((Object)myParams));
    }

    public static JSONObject zdObj(MyParams myParams) {
        DictManager.zdlbToSql(myParams);
        String zdlb = myParams.getString("$.yobj.zdlb");
        String dm = myParams.getString("$.yobj.dm");
        String mc = myParams.getString("$.yobj.mc");
        JSONObject result = null;
        JSONObject zc = dictCache.getJSONObject(zdlb);
        if (zc == null) {
            DictManager.zdMap(myParams);
            zc = dictCache.getJSONObject(zdlb);
        }
        if (zc.getInnerMap().containsKey(dm != null ? dm : mc)) {
            result = zc.getJSONObject(dm != null ? dm : mc);
        } else if (dictCache.containsKey((Object)(zdlb + NOCACHE))) {
            result = DictManager.zdObjNoCache(myParams);
            zc.put(dm != null ? dm : mc, (Object)result);
        } else if (StringUtil.isNotBlank((String)mc)) {
            for (JSONObject obj : zc.values().toArray(new JSONObject[0])) {
                if (mc.equals(obj.getString("mc"))) {
                    result = obj;
                    break;
                }
                JSONArray list = obj.getJSONArray("$.kzxx.jrmc");
                if (DictManager.isBlank(list) || !list.contains((Object)mc)) continue;
                result = obj;
                break;
            }
        }
        return result;
    }

    public static JSONObject zdObjByDm(String zdlb, String dm) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        myParams.set("$.yobj.dm", dm);
        return DictManager.zdObj(myParams);
    }

    public static String zdMcByDm(String zdlb, String dm) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        myParams.set("$.yobj.dm", dm);
        JSONObject r = DictManager.zdObj(myParams);
        if (r == null) {
            return dm;
        }
        return r.getString("mc");
    }

    public static String zdDmByMc(String zdlb, String mc) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        myParams.set("$.yobj.mc", mc);
        JSONObject r = DictManager.zdObj(myParams);
        if (r == null) {
            return mc;
        }
        return r.getString("dm");
    }

    public static String zdMcByMoreDm(MyParams myParams) {
        JSONObject r = DictManager.zdObjByMoreDm(myParams);
        StringBuilder mc = new StringBuilder();
        for (String s : r.keySet()) {
            JSONObject obj = r.getJSONObject(s);
            mc.append("\u3001").append(obj == null ? s : obj.getString("mc"));
        }
        if (mc.length() > 0) {
            return mc.substring(1);
        }
        return mc.toString();
    }

    public static String zdMcByMoreDm(String zdlb, String dm) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        myParams.set("$.yobj.dm", dm);
        return DictManager.zdMcByMoreDm(myParams);
    }

    public static JSONObject zdObjByMoreDm(MyParams myParams) {
        String dm = myParams.getString("$.yobj.dm");
        JSONObject result = new JSONObject(true);
        if (StringUtils.isNotBlank((String)dm)) {
            String[] dms;
            for (String s : dms = dm.split(",")) {
                myParams.set("$.yobj.dm", s);
                JSONObject obj = DictManager.zdObj(myParams);
                result.put(s, (Object)obj);
            }
        }
        return result;
    }

    public static JSONObject zdObjByMoreDm(String zdlb, String dm) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        myParams.set("$.yobj.dm", dm);
        return DictManager.zdObjByMoreDm(myParams);
    }

    public static String zdDmByMoreMc(MyParams myParams) {
        String mc = myParams.getString("$.yobj.mc");
        if (StringUtils.isNotBlank((String)mc)) {
            String[] mcs = mc.replace(",", "\u3001").split("\u3001");
            StringBuilder dm = new StringBuilder();
            for (String s : mcs) {
                myParams.set("$.yobj.mc", s);
                JSONObject obj = DictManager.zdObj(myParams);
                dm.append(",").append(obj == null ? s : obj.getString("dm"));
            }
            return dm.substring(1);
        }
        return "";
    }

    public static String zdDmByMoreMc(String zdlb, String mc) {
        MyParams myParams = new MyParams();
        myParams.set("$.yobj.zdlb", zdlb);
        myParams.set("$.yobj.mc", mc);
        return DictManager.zdDmByMoreMc(myParams);
    }

    public static PageInfo<JSONObject> zdSearch(MyParams myParams) {
        JSONObject zdlbObj = DictManager.zdlbToSql(myParams);
        String[] exps = Db.parseDictExp(zdlbObj.getString("lbsql"));
        myParams.set("$.sql.defaultSql", exps[1]);
        PageInfo<JSONObject> page = myParams.page();
        page = DictManager.db(exps[0]).queryPage(page, SqlId.of((String)"util", (String)"findTyzdSjss"), (Map<String, Object>)((Object)myParams));
        return page;
    }
}

