/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.iframe;

import cn.benma666.config.Benma666;
import cn.benma666.dict.Zdlb;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.BasicObject;
import cn.benma666.iframe.Benma666Conf;
import cn.benma666.iframe.ConfAbstract;
import cn.benma666.iframe.DictManager;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Properties;

public class Conf
extends BasicObject {
    public static final String CONFIG_LIST = "benma666.config-list";
    public static final String[] emptyConfigArr = new String[0];
    private static String[] configArr;
    private static ConfAbstract<?> config;
    private static Benma666 utilConfig;

    public static void defaultInit() {
        utilConfig = new Benma666();
        utilConfig.setDebug(true);
        utilConfig.setConfigList(Zdlb.SYS_COMMON_APPCONFIG.name());
        Conf.defaultInit(utilConfig);
    }

    public static void defaultInit(Benma666 benma666) {
        if (benma666 == null) {
            throw new MyException("\u9ed8\u8ba4\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        utilConfig = benma666;
        Conf.setConfig(new Benma666Conf(benma666));
    }

    public static String getVal(String key, String defVal) {
        return Conf.valByDef(Conf.getVal(key), defVal);
    }

    public static String getVal(String key) {
        String value = Conf.getValByConfig(key);
        if (value == null && Db.isDefaultInit()) {
            value = Conf.getValByDict(key);
        }
        return value;
    }

    public static String getValByDict(String key) {
        String cc;
        if (CONFIG_LIST.equals(key)) {
            return null;
        }
        String value = null;
        for (int i = Conf.getConfigArr().length - 1; i > -1 && key.equals(value = DictManager.zdMcByDm(cc = configArr[i], key)); --i) {
        }
        if (key.equals(value)) {
            value = null;
        }
        return value;
    }

    public static String getValByConfig(String key) {
        return Conf.getConfig().getVal(key);
    }

    public static JSONObject getJSONObject(String key) {
        String val = Conf.getVal(key);
        if (StringUtil.isNotBlank((String)val)) {
            return JSON.parseObject((String)val);
        }
        return new JSONObject();
    }

    public static ConfAbstract<?> getConfig() {
        if (config == null) {
            throw new MyException("\u7cfb\u7edf\u5916\u90e8\u914d\u7f6e\u672a\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u4f7f\u7528\u914d\u7f6e\u8bfb\u53d6");
        }
        return config;
    }

    public static void setConfig(ConfAbstract<?> config) {
        Conf.config = config;
    }

    public static Properties getPropertiesByDict() {
        Properties p = new Properties();
        for (int i = Conf.getConfigArr().length - 1; i > -1; --i) {
            String cc = configArr[i];
            JSONObject map = DictManager.zdMap(cc);
            if (Conf.isBlank(map)) continue;
            for (String key : map.keySet()) {
                p.put(key, map.getJSONObject(key).getString("mc"));
            }
        }
        return p;
    }

    public static String[] getConfigArr() {
        if (configArr == null) {
            String cf = config.getVal(CONFIG_LIST);
            if (StringUtil.isBlank((String)cf)) {
                return emptyConfigArr;
            }
            configArr = cf.split(",");
        }
        return configArr;
    }

    public static String getAppdm() {
        return utilConfig.getAppDm();
    }

    public static Benma666 getUtilConfig() {
        return utilConfig;
    }

    public static void setUtilConfig(Benma666 utilConfig) {
        Conf.utilConfig = utilConfig;
    }
}

