/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.exception;

import cn.benma666.iframe.Result;
import cn.benma666.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(MyException.class);
    private static final long serialVersionUID = 1463806345429361813L;
    private int code = 400;
    private Object data;

    public MyException() {
    }

    public MyException(String message) {
        this(message, null);
    }

    public MyException(String message, Throwable cause) {
        this(message, cause, null, cause == null ? 400 : 500, null);
    }

    public MyException(String message, Throwable cause, String nbxx) {
        this(message, cause, null, cause == null ? 400 : 500, nbxx);
    }

    public MyException(String message, Object data) {
        this(message, null, data, 400, null);
    }

    public MyException(String message, int code, Object data) {
        this(message, null, data, code, null);
    }

    public MyException(String message, Throwable cause, Object data, int code, String nbxx) {
        super(message);
        this.initCause(cause);
        this.setData(data);
        this.setCode(code);
        if (cause != null && !MyException.class.isAssignableFrom(cause.getClass())) {
            if (code == 500) {
                log.error(nbxx, (Throwable)this);
            } else if (code != 200) {
                log.debug(nbxx, (Throwable)this);
            }
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Result getResult() {
        String msg = this.getMessage();
        Result r = new Result(this.getCode() == 200, msg, JsonUtil.clone(this.data));
        r.setCode(this.getCode());
        return r;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (this.getCause() != this && this.getCause() != null) {
            msg = msg + "->" + this.getCause().getMessage();
        }
        return msg;
    }
}

