/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.excel;

import cn.benma666.myutils.DateUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XlsxReader
extends DefaultHandler {
    protected Log log = LogFactory.getLog(this.getClass());
    private String cellType;
    private int cellS;
    private StylesTable stylesTable;
    private SharedStrings sst;
    private String lastContents;
    private boolean nextIsString;
    protected OPCPackage pkg;
    protected InputStream sheet;
    private int sheetIndex = -1;
    private final List<String> rowlist = new ArrayList<String>();
    protected int curRow = 0;
    protected int curCol = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readOneSheet(String path) throws Exception {
        this.pkg = OPCPackage.open((String)path, (PackageAccess)PackageAccess.READ);
        XSSFReader r = new XSSFReader(this.pkg);
        SharedStrings sst = r.getSharedStringsTable();
        this.stylesTable = r.getStylesTable();
        XMLReader parser = this.fetchSheetParser(sst);
        this.sheet = (InputStream)r.getSheetsData().next();
        InputSource sheetSource = new InputSource(this.sheet);
        try {
            parser.parse(sheetSource);
        }
        finally {
            if (this.sheet != null) {
                try {
                    this.sheet.close();
                }
                catch (Exception e) {
                    this.log.info((Object)("\u5173\u95edexcel\u5931\u8d25\uff0c" + e.getMessage()));
                }
            }
            if (this.pkg != null) {
                try {
                    this.pkg.close();
                }
                catch (Exception e) {
                    this.log.info((Object)("\u5173\u95edexcel\u5931\u8d25\uff0c" + e.getMessage()));
                }
            }
        }
    }

    public void process(String path) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)path);
        XSSFReader r = new XSSFReader(pkg);
        SharedStrings sst = r.getSharedStringsTable();
        XMLReader parser = this.fetchSheetParser(sst);
        Iterator sheets = r.getSheetsData();
        while (sheets.hasNext()) {
            this.curRow = 0;
            ++this.sheetIndex;
            InputStream sheet = (InputStream)sheets.next();
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
    }

    public void optRow(int sheetIndex, int curRow, List<String> rowList) throws RuntimeException {
        StringBuilder temp = new StringBuilder();
        for (String str : rowList) {
            temp.append(str).append("_");
        }
        System.out.println(curRow + "||" + temp);
    }

    public XMLReader fetchSheetParser(SharedStrings sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.sst = sst;
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("c")) {
            String cellLocation = attributes.getValue("r");
            this.curCol = XlsxReader.extractColumnNumber(cellLocation) - 1;
            this.cellType = attributes.getValue("t");
            this.nextIsString = this.cellType != null && this.cellType.equals("s");
            this.cellS = attributes.getValue("s") == null ? -1 : Integer.parseInt(attributes.getValue("s"));
        }
        this.lastContents = "";
    }

    public static int extractColumnNumber(String position) {
        int startIndex;
        for (startIndex = 0; !Character.isDigit(position.charAt(startIndex)) && startIndex < position.length(); ++startIndex) {
        }
        String colPart = position.substring(0, startIndex);
        return XlsxReader.parseColumnNumber(colPart);
    }

    public static int parseColumnNumber(String columnIndicator) {
        int col = 0;
        for (int i = columnIndicator.length() - 1; i >= 0; --i) {
            char c = columnIndicator.charAt(i);
            int offset = 1 + Character.getNumericValue(c) - Character.getNumericValue('A');
            col = (int)((double)col + Math.pow(26.0, columnIndicator.length() - i - 1) * (double)offset);
        }
        return col;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString && name.equals("v")) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getItemAt(idx).getString()).toString();
            }
            catch (Exception e) {
                this.log.error((Object)"\u83b7\u53d6\u5355\u5143\u683c\u5b57\u7b26\u4e32\u503c\u5931\u8d25", (Throwable)e);
            }
        }
        if (name.equals("v")) {
            try {
                double d;
                long numFmtId;
                if (this.cellType == null && this.cellS > 0 && this.cellIsDate(numFmtId = this.stylesTable.getCellXfAt(this.cellS).getNumFmtId()) && org.apache.poi.ss.usermodel.DateUtil.isValidExcelDate((double)(d = Double.parseDouble(this.lastContents)))) {
                    this.lastContents = DateUtil.doFormatDate(org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)d, (boolean)false), "yyyy-MM-dd HH:mm:ss");
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"\u89e3\u6790\u4e3a\u65f6\u95f4\u9519\u8bef", (Throwable)e);
            }
            while (this.rowlist.size() < this.curCol) {
                this.rowlist.add("");
            }
            this.rowlist.add(this.curCol, this.lastContents);
            ++this.curCol;
        } else if (name.equals("row")) {
            this.optRow(this.sheetIndex, this.curRow, this.rowlist);
            this.rowlist.clear();
            ++this.curRow;
            this.curCol = 0;
        }
    }

    public boolean cellIsDate(long numFmtId) {
        String numFmt = this.stylesTable.getNumberFormatAt((short)numFmtId);
        if (numFmt == null) {
            return numFmtId == 22L || numFmtId == 14L;
        }
        return (numFmt = numFmt.toLowerCase()).contains("yy") && numFmt.contains("m") || numFmt.contains("h") && numFmt.contains("m") || numFmt.contains("d") && numFmt.contains("m");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }
}

